/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.util.introspection;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Locale;
import java.util.Objects;
import org.assertj.core.configuration.ConfigurationProvider;
import org.assertj.core.util.Preconditions;
import org.assertj.core.util.Strings;
import org.assertj.core.util.VisibleForTesting;
import org.assertj.core.util.introspection.IntrospectionError;

public final class Introspection {
    private static boolean bareNamePropertyMethods = true;

    public static Method getPropertyGetter(String propertyName, Object target) {
        Method getter;
        Preconditions.checkNotNullOrEmpty(propertyName);
        Objects.requireNonNull(target);
        try {
            getter = Introspection.findGetter(propertyName, target);
            if (Modifier.isPublic(getter.getModifiers())) {
                getter.setAccessible(true);
            }
            getter.invoke(target, new Object[0]);
        }
        catch (Exception t) {
            throw new IntrospectionError(Introspection.propertyNotFoundErrorMessage(propertyName, target), t);
        }
        return getter;
    }

    public static void setExtractBareNamePropertyMethods(boolean barenamePropertyMethods) {
        ConfigurationProvider.loadRegisteredConfiguration();
        bareNamePropertyMethods = barenamePropertyMethods;
    }

    @VisibleForTesting
    public static boolean canIntrospectExtractBareNamePropertyMethods() {
        return bareNamePropertyMethods;
    }

    private static String propertyNotFoundErrorMessage(String propertyName, Object target) {
        String targetTypeName = target.getClass().getName();
        String property = Strings.quote(propertyName);
        Method getter = Introspection.findGetter(propertyName, target);
        if (getter == null) {
            return String.format("No getter for property %s in %s", property, targetTypeName);
        }
        if (!Modifier.isPublic(getter.getModifiers())) {
            return String.format("No public getter for property %s in %s", property, targetTypeName);
        }
        return String.format("Unable to find property %s in %s", property, targetTypeName);
    }

    private static Method findGetter(String propertyName, Object target) {
        String capitalized = propertyName.substring(0, 1).toUpperCase(Locale.ENGLISH) + propertyName.substring(1);
        Method getter = Introspection.findMethod("get" + capitalized, target);
        if (Introspection.isValidGetter(getter)) {
            return getter;
        }
        if (bareNamePropertyMethods && Introspection.isValidGetter(getter = Introspection.findMethod(propertyName, target))) {
            return getter;
        }
        Method isAccessor = Introspection.findMethod("is" + capitalized, target);
        return Introspection.isValidGetter(isAccessor) ? isAccessor : null;
    }

    private static boolean isValidGetter(Method method) {
        return method != null && !Modifier.isStatic(method.getModifiers());
    }

    private static Method findMethod(String name, Object target) {
        Class<?> clazz = target.getClass();
        try {
            return clazz.getMethod(name, new Class[0]);
        }
        catch (NoSuchMethodException | SecurityException exception) {
            while (clazz != null) {
                try {
                    return clazz.getDeclaredMethod(name, new Class[0]);
                }
                catch (NoSuchMethodException | SecurityException exception2) {
                    clazz = clazz.getSuperclass();
                }
            }
            return null;
        }
    }

    private Introspection() {
    }
}

