#!/bin/bash
# -----------------------------------------------------------------------
# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.
# -----------------------------------------------------------------------

# !!!!!
# !!!!! Used by agent as defined in default.ducc.properties
# !!!!!

# Sums up swap use of a process with a given PID as reported by /proc/<PID>/smaps file

for swap in `grep Swap /proc/$1/smaps 2>/dev/null|awk '{print $2}'`; 
do  
let sum=$sum+$swap; 
done 
echo $sum

