/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import java.io.PrintStream;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.CastExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMinor;
import net.sf.saxon.functions.StringJoin;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.instruct.Block;
import net.sf.saxon.instruct.ParentNodeConstructor;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.instruct.ValueOf;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.pull.UnconstructedDocument;
import net.sf.saxon.tinytree.TinyBuilder;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.TextFragmentValue;
import net.sf.saxon.value.UntypedAtomicValue;

public class DocumentInstr
extends ParentNodeConstructor {
    private boolean textOnly;
    private String constantText;

    public DocumentInstr(boolean bl, String string, String string2) {
        this.textOnly = bl;
        this.constantText = string;
        this.setBaseURI(string2);
    }

    public int getImplementationMethod() {
        return 1;
    }

    public void setValidationAction(int n) {
        this.validation = n;
    }

    public boolean isTextOnly() {
        return this.textOnly;
    }

    public Expression simplify(StaticContext staticContext) throws XPathException {
        this.setLazyConstruction(staticContext.getConfiguration().isLazyConstructionMode());
        return super.simplify(staticContext);
    }

    public Expression typeCheck(StaticContext staticContext, ItemType itemType) throws XPathException {
        Expression expression = super.typeCheck(staticContext, itemType);
        return expression;
    }

    protected void checkContentForAttributes(StaticContext staticContext) throws XPathException {
        if (this.content instanceof Block) {
            TypeHierarchy typeHierarchy = staticContext.getConfiguration().getTypeHierarchy();
            Expression[] expressionArray = ((Block)this.content).getChildren();
            for (int i = 0; i < expressionArray.length; ++i) {
                ItemType itemType = expressionArray[i].getItemType(typeHierarchy);
                if (!(itemType instanceof NodeTest)) continue;
                int n = ((NodeTest)itemType).getNodeKindMask();
                if (n == 4) {
                    DynamicError dynamicError = new DynamicError("Cannot create an attribute node whose parent is a document node");
                    dynamicError.setErrorCode(this.isXSLT() ? "XTDE0420" : "XPTY0004");
                    dynamicError.setLocator(this);
                    throw dynamicError;
                }
                if (n != 8192) continue;
                DynamicError dynamicError = new DynamicError("Cannot create a namespace node whose parent is a document node");
                dynamicError.setErrorCode(this.isXSLT() ? "XTDE0420" : "XQTY0024");
                dynamicError.setLocator(this);
                throw dynamicError;
            }
        }
    }

    public Expression getStringValueExpression(StaticContext staticContext) {
        if (this.textOnly) {
            if (this.constantText != null) {
                return new StringLiteral(new UntypedAtomicValue(this.constantText));
            }
            if (this.content instanceof ValueOf) {
                return ((ValueOf)this.content).convertToStringJoin(staticContext);
            }
            StringJoin stringJoin = (StringJoin)SystemFunction.makeSystemFunction("string-join", 2, staticContext.getNamePool());
            Expression[] expressionArray = new Expression[]{this.content, new StringLiteral(StringValue.EMPTY_STRING)};
            stringJoin.setArguments(expressionArray);
            CastExpression castExpression = new CastExpression(stringJoin, BuiltInAtomicType.UNTYPED_ATOMIC, false);
            return castExpression;
        }
        throw new AssertionError((Object)"getStringValueExpression() called on non-text-only document instruction");
    }

    public ItemType getItemType(TypeHierarchy typeHierarchy) {
        return NodeKindTest.DOCUMENT;
    }

    public TailCall processLeavingTail(XPathContext xPathContext) throws XPathException {
        Item item = this.evaluateItem(xPathContext);
        if (item != null) {
            SequenceReceiver sequenceReceiver = xPathContext.getReceiver();
            sequenceReceiver.append(item, this.locationId, 2);
        }
        return null;
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        DocumentInfo documentInfo;
        if (this.isLazyConstruction()) {
            return new UnconstructedDocument(this, xPathContext);
        }
        Controller controller = xPathContext.getController();
        if (this.textOnly) {
            CharSequence charSequence;
            if (this.constantText != null) {
                charSequence = this.constantText;
            } else {
                Item item;
                FastStringBuffer fastStringBuffer = new FastStringBuffer(100);
                SequenceIterator sequenceIterator = this.content.iterate(xPathContext);
                while ((item = sequenceIterator.next()) != null) {
                    fastStringBuffer.append(item.getStringValueCS());
                }
                charSequence = fastStringBuffer.condense();
            }
            documentInfo = new TextFragmentValue(charSequence, this.getBaseURI());
            documentInfo.setConfiguration(controller.getConfiguration());
        } else {
            try {
                XPathContextMinor xPathContextMinor = xPathContext.newMinorContext();
                xPathContextMinor.setOrigin(this);
                TinyBuilder tinyBuilder = new TinyBuilder();
                tinyBuilder.setLineNumbering(controller.getConfiguration().isLineNumbering());
                TinyBuilder tinyBuilder2 = tinyBuilder;
                tinyBuilder.setBaseURI(this.getBaseURI());
                PipelineConfiguration pipelineConfiguration = controller.makePipelineConfiguration();
                pipelineConfiguration.setHostLanguage(this.getHostLanguage());
                tinyBuilder2.setPipelineConfiguration(pipelineConfiguration);
                xPathContextMinor.changeOutputDestination(null, tinyBuilder2, false, this.getHostLanguage(), this.validation, this.getSchemaType());
                SequenceReceiver sequenceReceiver = xPathContextMinor.getReceiver();
                sequenceReceiver.open();
                sequenceReceiver.startDocument(0);
                this.content.process(xPathContextMinor);
                sequenceReceiver.endDocument();
                sequenceReceiver.close();
                documentInfo = (DocumentInfo)tinyBuilder.getCurrentRoot();
            }
            catch (XPathException xPathException) {
                if (xPathException.getLocator() == null) {
                    xPathException.setLocator(this);
                }
                if (xPathException instanceof DynamicError && ((DynamicError)xPathException).getXPathContext() == null) {
                    ((DynamicError)xPathException).setXPathContext(xPathContext);
                }
                throw xPathException;
            }
        }
        return documentInfo;
    }

    public int getInstructionNameCode() {
        return 142;
    }

    public void display(int n, PrintStream printStream, Configuration configuration) {
        printStream.println(ExpressionTool.indent(n) + "document-constructor");
        this.content.display(n + 1, printStream, configuration);
    }
}

