/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.aae.controller;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Semaphore;
import org.apache.uima.aae.controller.AnalysisEngineInstancePool;
import org.apache.uima.aae.error.AsynchAEException;
import org.apache.uima.analysis_engine.AnalysisEngine;

public class AnalysisEngineInstancePoolWithThreadAffinity
implements AnalysisEngineInstancePool {
    private static final Class CLASS_NAME = AnalysisEngineInstancePoolWithThreadAffinity.class;
    private volatile boolean destroyAEInstanceIfFree = false;
    private Semaphore lock = new Semaphore(1);
    private Map<Long, AnalysisEngine> aeInstanceMap = new HashMap<Long, AnalysisEngine>();

    @Override
    public int size() {
        return this.aeInstanceMap.size();
    }

    @Override
    public void checkin(AnalysisEngine anAnalysisEngine) throws Exception {
        try {
            this.lock.acquireUninterruptibly();
            if (this.destroyAEInstanceIfFree) {
                anAnalysisEngine.destroy();
            } else {
                this.aeInstanceMap.put(Thread.currentThread().getId(), anAnalysisEngine);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public boolean exists() {
        return this.aeInstanceMap.containsKey(Thread.currentThread().getId());
    }

    @Override
    public AnalysisEngine checkout() throws Exception {
        try {
            this.lock.acquireUninterruptibly();
            if (!this.exists()) {
                throw new AsynchAEException("AE instance not found in AE pool. Most likely due to service quiescing");
            }
            AnalysisEngine analysisEngine = this.aeInstanceMap.remove(Thread.currentThread().getId());
            return analysisEngine;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public void destroy() throws Exception {
        this.destroyAEInstanceIfFree = true;
    }
}

