/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.conceptMapper.dictionaryCompiler;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import org.apache.uima.UIMAFramework;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.conceptMapper.support.dictionaryResource.DictionaryResource_impl;
import org.apache.uima.resource.ResourceSpecifier;
import org.apache.uima.util.XMLInputSource;

public class CompileDictionary {
    private static final String DICTIONARY_RESOURCE_NAME = "/DictionaryFile";

    public static void main(String[] args) throws Exception {
        String dictionaryResourceName = DICTIONARY_RESOURCE_NAME;
        if (args.length != 2) {
            if (args.length == 3) {
                dictionaryResourceName = args[2];
            } else {
                CompileDictionary.usage();
                System.exit(17);
            }
        }
        AnalysisEngineDescription conceptMapperDesc = UIMAFramework.getXMLParser().parseAnalysisEngineDescription(new XMLInputSource(args[0]));
        AnalysisEngine ae = UIMAFramework.produceAnalysisEngine((ResourceSpecifier)conceptMapperDesc);
        DictionaryResource_impl dict = (DictionaryResource_impl)ae.getResourceManager().getResource(dictionaryResourceName);
        BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(args[1]));
        dict.serializeEntries(output);
        ((OutputStream)output).close();
        ae.destroy();
        System.exit(0);
    }

    public static String getCurClassName() {
        return new ClassNameFinder().getClassName();
    }

    public static void usage() {
        System.out.println("USAGE: " + CompileDictionary.getCurClassName() + ": <pathToDescriptor> <outputFileName> [<resourceName>]");
    }

    public static class ClassNameFinder
    extends SecurityManager {
        public String getClassName() {
            return this.getClassContext()[1].getName();
        }
    }
}

