/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.verbalize;

import java.util.Iterator;
import java.util.List;
import org.apache.uima.ruta.condition.AbstractRutaCondition;
import org.apache.uima.ruta.condition.AfterCondition;
import org.apache.uima.ruta.condition.AndCondition;
import org.apache.uima.ruta.condition.BeforeCondition;
import org.apache.uima.ruta.condition.ContainsCondition;
import org.apache.uima.ruta.condition.ContextCountCondition;
import org.apache.uima.ruta.condition.CountCondition;
import org.apache.uima.ruta.condition.CurrentCountCondition;
import org.apache.uima.ruta.condition.EndsWithCondition;
import org.apache.uima.ruta.condition.FeatureCondition;
import org.apache.uima.ruta.condition.IfCondition;
import org.apache.uima.ruta.condition.ImplicitCondition;
import org.apache.uima.ruta.condition.InListCondition;
import org.apache.uima.ruta.condition.IsCondition;
import org.apache.uima.ruta.condition.LastCondition;
import org.apache.uima.ruta.condition.MOfNCondition;
import org.apache.uima.ruta.condition.MacroCondition;
import org.apache.uima.ruta.condition.NearCondition;
import org.apache.uima.ruta.condition.NotCondition;
import org.apache.uima.ruta.condition.OrCondition;
import org.apache.uima.ruta.condition.ParseCondition;
import org.apache.uima.ruta.condition.PartOfCondition;
import org.apache.uima.ruta.condition.PartOfNeqCondition;
import org.apache.uima.ruta.condition.PositionCondition;
import org.apache.uima.ruta.condition.RegExpCondition;
import org.apache.uima.ruta.condition.ScoreCondition;
import org.apache.uima.ruta.condition.SizeCondition;
import org.apache.uima.ruta.condition.StartsWithCondition;
import org.apache.uima.ruta.condition.TotalCountCondition;
import org.apache.uima.ruta.condition.VoteCondition;
import org.apache.uima.ruta.expression.list.ListExpression;
import org.apache.uima.ruta.expression.number.INumberExpression;
import org.apache.uima.ruta.expression.number.SimpleNumberExpression;
import org.apache.uima.ruta.expression.string.IStringExpression;
import org.apache.uima.ruta.verbalize.RutaVerbalizer;

public class ConditionVerbalizer {
    private RutaVerbalizer verbalizer;

    public ConditionVerbalizer(RutaVerbalizer verbalizer) {
        this.verbalizer = verbalizer;
    }

    public String verbalizeName(AbstractRutaCondition condition) {
        if (condition instanceof AndCondition) {
            return "AND";
        }
        if (condition instanceof ContainsCondition) {
            String name = "CONTAINS";
            return name;
        }
        if (condition instanceof ContextCountCondition) {
            String name = "CONTEXTCOUNT";
            return name;
        }
        if (condition instanceof CountCondition) {
            String name = "COUNT";
            return name;
        }
        if (condition instanceof CurrentCountCondition) {
            String name = "CURRENTCOUNT";
            return name;
        }
        if (condition instanceof IfCondition) {
            String name = "IF";
            return name;
        }
        if (condition instanceof InListCondition) {
            return "INLIST";
        }
        if (condition instanceof LastCondition) {
            return "LAST";
        }
        if (condition instanceof MOfNCondition) {
            return "MOFN";
        }
        if (condition instanceof NearCondition) {
            String name = "NEAR";
            return name;
        }
        if (condition instanceof NotCondition) {
            return "NOT";
        }
        if (condition instanceof OrCondition) {
            return "OR";
        }
        if (condition instanceof PartOfCondition) {
            return "PARTOF";
        }
        if (condition instanceof PartOfNeqCondition) {
            return "PARTOFNEQ";
        }
        if (condition instanceof PositionCondition) {
            return "POSITION";
        }
        if (condition instanceof RegExpCondition) {
            return "REGEXP";
        }
        if (condition instanceof ScoreCondition) {
            String name = "SCORE";
            return name;
        }
        if (condition instanceof TotalCountCondition) {
            String name = "TOTALCOUNT";
            return name;
        }
        if (condition instanceof VoteCondition) {
            String name = "VOTE";
            return name;
        }
        if (condition instanceof FeatureCondition) {
            String name = "FEATURE";
            return name;
        }
        if (condition instanceof ParseCondition) {
            String name = "PARSE";
            return name;
        }
        if (condition instanceof IsCondition) {
            String name = "IS";
            return name;
        }
        if (condition instanceof BeforeCondition) {
            String name = "BEFORE";
            return name;
        }
        if (condition instanceof AfterCondition) {
            String name = "AFTER";
            return name;
        }
        if (condition instanceof StartsWithCondition) {
            String name = "STARTSWITH";
            return name;
        }
        if (condition instanceof EndsWithCondition) {
            String name = "ENDSWITH";
            return name;
        }
        if (condition instanceof SizeCondition) {
            String name = "SIZE";
            return name;
        }
        if (condition instanceof ImplicitCondition) {
            String name = "";
            return name;
        }
        if (condition instanceof MacroCondition) {
            MacroCondition mc = (MacroCondition)condition;
            return mc.getName();
        }
        return condition.getClass().getSimpleName();
    }

    public String verbalize(AbstractRutaCondition condition) {
        String name = this.verbalizeName(condition) + "(";
        if (condition instanceof AndCondition) {
            AndCondition c = (AndCondition)condition;
            List<AbstractRutaCondition> conditions = c.getConditions();
            StringBuilder sb = new StringBuilder();
            sb.append(name);
            Iterator<AbstractRutaCondition> it = conditions.iterator();
            while (it.hasNext()) {
                AbstractRutaCondition each = it.next();
                sb.append(this.verbalize(each));
                if (!it.hasNext()) continue;
                sb.append(", ");
            }
            sb.append(")");
            return sb.toString();
        }
        if (condition instanceof ContainsCondition) {
            ContainsCondition c = (ContainsCondition)condition;
            INumberExpression minE = c.getMin();
            String min = this.verbalizeMin(minE, 1);
            INumberExpression maxE = c.getMax();
            String max = this.verbalizeMax(maxE, Integer.MAX_VALUE);
            String percent = this.verbalizer.verbalize(c.getPercent());
            String string = percent = !percent.equals("false") ? ", " + percent : "";
            if (c.getType() != null) {
                String type = this.verbalizer.verbalize(c.getType());
                return name + type + min + max + percent + ")";
            }
            return name + this.verbalizer.verbalize(c.getArgList()) + ", " + this.verbalizer.verbalize(c.getArg()) + min + max + percent + ")";
        }
        if (condition instanceof ContextCountCondition) {
            ContextCountCondition c = (ContextCountCondition)condition;
            String type = this.verbalizer.verbalize(c.getType());
            INumberExpression minE = c.getMin();
            String min = this.verbalizeMin(minE, Integer.MIN_VALUE);
            INumberExpression maxE = c.getMax();
            String max = this.verbalizeMax(maxE, Integer.MAX_VALUE);
            String var = c.getVar() == null ? "" : ", " + c.getVar();
            return name + type + min + max + var + ")";
        }
        if (condition instanceof CountCondition) {
            CountCondition c = (CountCondition)condition;
            if (c.getArg() == null) {
                String type = this.verbalizer.verbalize(c.getType());
                INumberExpression minE = c.getMin();
                String min = this.verbalizeMin(minE, Integer.MIN_VALUE);
                INumberExpression maxE = c.getMax();
                String max = this.verbalizeMax(maxE, Integer.MAX_VALUE);
                String var = c.getVar() == null ? "" : ", " + c.getVar();
                return name + type + min + max + var + ")";
            }
            String list = this.verbalizer.verbalize(c.getArgList());
            String arg = this.verbalizer.verbalize(c.getArg());
            INumberExpression minE = c.getMin();
            String min = this.verbalizeMin(minE, Integer.MIN_VALUE);
            INumberExpression maxE = c.getMax();
            String max = this.verbalizeMax(maxE, Integer.MAX_VALUE);
            String var = c.getVar() == null ? "" : ", " + c.getVar();
            return name + list + ", " + arg + min + max + var + ")";
        }
        if (condition instanceof CurrentCountCondition) {
            CurrentCountCondition c = (CurrentCountCondition)condition;
            String type = this.verbalizer.verbalize(c.getType());
            INumberExpression minE = c.getMin();
            String min = this.verbalizeMin(minE, Integer.MIN_VALUE);
            INumberExpression maxE = c.getMax();
            String max = this.verbalizeMax(maxE, Integer.MAX_VALUE);
            String var = c.getVar() == null ? "" : ", " + c.getVar();
            return name + type + min + max + var + ")";
        }
        if (condition instanceof IfCondition) {
            IfCondition c = (IfCondition)condition;
            return name + this.verbalizer.verbalize(c.getExpression()) + ")";
        }
        if (condition instanceof InListCondition) {
            InListCondition c = (InListCondition)condition;
            String list = "";
            list = c.getListExpression() != null ? this.verbalizer.verbalize(c.getListExpression()) : this.verbalizer.verbalize(c.getStringList());
            IStringExpression a = c.getArg();
            String arg = "";
            if (a != null) {
                arg = ", " + this.verbalizer.verbalize(a);
            }
            return name + list + arg + ")";
        }
        if (condition instanceof LastCondition) {
            LastCondition c = (LastCondition)condition;
            return name + this.verbalizer.verbalize(c.getType()) + ")";
        }
        if (condition instanceof MOfNCondition) {
            MOfNCondition c = (MOfNCondition)condition;
            StringBuilder sb = new StringBuilder();
            sb.append(name);
            INumberExpression minE = c.getMin();
            String min = this.verbalizeMin(minE, Integer.MIN_VALUE);
            INumberExpression maxE = c.getMax();
            String max = this.verbalizeMax(maxE, Integer.MAX_VALUE);
            sb.append(min.substring(2, min.length()));
            sb.append(max);
            List<AbstractRutaCondition> conditions = c.getConditions();
            if (!conditions.isEmpty()) {
                sb.append(", ");
            }
            Iterator<AbstractRutaCondition> it = conditions.iterator();
            while (it.hasNext()) {
                AbstractRutaCondition each = it.next();
                sb.append(this.verbalize(each));
                if (!it.hasNext()) continue;
                sb.append(", ");
            }
            sb.append(")");
            return sb.toString();
        }
        if (condition instanceof NearCondition) {
            NearCondition c = (NearCondition)condition;
            String type = this.verbalizer.verbalize(c.getType());
            String var = this.verbalizer.verbalize(c.getForward());
            INumberExpression minE = c.getMin();
            String min = this.verbalizeMin(minE, Integer.MIN_VALUE);
            INumberExpression maxE = c.getMax();
            String max = this.verbalizeMax(maxE, Integer.MAX_VALUE);
            String filtered = this.verbalizer.verbalize(c.getFiltered());
            if (!"".equals(filtered)) {
                filtered = ", " + filtered;
            }
            return name + type + min + max + ", " + var + filtered + ")";
        }
        if (condition instanceof NotCondition) {
            NotCondition c = (NotCondition)condition;
            List<AbstractRutaCondition> conditions = c.getConditions();
            if (conditions.size() != 1) {
                StringBuilder sb = new StringBuilder();
                sb.append(name);
                Iterator<AbstractRutaCondition> it = conditions.iterator();
                while (it.hasNext()) {
                    AbstractRutaCondition each = it.next();
                    sb.append(this.verbalize(each));
                    if (!it.hasNext()) continue;
                    sb.append(", ");
                }
                sb.append(")");
                return sb.toString();
            }
            return "-" + this.verbalize(conditions.get(0));
        }
        if (condition instanceof OrCondition) {
            OrCondition c = (OrCondition)condition;
            List<AbstractRutaCondition> conditions = c.getConditions();
            StringBuilder sb = new StringBuilder();
            sb.append(name);
            Iterator<AbstractRutaCondition> it = conditions.iterator();
            while (it.hasNext()) {
                AbstractRutaCondition each = it.next();
                sb.append(this.verbalize(each));
                if (!it.hasNext()) continue;
                sb.append(", ");
            }
            sb.append(")");
            return sb.toString();
        }
        if (condition instanceof PartOfCondition) {
            PartOfCondition c = (PartOfCondition)condition;
            if (c.getType() == null) {
                return name + this.verbalizer.verbalize(c.getList()) + ")";
            }
            return name + this.verbalizer.verbalize(c.getType()) + ")";
        }
        if (condition instanceof PartOfNeqCondition) {
            PartOfNeqCondition c = (PartOfNeqCondition)condition;
            if (c.getType() == null) {
                return name + this.verbalizer.verbalize(c.getList()) + ")";
            }
            return name + this.verbalizer.verbalize(c.getType()) + ")";
        }
        if (condition instanceof PositionCondition) {
            PositionCondition c = (PositionCondition)condition;
            String relative = "";
            if (c.getRelative() != null) {
                relative = ", " + this.verbalizer.verbalize(c.getRelative());
            }
            return name + this.verbalizer.verbalize(c.getType()) + ", " + this.verbalizer.verbalize(c.getPosition()) + relative + ")";
        }
        if (condition instanceof RegExpCondition) {
            RegExpCondition c = (RegExpCondition)condition;
            IStringExpression variable = c.getVariable();
            String ic = this.verbalizer.verbalize(c.getIgnoreCase());
            if (variable == null) {
                return name + this.verbalizer.verbalize(c.getPattern()) + ", " + ic + ")";
            }
            return name + this.verbalizer.verbalize(variable) + ", " + this.verbalizer.verbalize(c.getPattern()) + ", " + ic + ")";
        }
        if (condition instanceof ScoreCondition) {
            ScoreCondition c = (ScoreCondition)condition;
            INumberExpression minE = c.getMin();
            String min = this.verbalizeMin(minE, Integer.MIN_VALUE);
            INumberExpression maxE = c.getMax();
            String max = this.verbalizeMax(maxE, Integer.MAX_VALUE);
            String var = c.getVar() == null ? "" : ", " + c.getVar();
            return name + min.substring(2) + max + var + ")";
        }
        if (condition instanceof TotalCountCondition) {
            TotalCountCondition c = (TotalCountCondition)condition;
            String type = this.verbalizer.verbalize(c.getType());
            INumberExpression minE = c.getMin();
            String min = this.verbalizeMin(minE, Integer.MIN_VALUE);
            INumberExpression maxE = c.getMax();
            String max = this.verbalizeMax(maxE, Integer.MAX_VALUE);
            String var = c.getVar() == null ? "" : ", " + c.getVar();
            return name + type + min + max + var + ")";
        }
        if (condition instanceof VoteCondition) {
            VoteCondition c = (VoteCondition)condition;
            String type1 = this.verbalizer.verbalize(c.getType1());
            String type2 = this.verbalizer.verbalize(c.getType2());
            return name + type1 + ", " + type2 + ")";
        }
        if (condition instanceof FeatureCondition) {
            FeatureCondition c = (FeatureCondition)condition;
            String e1 = this.verbalizer.verbalize(c.getFeatureStringExpression());
            String e2 = this.verbalizer.verbalize(c.getArgExpr());
            return name + e1 + ", " + e2 + ")";
        }
        if (condition instanceof ParseCondition) {
            ParseCondition c = (ParseCondition)condition;
            String var = c.getVar();
            return name + var + ")";
        }
        if (condition instanceof IsCondition) {
            IsCondition c = (IsCondition)condition;
            String type = "";
            type = c.getType() != null ? this.verbalizer.verbalize(c.getType()) : this.verbalizer.verbalize(c.getList());
            return name + type + ")";
        }
        if (condition instanceof BeforeCondition) {
            BeforeCondition c = (BeforeCondition)condition;
            String type = "";
            type = c.getType() != null ? this.verbalizer.verbalize(c.getType()) : this.verbalizer.verbalize(c.getList());
            return name + type + ")";
        }
        if (condition instanceof AfterCondition) {
            AfterCondition c = (AfterCondition)condition;
            String type = "";
            type = c.getType() != null ? this.verbalizer.verbalize(c.getType()) : this.verbalizer.verbalize(c.getList());
            return name + type + ")";
        }
        if (condition instanceof StartsWithCondition) {
            StartsWithCondition c = (StartsWithCondition)condition;
            String arg = "";
            arg = c.getType() != null ? this.verbalizer.verbalize(c.getType()) : this.verbalizer.verbalize(c.getList());
            return name + arg + ")";
        }
        if (condition instanceof EndsWithCondition) {
            EndsWithCondition c = (EndsWithCondition)condition;
            String type = "";
            type = c.getType() != null ? this.verbalizer.verbalize(c.getType()) : this.verbalizer.verbalize(c.getList());
            return name + type + ")";
        }
        if (condition instanceof SizeCondition) {
            SizeCondition c = (SizeCondition)condition;
            INumberExpression minE = c.getMinExpr();
            String min = this.verbalizeMin(minE, Integer.MIN_VALUE);
            INumberExpression maxE = c.getMaxExpr();
            String max = this.verbalizeMax(maxE, Integer.MAX_VALUE);
            String var = c.getVarExpr() == null ? "" : ", " + c.getVarExpr();
            ListExpression<?> listExpr = c.getListExpr();
            if (listExpr == null) {
                return name + min + max + var + ")";
            }
            String l = this.verbalizer.verbalize(listExpr);
            return name + l + min + max + var + ")";
        }
        if (condition instanceof ImplicitCondition) {
            ImplicitCondition c = (ImplicitCondition)condition;
            return this.verbalizer.verbalize(c.getExpr());
        }
        if (condition instanceof MacroCondition) {
            MacroCondition c = (MacroCondition)condition;
            return name + this.verbalizer.verbalizeExpressionList(c.getArguments()) + ")";
        }
        return condition.getClass().getSimpleName();
    }

    private String verbalizeMax(INumberExpression maxE, int def) {
        String max = "";
        if (!(maxE instanceof SimpleNumberExpression) || !((SimpleNumberExpression)maxE).getNumber().equals(def)) {
            max = ", " + this.verbalizer.verbalize(maxE);
        }
        return max;
    }

    private String verbalizeMin(INumberExpression minE, int def) {
        String min = "";
        if (!(minE instanceof SimpleNumberExpression) || !((SimpleNumberExpression)minE).getNumber().equals(def)) {
            min = ", " + this.verbalizer.verbalize(minE);
        }
        return min;
    }
}

