/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.expression.bool;

import org.apache.uima.cas.Type;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.expression.bool.AbstractBooleanExpression;
import org.apache.uima.ruta.expression.type.ITypeExpression;
import org.apache.uima.ruta.rule.MatchContext;

public class BooleanTypeExpression
extends AbstractBooleanExpression {
    private final ITypeExpression e1;
    private final String op;
    private final ITypeExpression e2;

    public BooleanTypeExpression(ITypeExpression e1, String op, ITypeExpression e2) {
        this.e1 = e1;
        this.op = op;
        this.e2 = e2;
    }

    @Override
    public boolean getBooleanValue(MatchContext context, RutaStream stream) {
        Type type1 = this.getFristExpression().getType(context, stream);
        String first = type1.getName();
        Type type2 = this.getSecondExpression().getType(context, stream);
        String second = type2.getName();
        return this.eval(first, this.getOperator(), second);
    }

    private boolean eval(String t1, String op, String t2) {
        if ("==".equals(op)) {
            return t1.equals(t2);
        }
        if ("!=".equals(op)) {
            return !t1.equals(t2);
        }
        return false;
    }

    public ITypeExpression getFristExpression() {
        return this.e1;
    }

    public String getOperator() {
        return this.op;
    }

    public ITypeExpression getSecondExpression() {
        return this.e2;
    }

    @Override
    public String getStringValue(MatchContext context, RutaStream stream) {
        return this.e1.getStringValue(context, stream) + " " + this.op + " " + this.e2.getStringValue(context, stream);
    }
}

