/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.action;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.action.TypeSensitiveAction;
import org.apache.uima.ruta.expression.AnnotationTypeExpression;
import org.apache.uima.ruta.expression.bool.IBooleanExpression;
import org.apache.uima.ruta.expression.number.INumberExpression;
import org.apache.uima.ruta.expression.type.ITypeExpression;
import org.apache.uima.ruta.rule.MatchContext;
import org.apache.uima.ruta.rule.RuleElement;
import org.apache.uima.ruta.rule.RuleMatch;
import org.apache.uima.ruta.type.RutaBasic;
import org.apache.uima.ruta.visitor.InferenceCrowd;

public class UnmarkAction
extends TypeSensitiveAction {
    private List<INumberExpression> list;
    private IBooleanExpression allAnchor;
    private AnnotationTypeExpression expression;

    public UnmarkAction(ITypeExpression type, List<INumberExpression> list, IBooleanExpression b) {
        super(type);
        this.list = list;
        this.allAnchor = b;
    }

    public UnmarkAction(AnnotationTypeExpression expression) {
        super(null);
        this.expression = expression;
    }

    @Override
    public void execute(MatchContext context, RutaStream stream, InferenceCrowd crowd) {
        RuleMatch match = context.getRuleMatch();
        RuleElement element = context.getElement();
        if (this.expression != null) {
            List<AnnotationFS> annotationList = this.expression.getAnnotationList(context, stream);
            if (this.expression.getTypeExpression() != null && this.expression.getFeatureExpression() == null && this.expression.getAnnotationExpression() == null && this.expression.getAnnotationListExpression() == null) {
                Type t = this.expression.getTypeExpression().getType(context, stream);
                this.removeTypeBased(context, stream, match, element, t);
            } else {
                for (AnnotationFS annotationFS : annotationList) {
                    stream.removeAnnotation(annotationFS);
                    this.addAnnotationToLabel(annotationFS, context);
                }
            }
        } else {
            Type t = this.type.getType(context, stream);
            this.removeTypeBased(context, stream, match, element, t);
        }
    }

    private void removeTypeBased(MatchContext context, RutaStream stream, RuleMatch match, RuleElement element, Type t) {
        if (t == null) {
            return;
        }
        boolean allAtAnchor = false;
        if (this.allAnchor != null) {
            allAtAnchor = this.allAnchor.getBooleanValue(context, stream);
        }
        List<Integer> indexList = this.getIndexList(context, this.list, stream);
        List<AnnotationFS> matchedAnnotations = match.getMatchedAnnotations(indexList, element.getContainer());
        for (AnnotationFS annotationFS : matchedAnnotations) {
            Type matchedType = annotationFS.getType();
            boolean subsumes = stream.getCas().getTypeSystem().subsumes(t, matchedType);
            if (subsumes && !allAtAnchor) {
                stream.removeAnnotation(annotationFS, matchedType);
                this.addAnnotationToLabel(annotationFS, context);
                continue;
            }
            RutaBasic beginAnchor = stream.getBeginAnchor(annotationFS.getBegin());
            Collection beginAnchors = beginAnchor.getBeginAnchors(t);
            if (beginAnchors == null) continue;
            for (AnnotationFS each : new ArrayList(beginAnchors)) {
                if (!allAtAnchor && each.getEnd() != annotationFS.getEnd()) continue;
                stream.removeAnnotation(each, t);
                this.addAnnotationToLabel(annotationFS, context);
            }
        }
    }

    public List<INumberExpression> getList() {
        return this.list;
    }

    public IBooleanExpression getAllAnchor() {
        return this.allAnchor;
    }

    protected List<Integer> getIndexList(MatchContext context, List<INumberExpression> list, RutaStream stream) {
        RuleElement element = context.getElement();
        ArrayList<Integer> indexList = new ArrayList<Integer>();
        if (list == null || list.isEmpty()) {
            int self = element.getContainer().getRuleElements().indexOf(element) + 1;
            indexList.add(self);
            return indexList;
        }
        int last = 0x7FFFFFFE;
        for (INumberExpression each : list) {
            int value = each.getIntegerValue(context, stream);
            for (int i = Math.min(value, last + 1); i < value; ++i) {
                indexList.add(i);
            }
            indexList.add(value);
        }
        return indexList;
    }

    public AnnotationTypeExpression getExpression() {
        return this.expression;
    }
}

