/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.taeconfigurator.editors.ui.dialogs;

import java.text.MessageFormat;
import org.apache.uima.taeconfigurator.CDEpropertyPage;
import org.apache.uima.taeconfigurator.editors.ui.AbstractSection;
import org.apache.uima.taeconfigurator.editors.ui.dialogs.AbstractDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class ExportImportablePartDialog
extends AbstractDialog {
    private Text baseFileNameUI;
    private Button importByNameUI;
    private Button importByLocationUI;
    public boolean isImportByName;
    private String rootPath;
    private DialogModifyListener m_dialogModifyListener = new DialogModifyListener();
    private Text genFilePathUI;
    public String genFilePath;
    public String baseFileName;

    public ExportImportablePartDialog(AbstractSection aSection) {
        super(aSection, "Export an importable part", "Specify a base file name, and perhaps alter the path where it should be stored, and press OK");
        this.rootPath = aSection.editor.getFile().getParent().getLocation().toString() + '/';
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        AbstractSection.spacer(composite);
        this.createWideLabel(composite, "Base file name (without path or following \".xml\":");
        this.baseFileNameUI = new Text(composite, 2048);
        this.baseFileNameUI.setLayoutData((Object)new GridData(768));
        this.baseFileNameUI.addModifyListener((ModifyListener)this.m_dialogModifyListener);
        this.baseFileNameUI.addVerifyListener((VerifyListener)new DialogVerifyListener());
        this.baseFileName = "";
        this.newErrorMessage(composite);
        this.createWideLabel(composite, "Where the generated part descriptor file will be stored:");
        this.genFilePathUI = new Text(composite, 2304);
        this.genFilePathUI.setLayoutData((Object)new GridData(768));
        this.genFilePathUI.setText(this.rootPath + ".xml");
        new Label(composite, 0).setText("");
        this.importByNameUI = new Button(composite, 16);
        this.importByNameUI.setText("Import by Name");
        this.importByNameUI.setToolTipText("Importing by name looks up the name on the classpath and datapath.");
        this.importByLocationUI = new Button(composite, 16);
        this.importByLocationUI.setText("Import By Location");
        this.importByLocationUI.setToolTipText("Importing by location requires a relative or absolute URL");
        String defaultBy = CDEpropertyPage.getImportByDefault(this.editor.getProject());
        if (defaultBy.equals("location")) {
            this.importByNameUI.setSelection(false);
            this.importByLocationUI.setSelection(true);
        } else {
            this.importByNameUI.setSelection(true);
            this.importByLocationUI.setSelection(false);
        }
        this.baseFileNameUI.setFocus();
        return composite;
    }

    @Override
    public void enableOK() {
        boolean bEnableOk = this.baseFileNameUI != null && !this.baseFileNameUI.getText().trim().equals("");
        this.okButton.setEnabled(bEnableOk);
    }

    @Override
    public void copyValuesFromGUI() {
        this.genFilePath = this.genFilePathUI.getText();
        this.isImportByName = this.importByNameUI.getSelection();
        CDEpropertyPage.setImportByDefault(this.editor.getProject(), this.isImportByName ? "name" : "location");
    }

    @Override
    public boolean isValid() {
        return true;
    }

    private class DialogModifyListener
    implements ModifyListener {
        private DialogModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            String text = ExportImportablePartDialog.this.genFilePathUI.getText();
            int pos = text.lastIndexOf(ExportImportablePartDialog.this.baseFileName + ".xml");
            if (pos == -1) {
                pos = text.length();
            }
            ExportImportablePartDialog.this.baseFileName = ExportImportablePartDialog.this.baseFileNameUI.getText();
            ExportImportablePartDialog.this.genFilePathUI.setText(text.substring(0, pos) + ExportImportablePartDialog.this.baseFileName + ".xml");
            if (ExportImportablePartDialog.this.okButton != null) {
                ExportImportablePartDialog.this.enableOK();
            }
        }
    }

    private class DialogVerifyListener
    implements VerifyListener {
        private DialogVerifyListener() {
        }

        public void verifyText(VerifyEvent e) {
            if (0 <= e.text.indexOf(46)) {
                ExportImportablePartDialog.this.setErrorMessage(MessageFormat.format("invalid character(s): ''{0}''", e.text));
                e.doit = false;
            } else {
                ExportImportablePartDialog.this.setErrorMessage("");
            }
        }
    }
}

