/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.application.metadata.impl;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.apache.uima.UIMA_IllegalArgumentException;
import org.apache.uima.application.metadata.DeploymentOverrides;
import org.apache.uima.application.metadata.UimaApplication;
import org.apache.uima.application.metadata.UimaCasProcessor;
import org.apache.uima.collection.impl.metadata.cpe.CpeDescriptorFactory;
import org.apache.uima.collection.metadata.CasProcessorConfigurationParameterSettings;
import org.apache.uima.cpe.model.ConfigParameterModel;
import org.apache.uima.cpe.model.ConfigParametersModel;
import org.apache.uima.cpe.model.UimaCasInitializer;
import org.apache.uima.cpe.model.UimaCollectionReader;
import org.apache.uima.resource.ResourceManager;
import org.apache.uima.resource.metadata.ConfigurationParameterDeclarations;
import org.apache.uima.resource.metadata.ConfigurationParameterSettings;
import org.apache.uima.resource.metadata.impl.MetaDataObject_impl;
import org.apache.uima.resource.metadata.impl.XmlizationInfo;
import org.apache.uima.util.XMLizable;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public abstract class AbstractUimaCasProcessor
extends MetaDataObject_impl {
    protected int status = 0;
    protected int statusDetails = 0;
    private String name = "";
    private String description = "";
    protected boolean isBuiltin = false;
    protected int casprocCategory = 0;
    protected UimaApplication uimaApplication;
    protected ResourceManager resourceManager;
    protected String instanceName = "";
    protected String casProcessorDescription = "";
    protected String xmlDescriptor = "";
    protected XMLizable xmlizableDescriptor = null;
    protected DeploymentOverrides mDeploymentOverrides;
    protected ConfigParametersModel configParamsModel;
    protected ConfigurationParameterDeclarations configParamDecls = null;
    protected ConfigurationParameterSettings configParamSettings = null;

    public AbstractUimaCasProcessor(int category, UimaApplication app) {
        this.casprocCategory = category;
        this.uimaApplication = app;
    }

    public static void createConfigParamOverrides(ConfigParametersModel model) {
        AbstractUimaCasProcessor.createConfigParamOverrides(model, null);
    }

    public static void createConfigParamOverrides(ConfigParametersModel model, ConfigurationParameterSettings cpeSettings) {
        List paramList = model.getParamModelList();
        if (paramList != null && paramList.size() > 0) {
            ArrayList<ConfigParameterModel> cpeParamModelList = new ArrayList<ConfigParameterModel>();
            for (int k = 0; k < paramList.size(); ++k) {
                ConfigParameterModel m = (ConfigParameterModel)paramList.get(k);
                Object cpeValue = null;
                if (cpeSettings != null) {
                    cpeValue = cpeSettings.getParameterValue(m.getName());
                    if (cpeValue == null) {
                        cpeValue = model.getParamSettings().getParameterValue(m.getName());
                    }
                    m.setCpeValue(cpeValue);
                }
                cpeParamModelList.add(m);
            }
            model.setCpeParamModelList(cpeParamModelList.size() > 0 ? cpeParamModelList : null);
        }
    }

    public UimaApplication getUimaApplication() {
        return this.uimaApplication;
    }

    public void setUimaApplication(UimaApplication uimaApplication) {
        this.uimaApplication = uimaApplication;
    }

    public ResourceManager getResourceManager() {
        if (this.resourceManager == null && this.uimaApplication != null) {
            return this.uimaApplication.getResourceManager();
        }
        return this.resourceManager;
    }

    public void setResourceManager(ResourceManager resourceManager) {
        this.resourceManager = resourceManager;
    }

    protected XmlizationInfo getXmlizationInfo() {
        return null;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setName(String name) {
        this.name = name;
    }

    public DeploymentOverrides getDeploymentOverrides() {
        return this.mDeploymentOverrides;
    }

    protected void setDeploymentOverrides(DeploymentOverrides aParam) {
        if (aParam == null) {
            throw new UIMA_IllegalArgumentException("illegal_argument", new Object[]{"null", "aParams", "setConfigParamSettingsSets"});
        }
        this.mDeploymentOverrides = aParam;
    }

    public ConfigParametersModel getConfigParamsModel() {
        return this.configParamsModel;
    }

    public void setConfigParamsModel(ConfigParametersModel configParamsModel) {
        this.configParamsModel = configParamsModel;
    }

    public boolean isUimaCasProcessor() {
        return this instanceof UimaCasProcessor;
    }

    public boolean isUimaCollectionReader() {
        return this instanceof UimaCollectionReader;
    }

    public boolean isUimaCasInitializer() {
        return this instanceof UimaCasInitializer;
    }

    public int getCasProcessorCategory() {
        return this.casprocCategory;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public void setInstanceName(String casProcessorName) {
        this.instanceName = casProcessorName;
    }

    public String getCasProcessorDescription() {
        return this.casProcessorDescription;
    }

    public String getXmlDescriptor() {
        return this.xmlDescriptor;
    }

    public void setXmlDescriptor(String xmlDescriptor) {
        this.xmlDescriptor = xmlDescriptor;
    }

    public XMLizable getXmlizable() {
        return this.xmlizableDescriptor;
    }

    public void setXmlizable(XMLizable xmlizableDescriptor) {
        this.xmlizableDescriptor = xmlizableDescriptor;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public int getStatusDetails() {
        return this.statusDetails;
    }

    public void setStatusDetails(int statusDetails) {
        this.statusDetails = statusDetails;
    }

    public boolean isBuiltin() {
        return this.isBuiltin;
    }

    public void setBuiltin(boolean isBuiltin) {
        this.isBuiltin = isBuiltin;
    }

    public void toXML(ContentHandler aContentHandler, boolean aWriteDefaultNamespaceAttribute) throws SAXException {
        List cpeOverrideList;
        AttributesImpl attrs = new AttributesImpl();
        String tagComponent = "";
        tagComponent = this instanceof UimaCollectionReader ? "uimaCollectionReader" : "uimaCasProcessor";
        attrs.addAttribute("", "name", "name", null, "" + this.getInstanceName());
        aContentHandler.startElement(this.getXmlizationInfo().namespace, "", tagComponent, attrs);
        attrs.clear();
        attrs.addAttribute("", "location", "location", null, "" + this.getXmlDescriptor());
        aContentHandler.startElement(this.getXmlizationInfo().namespace, "", "import", attrs);
        aContentHandler.endElement(this.getXmlizationInfo().namespace, "", "import");
        attrs.clear();
        aContentHandler.startElement(this.getXmlizationInfo().namespace, "", "deploymentSettings", attrs);
        aContentHandler.endElement(this.getXmlizationInfo().namespace, "", "deploymentSettings");
        aContentHandler.startElement(this.getXmlizationInfo().namespace, "", "deploymentOverrides", attrs);
        aContentHandler.startElement(this.getXmlizationInfo().namespace, "", "configParamOverrides", attrs);
        attrs.addAttribute("", "name", "name", null, "");
        aContentHandler.startElement(this.getXmlizationInfo().namespace, "", "configParamOverrideSet", attrs);
        attrs.clear();
        aContentHandler.startElement(this.getXmlizationInfo().namespace, "", "description", attrs);
        aContentHandler.endElement(this.getXmlizationInfo().namespace, "", "description");
        if (this.getConfigParamsModel() != null && (cpeOverrideList = this.getConfigParamsModel().getCpeParamModelList()) != null && cpeOverrideList.size() > 0) {
            aContentHandler.startElement(this.getXmlizationInfo().namespace, "", "configurationParameterSettings", attrs);
            CasProcessorConfigurationParameterSettings settings = CpeDescriptorFactory.produceCasProcessorConfigurationParameterSettings();
            for (int k = 0; k < cpeOverrideList.size(); ++k) {
                ConfigParameterModel m = (ConfigParameterModel)cpeOverrideList.get(k);
                if (m.getCpeValue() == null) continue;
                settings.setParameterValue(m.getName(), m.getCpeValue());
                m.toXML(aContentHandler, aWriteDefaultNamespaceAttribute);
            }
            aContentHandler.endElement(this.getXmlizationInfo().namespace, "", "configurationParameterSettings");
        }
        aContentHandler.endElement(this.getXmlizationInfo().namespace, "", "configParamOverrideSet");
        aContentHandler.endElement(this.getXmlizationInfo().namespace, "", "configParamOverrides");
        aContentHandler.endElement(this.getXmlizationInfo().namespace, "", "deploymentOverrides");
        aContentHandler.endElement(this.getXmlizationInfo().namespace, "", tagComponent);
    }

    public String generateComponentXmlDescriptor(String xmlDescriptorFileName, boolean resolve) {
        StringWriter w = new StringWriter();
        try {
            this.toXML(w);
            return w.toString();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String generateXmlDescriptor(String xmlDescriptorFileName, boolean resolve, boolean updateOverrides) {
        Object m;
        List overrideList;
        if (updateOverrides && (overrideList = this.getConfigParamsModel().getParamModelList()) != null && overrideList.size() > 0) {
            for (int k = 0; k < overrideList.size(); ++k) {
                m = (ConfigParameterModel)overrideList.get(k);
                this.configParamSettings.setParameterValue(((ConfigParameterModel)m).getName(), ((ConfigParameterModel)m).getValue());
                if (((ConfigParameterModel)m).getCpeValue() == null) continue;
                this.configParamSettings.setParameterValue(((ConfigParameterModel)m).getName(), ((ConfigParameterModel)m).getCpeValue());
            }
        }
        StringWriter w = new StringWriter();
        FileOutputStream out = null;
        try {
            if (xmlDescriptorFileName != null && xmlDescriptorFileName.trim().length() > 0) {
                out = new FileOutputStream(xmlDescriptorFileName);
                this.xmlizableDescriptor.toXML((OutputStream)out);
            }
            this.xmlizableDescriptor.toXML((Writer)w);
            m = w.toString();
            return m;
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }
}

