/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.ide.core.builder;

import java.net.URI;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.uima.ruta.engine.RutaEngine;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IBuildpathAttribute;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.JavaProject;

public class RutaProjectUtils {
    public static final String BUILDPATH_ATTRIBUTE_RUTA = "ruta";
    public static final String BUILDPATH_ATTRIBUTE_SCRIPT = "script";
    public static final String BUILDPATH_ATTRIBUTE_DESCRIPTOR = "descriptor";
    public static final String BUILDPATH_ATTRIBUTE_RESOURCES = "resources";
    public static final String JAVANATURE = "org.eclipse.jdt.core.javanature";
    public static final String CDE_DATA_PATH = "CDEdataPath";
    public static final String DEFAULT_TYPESYSTEM_SUFFX = "TypeSystem";
    public static final String DEFAULT_ANALYSISENGINE_SUFFIX = "Engine";

    public static String getAnalysisEngineSuffix(IProject project) throws CoreException {
        IBuildpathEntry[] buildpathEntries;
        IScriptProject scriptProject = DLTKCore.create((IProject)project);
        for (IBuildpathEntry each : buildpathEntries = scriptProject.getRawBuildpath()) {
            IBuildpathAttribute[] attributes;
            if (each.getEntryKind() != 4 || !StringUtils.equals((CharSequence)each.getPath().toPortableString(), (CharSequence)"RUTA_BUILD_VARS")) continue;
            for (IBuildpathAttribute eachAttr : attributes = each.getExtraAttributes()) {
                if (!StringUtils.equals((CharSequence)eachAttr.getName(), (CharSequence)"analysisEngineSuffix")) continue;
                return eachAttr.getValue();
            }
        }
        return DEFAULT_ANALYSISENGINE_SUFFIX;
    }

    public static String getTypeSystemSuffix(IProject project) throws CoreException {
        IBuildpathEntry[] buildpathEntries;
        IScriptProject scriptProject = DLTKCore.create((IProject)project);
        for (IBuildpathEntry each : buildpathEntries = scriptProject.getRawBuildpath()) {
            IBuildpathAttribute[] attributes;
            if (each.getEntryKind() != 4 || !StringUtils.equals((CharSequence)each.getPath().toPortableString(), (CharSequence)"RUTA_BUILD_VARS")) continue;
            for (IBuildpathAttribute eachAttr : attributes = each.getExtraAttributes()) {
                if (!StringUtils.equals((CharSequence)eachAttr.getName(), (CharSequence)"typeSystemSuffix")) continue;
                return eachAttr.getValue();
            }
        }
        return DEFAULT_TYPESYSTEM_SUFFX;
    }

    public static IPath getAnalysisEngineDescriptorPath(IPath scriptPath, IProject project) throws CoreException {
        String[] paths;
        String analysisEngineSuffix = RutaProjectUtils.getAnalysisEngineSuffix(project);
        String name = RutaProjectUtils.getScriptWithPackage(scriptPath, project);
        String locate = RutaEngine.locate((String)name, (String[])(paths = RutaProjectUtils.getDescriptorPathsArray(project)), (String)(analysisEngineSuffix + ".xml"));
        if (locate != null) {
            return Path.fromPortableString((String)locate);
        }
        return null;
    }

    public static IPath getAnalysisEngineDescriptorPath(String scriptLocation) throws CoreException {
        Path scriptPath = new Path(scriptLocation);
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot workspaceRoot = workspace.getRoot();
        IFile fileForLocation = workspaceRoot.getFileForLocation((IPath)scriptPath);
        IPath analysisEngineDescriptorPath = RutaProjectUtils.getAnalysisEngineDescriptorPath((IPath)scriptPath, fileForLocation.getProject());
        return analysisEngineDescriptorPath;
    }

    public static IPath getTypeSystemDescriptorPath(IPath scriptPath, IProject project) throws CoreException {
        String[] paths;
        String typeSystemSuffix = RutaProjectUtils.getTypeSystemSuffix(project);
        String name = RutaProjectUtils.getScriptWithPackage(scriptPath, project);
        String locate = RutaEngine.locate((String)name, (String[])(paths = RutaProjectUtils.getDescriptorPathsArray(project)), (String)(typeSystemSuffix + ".xml"));
        if (locate != null) {
            return Path.fromPortableString((String)locate);
        }
        return null;
    }

    public static IPath getTypeSystemDescriptorPath(String scriptLocation) throws CoreException {
        Path scriptPath = new Path(scriptLocation);
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot workspaceRoot = workspace.getRoot();
        IFile fileForLocation = workspaceRoot.getFileForLocation((IPath)scriptPath);
        IPath analysisEngineDescriptorPath = RutaProjectUtils.getTypeSystemDescriptorPath((IPath)scriptPath, fileForLocation.getProject());
        return analysisEngineDescriptorPath;
    }

    public static String getScriptWithPackage(IPath scriptPath, IProject project) throws CoreException {
        String packageString;
        String name = RutaProjectUtils.getModuleName(scriptPath);
        IPath packagePath = RutaProjectUtils.getPackagePath(scriptPath, project);
        if (packagePath != null && !StringUtils.isBlank((CharSequence)(packageString = packagePath.toPortableString().replaceAll("/", ".")))) {
            name = packageString.concat(".").concat(name);
        }
        return name;
    }

    private static String[] getDescriptorPathsArray(IProject project) throws CoreException {
        List<IFolder> descriptorFolders = RutaProjectUtils.getDescriptorFolders(project);
        String[] paths = new String[descriptorFolders.size()];
        int i = 0;
        for (IFolder each : descriptorFolders) {
            paths[i] = each.getLocation().toPortableString();
            ++i;
        }
        return paths;
    }

    public static IPath getDescriptorRootPath(IProject project) throws CoreException {
        List<IFolder> descriptorFolders = RutaProjectUtils.getDescriptorFolders(project);
        if (descriptorFolders != null && !descriptorFolders.isEmpty()) {
            return descriptorFolders.get(0).getLocation();
        }
        IPath projectPath = project.getLocation();
        IPath descPath = projectPath.append(RutaProjectUtils.getDefaultDescriptorLocation());
        return descPath;
    }

    public static List<IFolder> getAllScriptFolders(IScriptProject proj) throws CoreException {
        ArrayList<IFolder> result = new ArrayList<IFolder>();
        result.addAll(RutaProjectUtils.getScriptFolders(proj));
        result.addAll(RutaProjectUtils.getReferencedScriptFolders(proj));
        return result;
    }

    public static List<IFolder> getReferencedScriptFolders(IScriptProject proj) throws CoreException {
        return RutaProjectUtils.getReferencedScriptFolders(proj, new HashSet<IProject>());
    }

    public static List<IFolder> getReferencedScriptFolders(IScriptProject proj, Collection<IProject> visited) throws CoreException {
        IProject[] referencedProjects;
        ArrayList<IFolder> result = new ArrayList<IFolder>();
        for (IProject eachProject : referencedProjects = proj.getProject().getReferencedProjects()) {
            if (visited.contains(eachProject) || !eachProject.exists()) continue;
            IScriptProject scriptProject = DLTKCore.create((IProject)eachProject);
            result.addAll(RutaProjectUtils.getScriptFolders(scriptProject));
            visited.add(eachProject);
            result.addAll(RutaProjectUtils.getReferencedScriptFolders(scriptProject, visited));
        }
        return result;
    }

    public static List<IFolder> getScriptFolders(IProject project) throws CoreException {
        IScriptProject scriptProject = DLTKCore.create((IProject)project);
        return RutaProjectUtils.getScriptFolders(scriptProject);
    }

    public static List<IFolder> getScriptFolders(IScriptProject sp) throws CoreException {
        IFolder findElement;
        ArrayList<IFolder> result = new ArrayList<IFolder>();
        if (!sp.isOpen()) {
            return result;
        }
        IBuildpathEntry[] rawBuildpath = null;
        try {
            rawBuildpath = sp.getRawBuildpath();
        }
        catch (ModelException e) {
            // empty catch block
        }
        if (rawBuildpath != null) {
            for (IBuildpathEntry each : rawBuildpath) {
                IBuildpathAttribute[] extraAttributes;
                IPath path = each.getPath();
                int entryKind = each.getEntryKind();
                if (entryKind != 3) continue;
                for (IBuildpathAttribute eachAttr : extraAttributes = each.getExtraAttributes()) {
                    if (!eachAttr.getName().equals(BUILDPATH_ATTRIBUTE_RUTA) || !eachAttr.getValue().equals(BUILDPATH_ATTRIBUTE_SCRIPT)) continue;
                    result.add(ResourcesPlugin.getWorkspace().getRoot().getFolder(path));
                }
            }
        }
        if (result.isEmpty() && (findElement = sp.getProject().getFolder(RutaProjectUtils.getDefaultScriptLocation())) != null && findElement.exists()) {
            result.add(findElement);
        }
        return result;
    }

    public static List<IFolder> getAllDescriptorFolders(IProject proj) throws CoreException {
        ArrayList<IFolder> result = new ArrayList<IFolder>();
        result.addAll(RutaProjectUtils.getDescriptorFolders(proj));
        result.addAll(RutaProjectUtils.getReferencedDescriptorFolders(proj));
        return result;
    }

    public static List<IFolder> getReferencedDescriptorFolders(IProject proj) throws CoreException {
        return RutaProjectUtils.getReferencedDescriptorFolders(proj, new HashSet<IProject>());
    }

    public static List<IFolder> getReferencedDescriptorFolders(IProject proj, Collection<IProject> visited) throws CoreException {
        ArrayList<IFolder> result = new ArrayList<IFolder>();
        Collection<IProject> referencedProjects = RutaProjectUtils.getReferencedProjects(proj, new HashSet<IProject>());
        for (IProject eachProject : referencedProjects) {
            if (visited.contains(eachProject)) continue;
            result.addAll(RutaProjectUtils.getDescriptorFolders(eachProject));
            visited.add(eachProject);
            result.addAll(RutaProjectUtils.getReferencedDescriptorFolders(eachProject, visited));
        }
        return result;
    }

    public static Collection<IProject> getReferencedProjects(IProject proj, Collection<IProject> visited) throws CoreException {
        HashSet<IProject> result = new HashSet<IProject>();
        if (!proj.isOpen()) {
            return result;
        }
        IProject[] referencedProjects = proj.getReferencedProjects();
        result.addAll(Arrays.asList(referencedProjects));
        IProjectNature nature = proj.getNature(JAVANATURE);
        if (nature != null) {
            IClasspathEntry[] resolvedClasspath;
            JavaProject javaProject = (JavaProject)JavaCore.create((IProject)proj);
            for (IClasspathEntry eachCPE : resolvedClasspath = javaProject.getResolvedClasspath()) {
                if (eachCPE.getEntryKind() != 2) continue;
                IProject project = RutaProjectUtils.getProject(eachCPE.getPath());
                result.add(project);
            }
        }
        return result;
    }

    public static List<IFolder> getDescriptorFolders(IProject project) throws CoreException {
        IFolder findElement;
        IScriptProject sp;
        IProjectNature rutaNature;
        IFolder findElement2;
        IProjectNature pearNature;
        ArrayList<IFolder> result = new ArrayList<IFolder>();
        if (!project.isOpen()) {
            return result;
        }
        IProjectNature javaNature = project.getNature(JAVANATURE);
        if (javaNature != null) {
            IJavaProject javaProject = JavaCore.create((IProject)project);
            IPath readOutputLocation = javaProject.readOutputLocation();
            IFolder folder = ResourcesPlugin.getWorkspace().getRoot().getFolder(readOutputLocation);
            result.add(folder);
        }
        if ((pearNature = project.getNature("org.apache.uima.pear.UimaNature")) != null && (findElement2 = project.getFolder("desc")) != null) {
            result.add(findElement2);
        }
        if ((rutaNature = project.getNature("org.apache.uima.ruta.ide.nature")) != null && (sp = DLTKCore.create((IProject)project)) != null) {
            IBuildpathEntry[] rawBuildpath = null;
            try {
                rawBuildpath = sp.getRawBuildpath();
            }
            catch (ModelException e) {
                // empty catch block
            }
            if (rawBuildpath != null) {
                for (IBuildpathEntry each : rawBuildpath) {
                    IBuildpathAttribute[] extraAttributes;
                    IPath path = each.getPath();
                    int entryKind = each.getEntryKind();
                    if (entryKind != 3) continue;
                    for (IBuildpathAttribute eachAttr : extraAttributes = each.getExtraAttributes()) {
                        if (!eachAttr.getName().equals(BUILDPATH_ATTRIBUTE_RUTA) || !eachAttr.getValue().equals(BUILDPATH_ATTRIBUTE_DESCRIPTOR)) continue;
                        result.add(ResourcesPlugin.getWorkspace().getRoot().getFolder(path));
                    }
                }
            }
        }
        if (result.isEmpty() && (findElement = project.getFolder(RutaProjectUtils.getDefaultDescriptorLocation())) != null && findElement.exists()) {
            result.add(findElement);
        }
        return result;
    }

    public static List<IFolder> getResourceFolders(IProject project) throws CoreException {
        IFolder findElement;
        IScriptProject sp;
        IProjectNature rutaNature;
        ArrayList<IFolder> result = new ArrayList<IFolder>();
        if (!project.isOpen()) {
            return result;
        }
        IProjectNature javaNature = project.getNature(JAVANATURE);
        if (javaNature != null) {
            IJavaProject javaProject = JavaCore.create((IProject)project);
            IPath readOutputLocation = javaProject.readOutputLocation();
            IFolder folder = ResourcesPlugin.getWorkspace().getRoot().getFolder(readOutputLocation);
            result.add(folder);
        }
        if ((rutaNature = project.getNature("org.apache.uima.ruta.ide.nature")) != null && (sp = DLTKCore.create((IProject)project)) != null) {
            IBuildpathEntry[] rawBuildpath = null;
            try {
                rawBuildpath = sp.getRawBuildpath();
            }
            catch (ModelException e) {
                // empty catch block
            }
            if (rawBuildpath != null) {
                for (IBuildpathEntry each : rawBuildpath) {
                    IBuildpathAttribute[] extraAttributes;
                    IPath path = each.getPath();
                    int entryKind = each.getEntryKind();
                    if (entryKind != 3) continue;
                    for (IBuildpathAttribute eachAttr : extraAttributes = each.getExtraAttributes()) {
                        if (!eachAttr.getName().equals(BUILDPATH_ATTRIBUTE_RUTA) || !eachAttr.getValue().equals(BUILDPATH_ATTRIBUTE_RESOURCES)) continue;
                        result.add(ResourcesPlugin.getWorkspace().getRoot().getFolder(path));
                    }
                }
            }
        }
        if (result.isEmpty() && (findElement = project.getFolder(RutaProjectUtils.getDefaultResourcesLocation())) != null) {
            result.add(findElement);
        }
        return result;
    }

    public static List<String> getFolderLocations(List<IFolder> folders) {
        ArrayList<String> result = new ArrayList<String>();
        if (folders == null) {
            return result;
        }
        for (IFolder each : folders) {
            String portableString = each.getLocation().toPortableString();
            result.add(portableString);
        }
        return result;
    }

    public static IPath getScriptRootPath(IProject project) throws CoreException {
        List<IFolder> scriptFolders = RutaProjectUtils.getScriptFolders(project);
        if (scriptFolders != null && !scriptFolders.isEmpty()) {
            return scriptFolders.get(0).getLocation();
        }
        IPath projectPath = project.getLocation();
        IPath descPath = projectPath.append(RutaProjectUtils.getDefaultScriptLocation());
        return descPath;
    }

    public static IPath getPackagePath(IPath scriptIPath, IProject project) throws CoreException {
        List<IFolder> scriptFolders = RutaProjectUtils.getScriptFolders(project);
        URI scriptURI = URIUtil.toURI((IPath)scriptIPath);
        java.nio.file.Path scriptPath = Paths.get(scriptURI);
        IPath descIPath = null;
        for (IFolder eachFolder : scriptFolders) {
            IPath eachLocation = eachFolder.getLocation();
            URI eachURI = URIUtil.toURI((IPath)eachLocation);
            java.nio.file.Path eachPath = Paths.get(eachURI);
            if (!scriptPath.startsWith(eachPath)) continue;
            descIPath = eachLocation;
            break;
        }
        if (descIPath != null) {
            IPath makeRelativeTo = scriptIPath.makeRelativeTo(descIPath);
            IPath relativePackagePath = makeRelativeTo.removeLastSegments(1);
            return relativePackagePath;
        }
        return null;
    }

    public static String getModuleName(IPath path) {
        String result = path.lastSegment();
        int lastIndexOf = result.lastIndexOf(".ruta");
        if (lastIndexOf != -1) {
            result = result.substring(0, lastIndexOf);
        }
        return result;
    }

    public static void addProjectDataPath(IProject project, IFolder folder) throws CoreException {
        String addon;
        String[] split;
        List<String> paths;
        String dataPath = project.getPersistentProperty(new QualifiedName("", CDE_DATA_PATH));
        String sep = System.getProperty("path.separator");
        if (dataPath == null) {
            dataPath = "";
        }
        if (!(paths = Arrays.asList(split = dataPath.split(sep))).contains(addon = folder.getLocation().toPortableString())) {
            if (!StringUtils.isEmpty((CharSequence)dataPath)) {
                dataPath = dataPath + sep;
            }
            dataPath = dataPath + addon;
            project.setPersistentProperty(new QualifiedName("", CDE_DATA_PATH), dataPath);
        }
    }

    public static void removeProjectDataPath(IProject project, IFolder folder) throws CoreException {
        String dataPath = project.getPersistentProperty(new QualifiedName("", CDE_DATA_PATH));
        String sep = System.getProperty("path.separator");
        if (dataPath == null) {
            return;
        }
        String path = folder.getLocation().toPortableString();
        if (!StringUtils.isEmpty((CharSequence)dataPath)) {
            dataPath = dataPath.replaceAll(path, "");
            dataPath = dataPath.replaceAll(sep + sep, "");
        }
        project.setPersistentProperty(new QualifiedName("", CDE_DATA_PATH), dataPath);
    }

    public static IProject getProject(IPath path) {
        IResource member = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
        if (member instanceof IProject) {
            IProject p = (IProject)member;
            return p;
        }
        return null;
    }

    public static Collection<String> getClassPath(IProject project) throws CoreException {
        TreeSet<String> result = new TreeSet<String>();
        RutaProjectUtils.extendClasspathWithProject(result, project.getProject(), new HashSet<IProject>());
        Collection<String> dependencies = RutaProjectUtils.getDependencies(project.getProject());
        result.addAll(dependencies);
        return result;
    }

    private static Collection<String> getDependencies(IProject project) throws CoreException {
        IProject[] referencedProjects;
        TreeSet<String> result = new TreeSet<String>();
        for (IProject eachProject : referencedProjects = project.getReferencedProjects()) {
            RutaProjectUtils.extendClasspathWithProject(result, eachProject, new HashSet<IProject>());
            IProjectNature nature = eachProject.getNature("org.apache.uima.ruta.ide.nature");
            if (nature == null) continue;
            result.addAll(RutaProjectUtils.getDependencies(eachProject));
        }
        return result;
    }

    private static void extendClasspathWithProject(Collection<String> result, IProject project, Collection<IProject> visited) throws CoreException, JavaModelException {
        IProjectNature javaNature;
        IProjectNature rutaNature = project.getNature("org.apache.uima.ruta.ide.nature");
        if (rutaNature != null) {
            IScriptProject sp = DLTKCore.create((IProject)project);
            List<IFolder> scriptFolders = RutaProjectUtils.getScriptFolders(sp);
            for (IFolder each : scriptFolders) {
                result.add(each.getLocation().toPortableString());
            }
            List<IFolder> descriptorFolders = RutaProjectUtils.getDescriptorFolders(project);
            for (IFolder each : descriptorFolders) {
                result.add(each.getLocation().toPortableString());
            }
            List<IFolder> resourceFolders = RutaProjectUtils.getResourceFolders(project);
            for (IFolder each : resourceFolders) {
                result.add(each.getLocation().toPortableString());
            }
        }
        if ((javaNature = project.getNature(JAVANATURE)) != null) {
            IClasspathEntry[] rawClasspath;
            JavaProject javaProject = (JavaProject)JavaCore.create((IProject)project);
            IPath readOutputLocation = javaProject.readOutputLocation();
            IFolder folder = ResourcesPlugin.getWorkspace().getRoot().getFolder(readOutputLocation);
            result.add(folder.getLocation().toPortableString());
            for (IClasspathEntry each : rawClasspath = javaProject.getRawClasspath()) {
                IClasspathEntry[] resolveClasspath;
                String segment;
                int entryKind = each.getEntryKind();
                IPath path = each.getPath();
                if (entryKind == 2) {
                    IProject p = RutaProjectUtils.getProject(path);
                    if (visited.contains(p)) continue;
                    visited.add(p);
                    RutaProjectUtils.extendClasspathWithProject(result, p, visited);
                    continue;
                }
                if (entryKind == 3 || (segment = path.segment(0)).equals("org.eclipse.jdt.launching.JRE_CONTAINER")) continue;
                for (IClasspathEntry eachResolved : resolveClasspath = javaProject.resolveClasspath(new IClasspathEntry[]{each})) {
                    if (eachResolved.getEntryKind() == 2) {
                        IProject p = RutaProjectUtils.getProject(eachResolved.getPath());
                        if (visited.contains(p)) continue;
                        visited.add(p);
                        RutaProjectUtils.extendClasspathWithProject(result, p, visited);
                        continue;
                    }
                    result.add(eachResolved.getPath().toPortableString());
                }
            }
        }
    }

    public static String getDefaultInputLocation() {
        return "input";
    }

    public static String getDefaultOutputLocation() {
        return "output";
    }

    public static String getDefaultTestLocation() {
        return "test";
    }

    public static String getDefaultCleanTestLocation() {
        return "temp_clean";
    }

    public static String getDefaultScriptLocation() {
        return BUILDPATH_ATTRIBUTE_SCRIPT;
    }

    public static String getDefaultResourcesLocation() {
        return BUILDPATH_ATTRIBUTE_RESOURCES;
    }

    public static String getDefaultDescriptorLocation() {
        return BUILDPATH_ATTRIBUTE_DESCRIPTOR;
    }

    public static String getDefaultTempTestLocation() {
        return "temp";
    }
}

