/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.explain.rulelist;

import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.Type;
import org.apache.uima.caseditor.editor.AnnotationEditor;
import org.apache.uima.ruta.explain.apply.ApplyTreeContentProvider;
import org.apache.uima.ruta.explain.apply.ApplyTreeLabelProvider;
import org.apache.uima.ruta.explain.apply.ApplyViewPage;
import org.apache.uima.ruta.explain.tree.ApplyRootNode;
import org.apache.uima.ruta.explain.tree.ExplainTree;
import org.apache.uima.ruta.explain.tree.IExplainTreeNode;
import org.apache.uima.ruta.explain.tree.RuleApplyNode;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;

public class RuleListViewPage
extends ApplyViewPage
implements Listener {
    protected Text filterTextField;
    protected String manualFilter = "";
    private Composite overlay;
    private int offset = -1;

    public RuleListViewPage(AnnotationEditor editor) {
        super(editor);
    }

    @Override
    public void createControl(Composite parent) {
        this.overlay = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.overlay.setLayout((Layout)layout);
        this.filterTextField = new Text(this.overlay, 2052);
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.horizontalSpan = 1;
        this.filterTextField.setLayoutData((Object)gd);
        this.filterTextField.setToolTipText("Retain types that contain...");
        this.filterTextField.addListener(2, (Listener)this);
        this.filterTextField.addListener(4, (Listener)this);
        this.filterTextField.addListener(24, (Listener)this);
        this.filterTextField.setMessage("Only rules with...");
        this.viewer = new CheckboxTreeViewer(this.overlay, 770);
        gd = new GridData(1808);
        this.viewer.getTree().setLayoutData((Object)gd);
        this.viewer.setContentProvider((IContentProvider)new ApplyTreeContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ApplyTreeLabelProvider(this));
        this.viewer.setInput((Object)new ApplyRootNode(null, this.document.getCAS().getTypeSystem()));
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.getSite().getPage().addSelectionListener((ISelectionListener)this);
    }

    private void filterTree(ExplainTree tree) {
        Type ruleType = this.document.getCAS().getTypeSystem().getType("org.apache.uima.ruta.type.DebugRuleApply");
        IExplainTreeNode root = tree.getRoot();
        ArrayList<IExplainTreeNode> children = new ArrayList<IExplainTreeNode>(root.getChildren());
        for (IExplainTreeNode each : children) {
            if (!(each instanceof RuleApplyNode)) continue;
            RuleApplyNode ran = (RuleApplyNode)each;
            Feature f = ruleType.getFeatureByBaseName("element");
            if (f == null) continue;
            String v = ran.getFeatureStructure().getStringValue(f);
            if (StringUtils.isEmpty((CharSequence)this.manualFilter) || v.indexOf(this.manualFilter) != -1) continue;
            root.removeChild(ran);
        }
    }

    public void handleEvent(Event event) {
        if (event.widget == this.filterTextField && event.type == 24) {
            this.manualFilter = this.filterTextField.getText();
            this.reloadTree();
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.overlay.dispose();
    }

    @Override
    public Control getControl() {
        return this.overlay;
    }

    @Override
    public void setFocus() {
        this.overlay.setFocus();
    }

    @Override
    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (selection instanceof StructuredSelection && part instanceof AnnotationEditor) {
            this.offset = this.editor.getCaretOffset();
            if (this.offset >= 0) {
                this.reloadTree();
            }
        }
    }

    private void reloadTree() {
        ExplainTree tree = new ExplainTree(this.document.getCAS(), this.offset, true);
        this.filterTree(tree);
        this.viewer.setInput((Object)tree.getRoot());
        this.viewer.refresh();
    }
}

