/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.textruler.core;

import java.util.ArrayList;
import java.util.List;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.cas.CAS;
import org.apache.uima.ruta.textruler.TextRulerPlugin;
import org.apache.uima.ruta.textruler.core.TextRulerToolkit;

public class GlobalCASSource {
    private static List<CAS> free = new ArrayList<CAS>();
    private static List<CAS> inUsage = new ArrayList<CAS>();
    private static int count = 0;

    public static synchronized CAS allocCAS(AnalysisEngine ae) {
        if (free.size() > 0) {
            CAS result = free.get(free.size() - 1);
            free.remove(free.size() - 1);
            inUsage.add(result);
            return result;
        }
        try {
            ++count;
            CAS newCas = ae.newCAS();
            inUsage.add(newCas);
            return newCas;
        }
        catch (Exception e) {
            TextRulerPlugin.error(e);
            return null;
        }
    }

    public static synchronized void releaseCAS(CAS cas) {
        if (inUsage.contains(cas)) {
            cas.reset();
            inUsage.remove(cas);
            free.add(cas);
        } else {
            TextRulerToolkit.log("[GlobalCASSource.release] Error, tried to release an unknown CAS object!");
        }
    }
}

