/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.verbalize;

import java.util.Iterator;
import java.util.List;
import org.apache.uima.cas.Type;
import org.apache.uima.ruta.expression.RutaExpression;
import org.apache.uima.ruta.verbalize.RutaVerbalizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VerbalizerUtils {
    private RutaVerbalizer verbalizer;

    public VerbalizerUtils(RutaVerbalizer verbalizer) {
        this.verbalizer = verbalizer;
    }

    public String verbalizeList(List<?> list) {
        StringBuilder result = new StringBuilder();
        Iterator<?> it = list.iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            result.append(obj.toString());
            if (!it.hasNext()) continue;
            result.append(", ");
        }
        return result.toString();
    }

    public String verbalizeTypeList(List<Type> list) {
        StringBuilder result = new StringBuilder();
        Iterator<Type> it = list.iterator();
        while (it.hasNext()) {
            Type type = it.next();
            result.append(this.verbalizer.verbalizeType(type));
            if (!it.hasNext()) continue;
            result.append(", ");
        }
        return result.toString();
    }

    public String verbalizeExpressionList(List<? extends RutaExpression> list) {
        StringBuilder result = new StringBuilder();
        Iterator<? extends RutaExpression> it = list.iterator();
        while (it.hasNext()) {
            RutaExpression e = it.next();
            result.append(this.verbalizer.verbalize(e));
            if (!it.hasNext()) continue;
            result.append(", ");
        }
        return result.toString();
    }
}

