/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.engine;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.JCasAnnotator_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.ruta.engine.HtmlVisitor;
import org.htmlparser.Parser;
import org.htmlparser.util.NodeList;
import org.htmlparser.util.ParserException;

public class HtmlAnnotator
extends JCasAnnotator_ImplBase {
    public static final String NAMESPACE = "org.apache.uima.ruta.type.html.";
    public static final String ONLY_CONTENT = "onlyContent";
    private Boolean onlyContent;

    public void initialize(UimaContext aContext) throws ResourceInitializationException {
        super.initialize(aContext);
        this.onlyContent = (Boolean)aContext.getConfigParameterValue(ONLY_CONTENT);
        this.onlyContent = this.onlyContent == null ? true : this.onlyContent;
    }

    public void process(JCas jcas) throws AnalysisEngineProcessException {
        String documentText = jcas.getDocumentText();
        List<Object> annotations = new ArrayList();
        AbstractList annotationStack = new ArrayList();
        try {
            Parser parser = new Parser(documentText);
            NodeList nodeList = parser.parse(null);
            HtmlVisitor visitor = new HtmlVisitor(jcas, (boolean)this.onlyContent);
            nodeList.visitAllNodesWith(visitor);
            annotations = visitor.getAnnotations();
            annotationStack = visitor.getAnnotationStack();
        }
        catch (ParserException e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
        for (AnnotationFS annotationFS : annotations) {
            if (annotationFS.getBegin() >= annotationFS.getEnd()) continue;
            jcas.addFsToIndexes((FeatureStructure)annotationFS);
        }
        for (AnnotationFS annotationFS : annotationStack) {
            if (annotationFS.getBegin() >= annotationFS.getEnd()) continue;
            jcas.addFsToIndexes((FeatureStructure)annotationFS);
        }
    }
}

