/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.textruler.learner.lp2;

import java.util.ArrayList;
import java.util.List;
import org.apache.uima.cas.Type;
import org.apache.uima.ruta.textruler.core.TextRulerAnnotation;
import org.apache.uima.ruta.textruler.core.TextRulerRule;
import org.apache.uima.ruta.textruler.core.TextRulerRuleItem;
import org.apache.uima.ruta.textruler.core.TextRulerSingleSlotRule;
import org.apache.uima.ruta.textruler.core.TextRulerTarget;
import org.apache.uima.ruta.textruler.core.TextRulerToolkit;
import org.apache.uima.ruta.textruler.core.TextRulerWordConstraint;
import org.apache.uima.ruta.textruler.learner.lp2.LP2Rule;

public class LP2RuleItem
implements TextRulerRuleItem {
    protected TextRulerWordConstraint wordConstraint;
    protected MLLP2ContextConstraint contextConstraint;
    protected List<MLLP2OtherConstraint> otherConstraints = new ArrayList<MLLP2OtherConstraint>();

    public LP2RuleItem(LP2RuleItem copyFrom) {
        if (copyFrom.wordConstraint != null) {
            this.wordConstraint = copyFrom.wordConstraint.copy();
        }
        if (copyFrom.contextConstraint != null) {
            this.contextConstraint = copyFrom.contextConstraint.copy();
        }
        for (MLLP2OtherConstraint c : copyFrom.otherConstraints) {
            this.otherConstraints.add(c.copy());
        }
    }

    public LP2RuleItem() {
    }

    @Override
    public LP2RuleItem copy() {
        return new LP2RuleItem(this);
    }

    @Override
    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    public boolean equals(TextRulerRuleItem o) {
        return this.toString().equals(((LP2RuleItem)o).toString());
    }

    @Override
    public String toString() {
        return this.getStringForRuleString(null, null, 0, 0, 0, 0, 0);
    }

    public MLLP2OtherConstraint getTMBasicTypeTokenConstraint() {
        for (MLLP2OtherConstraint c : this.otherConstraints) {
            if (!c.isTMBasicTypeTokenConstraint()) continue;
            return c;
        }
        return null;
    }

    @Override
    public String getStringForRuleString(TextRulerRule rule, TextRulerRuleItem.MLRuleItemType type, int numberInPattern, int patternSize, int numberInRule, int ruleSize, int slotIndex) {
        String result = "";
        LP2Rule lp2Rule = (LP2Rule)rule;
        boolean isMarkingItem = rule != null && (rule.getTarget().type == TextRulerTarget.MLTargetType.SINGLE_RIGHT_BOUNDARY && type == TextRulerRuleItem.MLRuleItemType.PREFILLER && numberInPattern == patternSize - 1 || rule.getTarget().type == TextRulerTarget.MLTargetType.SINGLE_LEFT_BOUNDARY && type == TextRulerRuleItem.MLRuleItemType.POSTFILLER && numberInPattern == 0);
        ArrayList<String> constraints = new ArrayList<String>();
        String anchor = null;
        if (this.wordConstraint == null) {
            anchor = "ANY";
        } else if (this.wordConstraint.isRegExpConstraint()) {
            anchor = this.wordConstraint.typeShortName();
            constraints.add("REGEXP(\"" + this.wordConstraint + "\")");
        } else {
            anchor = this.wordConstraint.toString();
        }
        if (isMarkingItem && lp2Rule.isContextualRule()) {
            constraints.add("-IS(" + ((TextRulerSingleSlotRule)rule).getMarkName() + ")");
        }
        if (this.contextConstraint != null) {
            constraints.add(this.contextConstraint.toString());
        }
        MLLP2OtherConstraint anchorConstraint = null;
        if (this.wordConstraint == null) {
            anchorConstraint = this.getTMBasicTypeTokenConstraint();
            if (anchorConstraint == null) {
                for (MLLP2OtherConstraint c : this.otherConstraints) {
                    if (!c.canBeAnchorConstraint()) continue;
                    anchorConstraint = c;
                    break;
                }
            }
            for (MLLP2OtherConstraint oc : this.otherConstraints) {
                if (oc == anchorConstraint) continue;
                if (oc.canBeAnchorConstraint()) {
                    constraints.add("IS(" + oc + ")");
                    continue;
                }
                constraints.add("PARTOF(" + oc + ")");
            }
            if (anchorConstraint != null) {
                anchor = anchorConstraint.toString();
            }
        }
        if (constraints.size() > 0) {
            String cStr = "";
            for (String constraintStr : constraints) {
                if (cStr.length() > 0) {
                    cStr = cStr + ", ";
                }
                cStr = cStr + constraintStr;
            }
            result = result + "{" + cStr;
        }
        if (rule != null && (rule.getTarget().type == TextRulerTarget.MLTargetType.SINGLE_RIGHT_BOUNDARY && type == TextRulerRuleItem.MLRuleItemType.PREFILLER && numberInPattern == patternSize - 1 || rule.getTarget().type == TextRulerTarget.MLTargetType.SINGLE_LEFT_BOUNDARY && type == TextRulerRuleItem.MLRuleItemType.POSTFILLER && numberInPattern == 0)) {
            if (constraints.size() == 0) {
                result = result + "{";
            }
            result = result + "->MARKONCE(" + ((TextRulerSingleSlotRule)rule).getMarkName() + ")";
            if (lp2Rule.isContextualRule()) {
                result = result + ", ASSIGN(redoContextualRules, true)";
            }
            result = result + "}";
        } else if (constraints.size() != 0) {
            result = result + "}";
        }
        return anchor + result;
    }

    public void addOtherConstraint(MLLP2OtherConstraint c) {
        if (!this.otherConstraints.contains(c)) {
            this.otherConstraints.add(c);
        }
    }

    public List<MLLP2OtherConstraint> getOtherConstraints() {
        return this.otherConstraints;
    }

    public void setWordConstraint(TextRulerAnnotation tokenAnnotation) {
        this.setWordConstraint(new TextRulerWordConstraint(tokenAnnotation));
    }

    public void setContextConstraint(MLLP2ContextConstraint c) {
        this.contextConstraint = c;
    }

    public MLLP2ContextConstraint getContextConstraint() {
        return this.contextConstraint;
    }

    public void setWordConstraint(TextRulerWordConstraint c) {
        this.wordConstraint = c;
    }

    public TextRulerWordConstraint getWordConstraint() {
        return this.wordConstraint;
    }

    public int totalConstraintCount() {
        return this.otherConstraints.size() + (this.wordConstraint != null ? 1 : 0) + (this.contextConstraint != null ? 1 : 0);
    }

    public static class MLLP2OtherConstraint {
        TextRulerAnnotation tokenAnnotation;
        TextRulerAnnotation constraintAnnotation;
        boolean canBeAnchor;
        Type type;

        public MLLP2OtherConstraint(TextRulerAnnotation tokenAnnotation, TextRulerAnnotation constraintAnnotation) {
            this.tokenAnnotation = tokenAnnotation;
            this.constraintAnnotation = constraintAnnotation;
            this.type = constraintAnnotation.getType();
            this.canBeAnchor = tokenAnnotation.getBegin() == constraintAnnotation.getBegin() && tokenAnnotation.getEnd() == constraintAnnotation.getEnd();
        }

        public boolean isTMBasicTypeTokenConstraint() {
            return this.tokenAnnotation == this.constraintAnnotation;
        }

        public boolean canBeAnchorConstraint() {
            return this.canBeAnchor;
        }

        public boolean equals(Object o) {
            MLLP2OtherConstraint co = (MLLP2OtherConstraint)o;
            return this.toString().equals(co.toString()) && this.canBeAnchor == co.canBeAnchor;
        }

        public int hashCode() {
            return this.toString().hashCode() * (this.canBeAnchor ? 2 : 1);
        }

        public String toString() {
            return this.type.getShortName();
        }

        public MLLP2OtherConstraint copy() {
            return new MLLP2OtherConstraint(this.tokenAnnotation, this.constraintAnnotation);
        }
    }

    public static class MLLP2ContextConstraint {
        private String contextBoundaryName;
        private int contextSize;
        private boolean direction;

        public MLLP2ContextConstraint(int contextSize, LP2Rule parentRule) {
            this.contextSize = contextSize;
            this.contextBoundaryName = TextRulerToolkit.getTypeShortName(parentRule.getTarget().getCounterPartBoundaryTarget().getSingleSlotTypeName());
            this.direction = parentRule.getTarget().type == TextRulerTarget.MLTargetType.SINGLE_LEFT_BOUNDARY;
        }

        public MLLP2ContextConstraint(MLLP2ContextConstraint copyFrom) {
            this.contextBoundaryName = copyFrom.contextBoundaryName;
            this.contextSize = copyFrom.contextSize;
            this.direction = copyFrom.direction;
        }

        public MLLP2ContextConstraint copy() {
            return new MLLP2ContextConstraint(this);
        }

        public String toString() {
            return "NEAR(" + this.contextBoundaryName + ", 0," + this.contextSize + "," + (this.direction ? "true" : "false") + ",true)";
        }

        public boolean equals(Object o) {
            return this.toString().equals(((MLLP2ContextConstraint)o).toString());
        }

        public int hashCode() {
            return this.toString().hashCode();
        }
    }
}

