/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.caseditor.view.tree;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.cas.text.AnnotationIndex;
import org.apache.uima.caseditor.editor.AnnotationEditor;
import org.apache.uima.caseditor.editor.AnnotationStyle;
import org.apache.uima.caseditor.editor.AnnotationStyleChangeListener;
import org.apache.uima.caseditor.editor.IAnnotationEditorModifyListener;
import org.apache.uima.caseditor.editor.ICasDocument;
import org.apache.uima.caseditor.editor.ICasDocumentListener;
import org.apache.uima.ruta.caseditor.RutaCasEditorPlugin;
import org.apache.uima.ruta.caseditor.view.tree.AbstractTreeNode;
import org.apache.uima.ruta.caseditor.view.tree.AnnotationTreeContentProvider;
import org.apache.uima.ruta.caseditor.view.tree.AnnotationTreeLabelProvider;
import org.apache.uima.ruta.caseditor.view.tree.AnnotationTreeNode;
import org.apache.uima.ruta.caseditor.view.tree.AnnotationTreeViewDragListener;
import org.apache.uima.ruta.caseditor.view.tree.IRootTreeNode;
import org.apache.uima.ruta.caseditor.view.tree.ITreeNode;
import org.apache.uima.ruta.caseditor.view.tree.ToolTipListener;
import org.apache.uima.ruta.caseditor.view.tree.TypeOrderedRootTreeNode;
import org.apache.uima.ruta.caseditor.view.tree.TypeTreeNode;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.Page;

public class AnnotationTreeViewPage
extends Page
implements MouseListener,
IDoubleClickListener,
Listener,
ISelectionListener,
ICheckStateListener,
IAnnotationEditorModifyListener {
    private CheckboxTreeViewer treeView;
    private AnnotationTreeLabelProvider lableProvider;
    protected Text filterTypeTextField;
    private Map<Type, Image> icons = new HashMap<Type, Image>();
    private Image rutaImage;
    private Composite overlay;
    protected AnnotationEditor editor;
    protected ICasDocument document;
    private boolean useSelection;
    private Text filterCoveredTextTextField;
    private int offset = -1;
    private TreeViewAnnotationStyleChangeListener styleListener;

    public AnnotationTreeViewPage(boolean useSelection, AnnotationEditor editor) {
        this.useSelection = useSelection;
        this.editor = editor;
        this.document = editor.getDocument();
    }

    public void init(IPageSite pageSite) {
        super.init(pageSite);
    }

    public void createControl(Composite parent) {
        this.overlay = new Composite(parent, 0);
        final Clipboard clipboard = new Clipboard(Display.getCurrent());
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.overlay.setLayout((Layout)layout);
        KeyAdapter checkSelectedKeyListener = new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                int keyCode = keyEvent.keyCode;
                if (keyCode == 13 || keyCode == 10 || keyCode == 0x1000050) {
                    AnnotationTreeViewPage.this.uncheckAll();
                    AnnotationTreeViewPage.this.checkAllVisible();
                }
            }
        };
        this.filterTypeTextField = new Text(this.overlay, 2052);
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.horizontalSpan = 1;
        this.filterTypeTextField.setLayoutData((Object)gd);
        this.filterTypeTextField.setToolTipText("Retain types that contain...");
        this.filterTypeTextField.addListener(2, (Listener)this);
        this.filterTypeTextField.addListener(4, (Listener)this);
        this.filterTypeTextField.addListener(24, (Listener)this);
        this.filterTypeTextField.setMessage("Only types with...");
        this.filterTypeTextField.addKeyListener((KeyListener)checkSelectedKeyListener);
        this.filterCoveredTextTextField = new Text(this.overlay, 2052);
        GridData gd2 = new GridData();
        gd2.grabExcessHorizontalSpace = true;
        gd2.horizontalAlignment = 4;
        gd2.horizontalSpan = 1;
        this.filterCoveredTextTextField.setLayoutData((Object)gd2);
        this.filterCoveredTextTextField.setToolTipText("Only annotation with...");
        this.filterCoveredTextTextField.addListener(2, (Listener)this);
        this.filterCoveredTextTextField.addListener(4, (Listener)this);
        this.filterCoveredTextTextField.addListener(24, (Listener)this);
        this.filterCoveredTextTextField.setMessage("Only annotations with...");
        this.filterCoveredTextTextField.addKeyListener((KeyListener)checkSelectedKeyListener);
        this.treeView = new CheckboxTreeViewer(this.overlay, 770);
        gd = new GridData(1808);
        this.treeView.getTree().setLayoutData((Object)gd);
        AnnotationTreeContentProvider provider = new AnnotationTreeContentProvider(this.editor, this);
        this.treeView.setContentProvider((IContentProvider)provider);
        this.document.addChangeListener((ICasDocumentListener)provider);
        this.lableProvider = new AnnotationTreeLabelProvider(this);
        this.treeView.setLabelProvider((IBaseLabelProvider)this.lableProvider);
        this.treeView.addCheckStateListener((ICheckStateListener)this);
        this.treeView.addDoubleClickListener((IDoubleClickListener)this);
        this.treeView.getTree().addMouseListener((MouseListener)this);
        ToolTipListener tl = new ToolTipListener(this.treeView.getTree());
        this.treeView.getTree().addListener(12, (Listener)tl);
        this.treeView.getTree().addListener(1, (Listener)tl);
        this.treeView.getTree().addListener(5, (Listener)tl);
        this.treeView.getTree().addListener(32, (Listener)tl);
        int ops = 3;
        Transfer[] transfers = new Transfer[]{TextTransfer.getInstance()};
        this.treeView.addDragSupport(ops, transfers, (DragSourceListener)new AnnotationTreeViewDragListener((StructuredViewer)this.treeView));
        this.getTreeViewer().getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                Object obj;
                TreeItem[] selection;
                int keyCode = e.keyCode;
                if (keyCode == 8 || keyCode == 127) {
                    AnnotationTreeViewPage.this.deleteSelectedAnnotations();
                }
                if ((e.stateMask & 0x40000) == 262144 && keyCode == 99 && (selection = AnnotationTreeViewPage.this.treeView.getTree().getSelection()) != null && selection.length == 1 && (obj = selection[0].getData()) instanceof TypeTreeNode) {
                    TypeTreeNode typeTreeNode = (TypeTreeNode)obj;
                    Type type = typeTreeNode.getType();
                    TextTransfer textTransfer = TextTransfer.getInstance();
                    clipboard.setContents(new Object[]{type.getName()}, new Transfer[]{textTransfer});
                }
                if ((e.stateMask & 0x40000) == 262144) {
                    if (keyCode == 117) {
                        AnnotationTreeViewPage.this.modifyAnnotation(ModifyAnnotationOperation.WIDE_L);
                    } else if (keyCode == 105) {
                        AnnotationTreeViewPage.this.modifyAnnotation(ModifyAnnotationOperation.LOWER_L);
                    } else if (keyCode == 111) {
                        AnnotationTreeViewPage.this.modifyAnnotation(ModifyAnnotationOperation.LOWER_R);
                    } else if (keyCode == 112) {
                        AnnotationTreeViewPage.this.modifyAnnotation(ModifyAnnotationOperation.WIDE_R);
                    }
                }
            }
        });
        this.styleListener = new TreeViewAnnotationStyleChangeListener();
        this.editor.getCasDocumentProvider().getTypeSystemPreferenceStore((Object)this.editor.getEditorInput()).addPropertyChangeListener((IPropertyChangeListener)this.styleListener);
        this.rutaImage = RutaCasEditorPlugin.getImageDescriptor("/icons/views.png").createImage();
        this.getSite().getPage().addSelectionListener((ISelectionListener)this);
        this.getSite().setSelectionProvider((ISelectionProvider)this.treeView);
        this.editor.addAnnotationListener((IAnnotationEditorModifyListener)this);
        if (!this.useSelection) {
            this.reloadTree();
        }
    }

    public void makeContributions(IMenuManager menuManager, IToolBarManager toolBarManager, IStatusLineManager statusLineManager) {
        CheckAllVisibleAction createActionCheckVisible = new CheckAllVisibleAction();
        createActionCheckVisible.setText("Set all types visible in the Annotation Browser to be highlighted in the CAS editor.");
        ImageDescriptor imageDescriptor = RutaCasEditorPlugin.getImageDescriptor("/icons/lightbulb_add.png");
        createActionCheckVisible.setImageDescriptor(imageDescriptor);
        toolBarManager.add((IAction)createActionCheckVisible);
        UncheckAllAction createActionUncheckAll = new UncheckAllAction();
        createActionUncheckAll.setText("Reset type highlighting. No type will be checked.");
        createActionUncheckAll.setImageDescriptor(RutaCasEditorPlugin.getImageDescriptor("/icons/lightbulb_off.png"));
        toolBarManager.add((IAction)createActionUncheckAll);
        if (!this.useSelection) {
            ShowTypesWithoutAnnotations showTypesWithoutAnnotations = new ShowTypesWithoutAnnotations();
            menuManager.add((IAction)showTypesWithoutAnnotations);
        }
    }

    public void uncheckAll() {
        this.editor.setShownAnnotationTypes(new LinkedList());
        this.getTreeViewer().getTree().deselectAll();
    }

    public void checkAllVisible() {
        TypeSystem ts = this.editor.getDocument().getCAS().getTypeSystem();
        Type documentAnnotationType = ts.getType("uima.tcas.DocumentAnnotation");
        LinkedList<Type> selectedTypes = new LinkedList<Type>();
        for (TreeItem i : this.getTreeViewer().getTree().getItems()) {
            TypeTreeNode typeTreeNode;
            Type type;
            Object e = i.getData();
            if (!(e instanceof TypeTreeNode) || documentAnnotationType.equals(type = (typeTreeNode = (TypeTreeNode)e).getType())) continue;
            selectedTypes.add(type);
        }
        this.editor.setShownAnnotationTypes(selectedTypes);
    }

    public void dispose() {
        this.getSite().getPage().removeSelectionListener((ISelectionListener)this);
        this.editor.removeAnnotationListener((IAnnotationEditorModifyListener)this);
        this.editor.getCasDocumentProvider().getTypeSystemPreferenceStore((Object)this.editor.getEditorInput()).removePropertyChangeListener((IPropertyChangeListener)this.styleListener);
        this.overlay.dispose();
        Collection<Image> values = this.icons.values();
        for (Image image : values) {
            image.dispose();
        }
        this.rutaImage.dispose();
        super.dispose();
    }

    public Control getControl() {
        return this.overlay;
    }

    public CheckboxTreeViewer getTreeViewer() {
        return this.treeView;
    }

    public void setFocus() {
        this.overlay.setFocus();
    }

    public void doubleClick(DoubleClickEvent event) {
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void modifyAnnotation(ModifyAnnotationOperation operationType) {
        TreeItem[] items = this.treeView.getTree().getSelection();
        if (items.length != 1) {
            return;
        }
        Feature beginFeature = this.document.getCAS().getBeginFeature();
        Feature endFeature = this.document.getCAS().getEndFeature();
        for (TreeItem it : items) {
            if (!(it.getData() instanceof AnnotationTreeNode)) continue;
            AnnotationTreeNode annot = (AnnotationTreeNode)it.getData();
            AnnotationFS fs = annot.getAnnotation();
            switch (operationType) {
                case WIDE_L: {
                    if (fs.getBegin() <= 0) break;
                    fs.setIntValue(beginFeature, fs.getBegin() - 1);
                    break;
                }
                case LOWER_L: {
                    if (fs.getBegin() >= fs.getEnd() - 1) break;
                    fs.setIntValue(beginFeature, fs.getBegin() + 1);
                    break;
                }
                case LOWER_R: {
                    if (fs.getEnd() <= fs.getBegin() + 1) break;
                    fs.setIntValue(endFeature, fs.getEnd() - 1);
                    break;
                }
                case WIDE_R: {
                    if (fs.getEnd() >= fs.getCAS().getDocumentText().length()) break;
                    fs.setIntValue(endFeature, fs.getEnd() + 1);
                    break;
                }
            }
            this.document.update((FeatureStructure)fs);
        }
    }

    public void deleteSelectedAnnotations() {
        if (MessageDialog.openConfirm((Shell)Display.getCurrent().getActiveShell(), (String)"Confirm Delete", (String)"Are you sure you want to delete these items?")) {
            TreeItem[] items = this.treeView.getTree().getSelection();
            HashSet<AnnotationFS> annots = new HashSet<AnnotationFS>();
            for (TreeItem it : items) {
                if (it.getData() instanceof AnnotationTreeNode) {
                    AnnotationTreeNode annot = (AnnotationTreeNode)it.getData();
                    annots.add(annot.getAnnotation());
                    continue;
                }
                if (!(it.getData() instanceof TypeTreeNode)) continue;
                TypeTreeNode type = (TypeTreeNode)it.getData();
                for (ITreeNode child : type.getChildren()) {
                    if (!(child instanceof AnnotationTreeNode)) continue;
                    AnnotationTreeNode annot = (AnnotationTreeNode)child;
                    annots.add(annot.getAnnotation());
                }
            }
            this.editor.getDocument().removeFeatureStructures(annots);
        }
    }

    public void mouseDown(final MouseEvent mouseEvent) {
        if (mouseEvent.button == 3) {
            Display display = Display.getCurrent();
            Menu menu = new Menu((Decorations)display.getActiveShell(), 8);
            MenuItem item = new MenuItem(menu, 8);
            item.setText("Set Annotation Mode");
            item.setImage(this.rutaImage);
            item.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    Type type;
                    TreeItem item = AnnotationTreeViewPage.this.treeView.getTree().getItem(new Point(mouseEvent.x, mouseEvent.y));
                    if (item != null && item.getData() instanceof AbstractTreeNode && (type = ((AbstractTreeNode)item.getData()).getType()) != null) {
                        AnnotationTreeViewPage.this.getTreeViewer().setGrayed((Object)new TypeTreeNode(null, type), false);
                        AnnotationTreeViewPage.this.editor.setAnnotationMode(type);
                    }
                }
            });
            menu.setVisible(true);
            while (!menu.isDisposed() && menu.isVisible()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
            menu.dispose();
        }
    }

    public void mouseUp(MouseEvent e) {
    }

    public Image getIcon(Type type) {
        if (this.icons.containsKey(type)) {
            return this.icons.get(type);
        }
        Image image = this.updateIcon(type);
        return image;
    }

    private void updateIcon(String typeName) {
        Set<Type> keySet = this.icons.keySet();
        for (Type type : keySet) {
            String name = type.getName();
            if (!name.equals(typeName)) continue;
            this.updateIcon(type);
            return;
        }
    }

    private Image updateIcon(Type type) {
        AnnotationStyle style = this.editor.getAnnotationStyle(type);
        Color fg = new Color((Device)Display.getCurrent(), 0, 0, 0);
        Color bg = new Color((Device)Display.getCurrent(), style.getColor().getRed(), style.getColor().getGreen(), style.getColor().getBlue());
        PaletteData paletteData = new PaletteData(new RGB[]{bg.getRGB(), fg.getRGB()});
        ImageData imageData = new ImageData(40, 40, 1, paletteData);
        Image image = new Image((Device)Display.getCurrent(), imageData);
        GC gc = new GC((Drawable)image);
        String styleString = style.getStyle().name().substring(0, 2);
        Point p = gc.stringExtent(styleString);
        gc.dispose();
        image.dispose();
        imageData = new ImageData(p.x + 4, p.y, 1, paletteData);
        image = new Image((Device)Display.getCurrent(), imageData);
        gc = new GC((Drawable)image);
        gc.setBackground(bg);
        gc.setForeground(fg);
        gc.setTextAntialias(1);
        gc.drawString(styleString, 2, 0);
        gc.dispose();
        Image oldImage = this.icons.get(type);
        if (oldImage != null) {
            oldImage.dispose();
        }
        this.icons.put(type, image);
        return image;
    }

    public IRootTreeNode getTypeOrderedTree(int pos, String manualTypeFilter, String manualTextFilter) {
        boolean typeConstraint;
        CAS cas = this.editor.getDocument().getCAS();
        TypeOrderedRootTreeNode root = new TypeOrderedRootTreeNode(cas);
        IPreferenceStore preferenceStore = RutaCasEditorPlugin.getDefault().getPreferenceStore();
        boolean withParents = preferenceStore.getBoolean("showParentTypes");
        if (this.isTreeWithTypesWithoutAnnotations()) {
            Type atype = cas.getAnnotationType();
            TypeSystem ts = cas.getTypeSystem();
            for (Type type : ts.getProperlySubsumedTypes(atype)) {
                typeConstraint = StringUtils.isEmpty((CharSequence)manualTypeFilter) || type.getName().toLowerCase().indexOf(manualTypeFilter.toLowerCase()) != -1;
                if (!typeConstraint) continue;
                root.getTreeNode(type, cas);
            }
        }
        AnnotationIndex annotationIndex = this.document.getCAS().getAnnotationIndex();
        for (AnnotationFS annotationFS : annotationIndex) {
            boolean textConstraint;
            boolean offsetConstraint = pos == -1 || annotationFS.getBegin() <= pos && annotationFS.getEnd() >= pos;
            typeConstraint = StringUtils.isEmpty((CharSequence)manualTypeFilter) || annotationFS.getType().getName().toLowerCase().indexOf(manualTypeFilter.toLowerCase()) != -1;
            boolean bl = textConstraint = StringUtils.isEmpty((CharSequence)manualTextFilter) || annotationFS.getCoveredText().toLowerCase().indexOf(manualTextFilter.toLowerCase()) != -1;
            if (!offsetConstraint || !typeConstraint || !textConstraint) continue;
            root.insertFS((FeatureStructure)annotationFS, cas, withParents);
        }
        root.sort();
        return root;
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (!this.useSelection) {
            return;
        }
        if (selection instanceof StructuredSelection && part instanceof AnnotationEditor) {
            this.offset = this.editor.getCaretOffset();
            this.reloadTree();
        }
    }

    public void handleEvent(Event event) {
        if ((event.widget == this.filterTypeTextField || event.widget == this.filterCoveredTextTextField) && event.type == 24) {
            this.reloadTree();
        }
    }

    public void reloadTree() {
        ISelection selection = this.treeView.getSelection();
        AnnotationFS selectedFS = null;
        if (selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() == 1 && ((IStructuredSelection)selection).getFirstElement() instanceof AnnotationTreeNode) {
            IStructuredSelection ssel = (IStructuredSelection)selection;
            AnnotationTreeNode firstElement = (AnnotationTreeNode)ssel.getFirstElement();
            selectedFS = firstElement.getAnnotation();
        }
        String typeText = this.filterTypeTextField.getText();
        String coveredTextText = this.filterCoveredTextTextField.getText();
        IRootTreeNode tree = this.getTypeOrderedTree(this.offset, typeText, coveredTextText);
        this.getTreeViewer().setInput((Object)tree);
        Collection shownAnnotationTypes = this.editor.getShownAnnotationTypes();
        List<TypeTreeNode> nodes = this.toNodes(shownAnnotationTypes);
        this.getTreeViewer().setCheckedElements(nodes.toArray());
        this.getTreeViewer().setGrayed((Object)new TypeTreeNode(null, this.editor.getAnnotationMode()), true);
        if (selectedFS != null) {
            Type type = selectedFS.getType();
            TreeItem[] items = this.getTreeViewer().getTree().getItems();
            for (int i = 0; i < items.length; ++i) {
                TreeItem treeItem = items[i];
                Object data = treeItem.getData();
                if (!(data instanceof TypeTreeNode) || !((TypeTreeNode)data).getType().equals(type)) continue;
                TypeTreeNode typeTreeNode = (TypeTreeNode)data;
                treeItem.setExpanded(true);
                ITreeNode[] children = typeTreeNode.getChildren();
                for (int j = 0; j < children.length; ++j) {
                    AnnotationTreeNode atn;
                    ITreeNode fsTreeNode = children[j];
                    if (!(fsTreeNode instanceof AnnotationTreeNode) || !(atn = (AnnotationTreeNode)fsTreeNode).getAnnotation().equals(selectedFS)) continue;
                    this.treeView.setSelection((ISelection)new StructuredSelection((Object)atn));
                }
            }
        }
    }

    public void checkStateChanged(CheckStateChangedEvent event) {
        Object element = event.getElement();
        boolean checked = event.getChecked();
        Type type = null;
        if (element instanceof TypeTreeNode) {
            type = ((TypeTreeNode)element).getType();
        } else if (element instanceof AnnotationTreeNode) {
            type = ((AnnotationTreeNode)element).getType();
        }
        Type modeType = this.editor.getAnnotationMode();
        if (!checked && modeType != null && modeType.equals(type)) {
            this.getTreeViewer().setGrayed((Object)new TypeTreeNode(null, type), false);
            Type annotationType = this.editor.getDocument().getCAS().getAnnotationType();
            this.editor.setAnnotationMode(annotationType);
        }
        if (type != null && !this.editor.getAnnotationMode().equals(type)) {
            this.editor.setShownAnnotationType(type, checked);
        }
    }

    public void annotationModeChanged(Type newMode) {
        this.getTreeViewer().setGrayed((Object)new TypeTreeNode(null, newMode), true);
    }

    public void showAnnotationsChanged(Collection<Type> shownAnnotationTypes) {
        List<TypeTreeNode> nodes = this.toNodes(shownAnnotationTypes);
        this.getTreeViewer().setCheckedElements(nodes.toArray());
    }

    private List<TypeTreeNode> toNodes(Collection<Type> shownAnnotationTypes) {
        ArrayList<TypeTreeNode> nodes = new ArrayList<TypeTreeNode>();
        for (Type type : shownAnnotationTypes) {
            nodes.add(new TypeTreeNode(null, type));
        }
        return nodes;
    }

    private boolean isTreeWithTypesWithoutAnnotations() {
        IPreferenceStore preferenceStore = RutaCasEditorPlugin.getDefault().getPreferenceStore();
        return !this.useSelection && preferenceStore.getBoolean("showTypesWithoutAnnotations");
    }

    private class ShowTypesWithoutAnnotations
    extends Action {
        public ShowTypesWithoutAnnotations() {
            super("Show Types Without Annotations", 2);
            this.setChecked(AnnotationTreeViewPage.this.isTreeWithTypesWithoutAnnotations());
        }

        public void run() {
            IPreferenceStore preferenceStore = RutaCasEditorPlugin.getDefault().getPreferenceStore();
            preferenceStore.setValue("showTypesWithoutAnnotations", this.isChecked());
            AnnotationTreeViewPage.this.reloadTree();
        }
    }

    private class UncheckAllAction
    extends Action {
        private UncheckAllAction() {
        }

        public void run() {
            AnnotationTreeViewPage.this.uncheckAll();
        }
    }

    private class CheckAllVisibleAction
    extends Action {
        private CheckAllVisibleAction() {
        }

        public void run() {
            AnnotationTreeViewPage.this.uncheckAll();
            AnnotationTreeViewPage.this.checkAllVisible();
        }
    }

    public class TreeViewAnnotationStyleChangeListener
    extends AnnotationStyleChangeListener {
        public void annotationStylesChanged(Collection<AnnotationStyle> styles) {
            for (AnnotationStyle annotationStyle : styles) {
                String annotation = annotationStyle.getAnnotation();
                AnnotationTreeViewPage.this.updateIcon(annotation);
            }
            if (!AnnotationTreeViewPage.this.treeView.isBusy() && !AnnotationTreeViewPage.this.treeView.getTree().isDisposed()) {
                AnnotationTreeViewPage.this.treeView.refresh();
            }
        }
    }

    public static enum ModifyAnnotationOperation {
        WIDE_L,
        LOWER_L,
        WIDE_R,
        LOWER_R;

    }
}

