/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.schedule;

import java.util.List;
import java.util.Vector;
import java.util.concurrent.ConcurrentSkipListSet;
import org.apache.turbine.services.schedule.JobEntry;
import org.apache.turbine.util.TurbineException;

public class JobQueue<J extends JobEntry> {
    private ConcurrentSkipListSet<J> queue = new ConcurrentSkipListSet((o1, o2) -> Long.compare(o1.getNextRuntime(), o2.getNextRuntime()));

    public J getNext() {
        return (J)((JobEntry)this.queue.pollFirst());
    }

    public J getFirst() {
        return (J)(!this.queue.isEmpty() ? (JobEntry)this.queue.first() : null);
    }

    public J getJob(J je) {
        if (je != null) {
            JobEntry job = (JobEntry)this.queue.floor(je);
            if (je.equals(job)) {
                return (J)job;
            }
            for (JobEntry jobEntry : this.list()) {
                if (jobEntry.getJobId() != je.getJobId()) continue;
                return (J)jobEntry;
            }
        }
        return null;
    }

    public Vector<J> list() {
        if (!this.queue.isEmpty()) {
            return new Vector<J>(this.queue);
        }
        return null;
    }

    public void add(J je) {
        this.queue.add(je);
    }

    public void batchLoad(List<J> jobEntries) {
        if (jobEntries != null) {
            this.queue.addAll(jobEntries);
        }
    }

    public void remove(J je) {
        this.queue.remove(je);
    }

    public void modify(J je) throws TurbineException {
        this.remove(je);
        je.calcRunTime();
        this.add(je);
    }

    public void updateQueue(J je) throws TurbineException {
        this.modify(je);
    }
}

