/*
 * Decompiled with CFR 0.152.
 */
package org.jabsorb.client;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.entity.UrlEncodedFormEntity;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.message.BasicNameValuePair;
import org.jabsorb.client.ClientError;
import org.jabsorb.client.Session;
import org.jabsorb.client.TransportRegistry;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTPSession
implements Session {
    private static final Logger log = LoggerFactory.getLogger(HTTPSession.class);
    protected HttpClient client;
    protected URI uri;
    static final String JSON_CONTENT_TYPE = "application/json";

    public HTTPSession(URI uri) {
        this.uri = uri;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public JSONObject sendAndReceive(JSONObject message) {
        try {
            if (log.isDebugEnabled()) {
                log.debug("Sending: " + message.toString(2));
            }
            HttpPost postMethod = new HttpPost(this.uri);
            postMethod.setHeader("Content-Type", (Object)"text/plain");
            ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
            params.add(new BasicNameValuePair(message.toString(), JSON_CONTENT_TYPE));
            postMethod.setEntity((HttpEntity)new UrlEncodedFormEntity(params));
            try (CloseableHttpClient cHttpCLient = HttpClients.createDefault();){
                JSONObject jSONObject;
                block19: {
                    CloseableHttpResponse response = cHttpCLient.execute((ClassicHttpRequest)postMethod);
                    try {
                        int statusCode = response.getCode();
                        if (statusCode != 200) {
                            throw new ClientError("HTTP Status - " + response.getReasonPhrase() + " (" + statusCode + ")");
                        }
                        String responseString = EntityUtils.toString((HttpEntity)response.getEntity());
                        JSONTokener tokener = new JSONTokener(responseString);
                        Object rawResponseMessage = tokener.nextValue();
                        JSONObject responseMessage = (JSONObject)rawResponseMessage;
                        if (responseMessage == null) {
                            throw new ClientError("Invalid response type - " + String.valueOf(rawResponseMessage.getClass()));
                        }
                        jSONObject = responseMessage;
                        if (response == null) break block19;
                    }
                    catch (Throwable throwable) {
                        if (response != null) {
                            try {
                                response.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    response.close();
                }
                return jSONObject;
            }
        }
        catch (HttpException e) {
            throw new ClientError(e);
        }
        catch (IOException e) {
            throw new ClientError(e);
        }
        catch (JSONException e) {
            throw new ClientError(e);
        }
    }

    HttpClient http() {
        if (this.client == null) {
            this.client = HttpClients.createDefault();
        }
        return this.client;
    }

    @Override
    public void close() {
    }

    public static void register(TransportRegistry registry) {
        registry.registerTransport("http", new Factory());
    }

    static class Factory
    implements TransportRegistry.SessionFactory {
        Factory() {
        }

        @Override
        public Session newSession(URI uri) {
            return new HTTPSession(uri);
        }
    }
}

