/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.parser;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.Part;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.fulcrum.parser.BaseValueParser;
import org.apache.fulcrum.parser.ParameterParser;

public class DefaultParameterParser
extends BaseValueParser
implements ParameterParser {
    private HttpServletRequest request = null;
    private byte[] uploadData = null;

    public DefaultParameterParser() {
    }

    public DefaultParameterParser(String characterEncoding) {
        super(characterEncoding);
    }

    @Override
    public void dispose() {
        this.request = null;
        this.uploadData = null;
        super.dispose();
    }

    @Override
    public HttpServletRequest getRequest() {
        return this.request;
    }

    @Override
    public void setRequest(HttpServletRequest request) {
        this.clear();
        this.uploadData = null;
        this.handleEncoding(request);
        String contentType = request.getHeader("Content-type");
        if (this.parserService.getAutomaticUpload() && contentType != null && contentType.startsWith("multipart/form-data")) {
            try {
                List<Part> parts = this.parserService.parseUpload(request);
                if (parts != null) {
                    for (Part p : parts) {
                        this.getLogger().debug("Found an uploaded file: " + p.getName());
                        this.getLogger().debug("It has " + p.getSize() + " Bytes");
                        this.getLogger().debug("Adding Part as " + p.getName() + " to the params");
                        this.add(p.getName(), p);
                    }
                }
            }
            catch (ServiceException e) {
                this.getLogger().error("File upload failed", (Throwable)e);
            }
        }
        Enumeration names = request.getParameterNames();
        while (names.hasMoreElements()) {
            String paramName = (String)names.nextElement();
            this.add(paramName, request.getParameterValues(paramName));
        }
        this.handlePathInfo(request);
        this.request = request;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Parameters found in the Request:");
            for (String key : this.keySet()) {
                this.getLogger().debug("Key: " + key + " -> " + this.getString(key));
            }
        }
    }

    private void handlePathInfo(HttpServletRequest request) {
        try {
            boolean isNameTok = true;
            String paramName = null;
            String paramValue = null;
            StringTokenizer st = new StringTokenizer(request.getPathInfo(), "/");
            while (st.hasMoreTokens()) {
                if (isNameTok) {
                    paramName = URLDecoder.decode(st.nextToken(), this.getCharacterEncoding());
                    isNameTok = false;
                    continue;
                }
                paramValue = URLDecoder.decode(st.nextToken(), this.getCharacterEncoding());
                if (paramName != null && paramName.length() > 0) {
                    this.add(paramName, paramValue);
                }
                isNameTok = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void handleEncoding(HttpServletRequest request) {
        String enc = request.getCharacterEncoding();
        if (enc == null && !this.parserService.getParameterEncoding().equals("ISO-8859-1")) {
            try {
                request.setCharacterEncoding(this.parserService.getParameterEncoding());
                enc = request.getCharacterEncoding();
                if (enc != null) {
                    this.getLogger().debug("Set the request encoding successfully to parameterEncoding of parser: " + enc);
                } else {
                    this.getLogger().warn("Unsuccessfully (data read happened) tried to set the request encoding to " + this.parserService.getParameterEncoding());
                }
            }
            catch (UnsupportedEncodingException e) {
                this.getLogger().error("Found only unsupported encoding " + e.getMessage());
            }
        }
        this.setCharacterEncoding(enc != null ? enc : this.parserService.getParameterEncoding());
    }

    @Override
    public void setUploadData(byte[] uploadData) {
        this.uploadData = Arrays.copyOf(uploadData, uploadData.length);
    }

    @Override
    public byte[] getUploadData() {
        return this.uploadData;
    }

    @Override
    public void add(String name, Part value) {
        Object[] items = this.getParts(name);
        items = (Part[])ArrayUtils.add((Object[])items, (Object)value);
        this.parameters.put(this.convert(name), items);
    }

    @Override
    public Part getPart(String name) {
        try {
            Part value = null;
            Object object = this.parameters.get(this.convert(name));
            if (object != null) {
                value = ((Part[])object)[0];
            }
            return value;
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    @Override
    public Part[] getParts(String name) {
        try {
            return (Part[])this.parameters.get(this.convert(name));
        }
        catch (ClassCastException e) {
            return new Part[0];
        }
    }

    @Override
    public Collection<Part> getParts() {
        return this.parameters.values().stream().filter(p -> p instanceof Part[]).flatMap(c -> Arrays.stream((Part[])c)).collect(Collectors.toList());
    }

    @Override
    public String getFileName(Part part) {
        String partHeader = part.getHeader("content-disposition");
        Pattern regex = Pattern.compile("filename\\*?=\"?(.[^\"]+)\"?");
        for (String content : partHeader.split(";")) {
            if (!content.trim().contains("filename")) continue;
            String fnTmp = "";
            String srcStr = content.trim();
            Matcher regexMatcher = regex.matcher(srcStr);
            if (regexMatcher.find()) {
                fnTmp = regexMatcher.group(1);
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("matched fileName:" + fnTmp);
                }
            } else {
                fnTmp = srcStr.substring(srcStr.indexOf(61) + 1).replace("\"", "");
                this.getLogger().debug("second fileName match:" + fnTmp);
            }
            return fnTmp.trim();
        }
        return null;
    }
}

