/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.jce.crypto.extended;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.fulcrum.jce.crypto.CryptoStreamFactory;
import org.apache.fulcrum.jce.crypto.CryptoUtil;
import org.apache.fulcrum.jce.crypto.StreamUtil;
import org.apache.fulcrum.jce.crypto.extended.CryptoParametersJ8;
import org.apache.fulcrum.jce.crypto.extended.CryptoStreamFactoryJ8;
import org.apache.fulcrum.jce.crypto.extended.CryptoStreamFactoryJ8Template;

public final class CryptoUtilJ8
extends CryptoUtil {
    private static final Map<CryptoParametersJ8.TYPES, CryptoUtilJ8> instances = new ConcurrentHashMap<CryptoParametersJ8.TYPES, CryptoUtilJ8>();
    private static final Map<CryptoParametersJ8.TYPES, CryptoUtilJ8> instancesWithExplicitParams = new ConcurrentHashMap<CryptoParametersJ8.TYPES, CryptoUtilJ8>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CryptoUtilJ8 getInstance() {
        Class<CryptoUtilJ8> clazz = CryptoUtilJ8.class;
        synchronized (CryptoUtilJ8.class) {
            CryptoParametersJ8.TYPES defaultType = CryptoParametersJ8.DEFAULT_TYPE;
            if (instances.isEmpty() || !instances.containsKey((Object)defaultType)) {
                instances.put(defaultType, new CryptoUtilJ8());
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instances.get((Object)defaultType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CryptoUtilJ8 getInstance(CryptoParametersJ8.TYPES type) {
        Class<CryptoUtilJ8> clazz = CryptoUtilJ8.class;
        synchronized (CryptoUtilJ8.class) {
            if (!instances.containsKey((Object)type)) {
                instances.put(type, new CryptoUtilJ8(type));
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instances.get((Object)type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CryptoUtilJ8 getInstance(CryptoParametersJ8.TYPES type, byte[] salt, int count) {
        Class<CryptoUtilJ8> clazz = CryptoUtilJ8.class;
        synchronized (CryptoUtilJ8.class) {
            if (!instancesWithExplicitParams.containsKey((Object)type)) {
                instancesWithExplicitParams.put(type, new CryptoUtilJ8(type, salt, count));
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return instancesWithExplicitParams.get((Object)type);
        }
    }

    private CryptoUtilJ8() {
        this.cryptoStreamFactory = CryptoStreamFactoryJ8Template.getInstance();
    }

    private CryptoUtilJ8(CryptoParametersJ8.TYPES type) {
        this.cryptoStreamFactory = CryptoStreamFactoryJ8Template.getInstance(type);
    }

    protected CryptoUtilJ8(CryptoParametersJ8.TYPES type, byte[] salt, int count) {
        this.cryptoStreamFactory = CryptoStreamFactoryJ8Template.getInstance(type, salt, count);
    }

    @Override
    public void encrypt(CryptoStreamFactory factory, Object source, Object target, char[] password) throws GeneralSecurityException, IOException {
        InputStream is = StreamUtil.createInputStream(source);
        OutputStream os = StreamUtil.createOutputStream(target);
        ((CryptoStreamFactoryJ8)factory).getOutputStream(is, os, password);
    }

    @Override
    protected void decrypt(CryptoStreamFactory factory, Object source, Object target, char[] password) throws GeneralSecurityException, IOException {
        InputStream is = StreamUtil.createInputStream(source);
        OutputStream os = StreamUtil.createOutputStream(target);
        InputStream dis = factory.getInputStream(is, password);
        StreamUtil.copy(dis, os);
    }

    public static Map<CryptoParametersJ8.TYPES, CryptoUtilJ8> getInstances() {
        return instances;
    }

    public static Map<CryptoParametersJ8.TYPES, CryptoUtilJ8> getInstancesWithExplicitParams() {
        return instancesWithExplicitParams;
    }
}

