/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.system;

import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.apache.sis.system.SystemListener;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Messages;

public abstract class OptionalDependency
extends SystemListener {
    private final String dependency;

    protected OptionalDependency(String module, String dependency) {
        super(module);
        this.dependency = dependency;
        SystemListener.add(this);
    }

    protected static <T extends OptionalDependency> T getInstance(Class<T> type, ServiceLoader<T> loader, String dependency) {
        OptionalDependency first = loader.findFirst().orElse(null);
        if (first == null) {
            LogRecord record = Messages.getResources(null).getLogRecord(Level.CONFIG, (short)27, dependency);
            record.setLoggerName(type.getModule().getName());
            Logging.completeAndLog(null, type, "getInstance", record);
        }
        return (T)first;
    }

    protected final UnsupportedOperationException moduleNotFound() {
        return new UnsupportedOperationException(Errors.format((short)87, this.dependency));
    }
}

