/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.matrix;

import java.util.Arrays;
import org.apache.sis.referencing.internal.Arithmetic;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.matrix.MismatchedMatrixSizeException;
import org.apache.sis.referencing.operation.matrix.NonSquareMatrix;
import org.apache.sis.referencing.util.ExtendedPrecisionMatrix;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.opengis.referencing.operation.Matrix;

class GeneralMatrix
extends MatrixSIS
implements ExtendedPrecisionMatrix {
    private static final long serialVersionUID = 1794420009565835530L;
    private static final double ZERO_THRESHOLD = 1.0E-14;
    final Number[] elements;
    short numRow;
    short numCol;

    GeneralMatrix(int numRow, int numCol, boolean setToIdentity) {
        ArgumentChecks.ensureBetween("numRow", 1, Short.MAX_VALUE, numRow);
        ArgumentChecks.ensureBetween("numCol", 1, Short.MAX_VALUE, numCol);
        this.numRow = (short)numRow;
        this.numCol = (short)numCol;
        this.elements = new Number[numRow * numCol];
        if (setToIdentity) {
            int stop = Math.min(numRow, numCol) * numCol;
            for (int i = 0; i < stop; i += numCol + 1) {
                this.elements[i] = 1;
            }
        }
    }

    GeneralMatrix(int numRow, int numCol, Number[] elements) {
        this(numRow, numCol, false);
        assert (elements.length == this.elements.length);
        int k = 0;
        for (int j = 0; j < numRow; ++j) {
            for (int i = 0; i < numCol; ++i) {
                Number element;
                if (ExtendedPrecisionMatrix.isZero(element = elements[k++])) continue;
                this.elements[j * numCol + i] = element;
            }
        }
    }

    GeneralMatrix(GeneralMatrix matrix) {
        this.numRow = matrix.numRow;
        this.numCol = matrix.numCol;
        this.elements = (Number[])matrix.elements.clone();
        assert (this.isValid());
    }

    private boolean isValid() {
        short numRow = this.numRow;
        short numCol = this.numCol;
        int length = this.elements.length;
        int i = numRow * numCol;
        if ((numRow | numCol) < 0 || length != i || numRow != numCol != this instanceof NonSquareMatrix) {
            return false;
        }
        boolean isValid = true;
        while (--i >= 0) {
            Number element = this.elements[i];
            isValid &= element == null || !ExtendedPrecisionMatrix.isZero(element);
        }
        return isValid;
    }

    static GeneralMatrix create(int numRow, int numCol, boolean setToIdentity) {
        if (numRow == numCol) {
            return new GeneralMatrix(numRow, numCol, setToIdentity);
        }
        return new NonSquareMatrix(numRow, numCol, setToIdentity);
    }

    @Override
    public final int getNumRow() {
        return this.numRow;
    }

    @Override
    public final int getNumCol() {
        return this.numCol;
    }

    @Override
    public final Number[] getElementAsNumbers(boolean writable) {
        return writable ? (Number[])this.elements.clone() : this.elements;
    }

    @Override
    public final Number getElementOrNull(int row, int column) {
        if (row >= 0 && row < this.numRow && column >= 0 && column < this.numCol) {
            return this.elements[row * this.numCol + column];
        }
        throw GeneralMatrix.indexOutOfBounds(row, column);
    }

    @Override
    public final Number getNumber(int row, int column) {
        Number value = this.getElementOrNull(row, column);
        return value != null ? (Number)value : (Number)0;
    }

    @Override
    public final void setNumber(int row, int column, Number value) {
        if (row >= 0 && row < this.numRow && column >= 0 && column < this.numCol) {
            if (ExtendedPrecisionMatrix.isZero(value)) {
                value = null;
            }
        } else {
            throw GeneralMatrix.indexOutOfBounds(row, column);
        }
        this.elements[row * this.numCol + column] = value;
    }

    @Override
    public final double getElement(int row, int column) {
        Number value = this.getElementOrNull(row, column);
        return value != null ? value.doubleValue() : 0.0;
    }

    @Override
    public final void setElement(int row, int column, double value) {
        this.setNumber(row, column, value);
    }

    @Override
    public final void setMatrix(Matrix matrix) throws MismatchedMatrixSizeException {
        if (matrix instanceof GeneralMatrix) {
            GeneralMatrix gm = (GeneralMatrix)matrix;
            GeneralMatrix.ensureSizeMatch(this.numRow, this.numCol, matrix);
            System.arraycopy(gm.elements, 0, this.elements, 0, this.elements.length);
        } else {
            super.setMatrix(matrix);
        }
        assert (this.isValid());
    }

    @Override
    public final boolean isAffine() {
        return this.isAffine(true);
    }

    final boolean isAffine(boolean square) {
        short numRow = this.numRow;
        short numCol = this.numCol;
        if (numRow == numCol || !square) {
            int i = numRow * numCol;
            if (Arithmetic.isOne(this.elements[--i])) {
                int base = (numRow - 1) * numCol;
                while (--i >= base) {
                    if (this.elements[i] == null) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public final boolean isIdentity() {
        short numRow = this.numRow;
        short numCol = this.numCol;
        if (numRow != numCol) {
            return false;
        }
        int di = 0;
        int length = numRow * numCol;
        for (int i = 0; i < length; ++i) {
            Number element = this.elements[i];
            if (i == di) {
                if (!Arithmetic.isOne(element)) {
                    return false;
                }
                di += numCol + 1;
                continue;
            }
            if (element == null) continue;
            return false;
        }
        return true;
    }

    @Override
    public void transpose() {
        int numRow = this.numRow;
        short numCol = this.numCol;
        for (int j = 0; j < numRow; ++j) {
            for (int i = 0; i < j; ++i) {
                int lo = j * numCol + i;
                int up = i * numCol + j;
                ArraysExt.swap(this.elements, lo, up);
            }
        }
    }

    final void setToProduct(Matrix A2, Matrix B) {
        int numRow = this.numRow;
        int numCol = this.numCol;
        int nc = A2.getNumCol();
        assert (B.getNumRow() == nc);
        assert (numRow == A2.getNumRow() && numCol == B.getNumCol());
        ExtendedPrecisionMatrix eA = GeneralMatrix.asExtendedPrecision(A2);
        ExtendedPrecisionMatrix eB = GeneralMatrix.asExtendedPrecision(B);
        int k = 0;
        for (int j = 0; j < numRow; ++j) {
            for (int i = 0; i < numCol; ++i) {
                Number sum = null;
                double max = 0.0;
                for (int m = 0; m < nc; ++m) {
                    Number mB;
                    Number dot;
                    Number mA = eA.getElementOrNull(j, m);
                    if (mA == null || (dot = Arithmetic.multiply(mA, mB = eB.getElementOrNull(m, i))) == null) continue;
                    sum = Arithmetic.add(sum, dot);
                    double value = Math.abs(dot.doubleValue());
                    if (!(value > max)) continue;
                    max = value;
                }
                if (sum != null && Math.abs(sum.doubleValue()) < Math.ulp(max) * 1.0E-14) {
                    sum = null;
                }
                this.elements[k++] = sum;
            }
        }
        assert (k == this.elements.length);
        assert (this.isValid());
    }

    @Override
    public final boolean equals(Object object) {
        if (object instanceof GeneralMatrix) {
            GeneralMatrix that = (GeneralMatrix)object;
            return this.numRow == that.numRow && this.numCol == that.numCol && Arrays.equals(this.elements, that.elements);
        }
        return false;
    }

    @Override
    public final int hashCode() {
        return (this.numRow << 16 | this.numCol) ^ Arrays.hashCode(this.elements) ^ 0xD006510A;
    }

    @Override
    public MatrixSIS clone() {
        return new GeneralMatrix(this);
    }
}

