/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.geometry.wrapper.jts;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.OptionalInt;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.IntFunction;
import org.apache.sis.filter.sqlmm.SQLMM;
import org.apache.sis.geometry.DirectPosition2D;
import org.apache.sis.geometry.GeneralDirectPosition;
import org.apache.sis.geometry.GeneralEnvelope;
import org.apache.sis.geometry.wrapper.Geometries;
import org.apache.sis.geometry.wrapper.GeometryType;
import org.apache.sis.geometry.wrapper.GeometryWrapper;
import org.apache.sis.geometry.wrapper.jts.Factory;
import org.apache.sis.geometry.wrapper.jts.FilteringContext;
import org.apache.sis.geometry.wrapper.jts.JTS;
import org.apache.sis.pending.geoapi.filter.DistanceOperatorName;
import org.apache.sis.pending.geoapi.filter.SpatialOperatorName;
import org.apache.sis.referencing.util.ReferencingUtilities;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.UnconvertibleObjectException;
import org.apache.sis.util.collection.BackingStoreException;
import org.apache.sis.util.resources.Errors;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.io.WKTWriter;
import org.locationtech.jts.simplify.DouglasPeuckerSimplifier;
import org.locationtech.jts.simplify.TopologyPreservingSimplifier;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

final class Wrapper
extends GeometryWrapper {
    private final Geometry geometry;
    private static final BiPredicate<Geometry, Geometry>[] PREDICATES = new BiPredicate[SpatialOperatorName.OVERLAPS.ordinal() + 1];
    private static final Class<?>[] TYPES;
    private static final String[] SQLMM_NAMES;

    Wrapper(Geometry geometry) {
        this.geometry = geometry;
    }

    private Wrapper rewrap(Geometry result) {
        return result != this.geometry ? new Wrapper(result) : this;
    }

    protected Geometries<Geometry> factory() {
        return Factory.INSTANCE;
    }

    @Override
    protected Object implementation() {
        return this.geometry;
    }

    @Override
    public OptionalInt getSRID() {
        int srid = this.geometry.getSRID();
        return srid != 0 ? OptionalInt.of(srid) : OptionalInt.empty();
    }

    @Override
    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        try {
            return JTS.getCoordinateReferenceSystem(this.geometry);
        }
        catch (FactoryException e) {
            throw new BackingStoreException(e);
        }
    }

    @Override
    public void setCoordinateReferenceSystem(CoordinateReferenceSystem crs) {
        ArgumentChecks.ensureDimensionMatches("crs", Wrapper.getCoordinatesDimension(this.geometry), crs);
        JTS.setCoordinateReferenceSystem(this.geometry, crs);
    }

    private static int getCoordinatesDimension(Geometry geometry) {
        CoordinateSequence cs;
        if (geometry instanceof Point) {
            cs = ((Point)geometry).getCoordinateSequence();
        } else if (geometry instanceof LineString) {
            cs = ((LineString)geometry).getCoordinateSequence();
        } else {
            if (geometry instanceof Polygon) {
                return Wrapper.getCoordinatesDimension((Geometry)((Polygon)geometry).getExteriorRing());
            }
            if (geometry instanceof GeometryCollection) {
                GeometryCollection gc = (GeometryCollection)geometry;
                int n = gc.getNumGeometries();
                if (n == 0) {
                    return 3;
                }
                for (int i = 0; i < n; ++i) {
                    int d = Wrapper.getCoordinatesDimension(gc.getGeometryN(i));
                    if (d <= 2) continue;
                    return d;
                }
                return 2;
            }
            throw new IllegalArgumentException(Errors.format((short)149, geometry.getGeometryType()));
        }
        return cs.getDimension();
    }

    @Override
    public GeneralEnvelope getEnvelope() {
        GeneralEnvelope env;
        Envelope bounds = this.geometry.getEnvelopeInternal();
        CoordinateReferenceSystem crs = this.getCoordinateReferenceSystem();
        if (crs != null) {
            env = new GeneralEnvelope(crs);
            env.setToNaN();
        } else {
            env = new GeneralEnvelope(2);
        }
        env.setRange(0, bounds.getMinX(), bounds.getMaxX());
        env.setRange(1, bounds.getMinY(), bounds.getMaxY());
        return env;
    }

    @Override
    public DirectPosition getCentroid() {
        Coordinate c = this.geometry.getCentroid().getCoordinate();
        CoordinateReferenceSystem crs = this.getCoordinateReferenceSystem();
        if (crs == null) {
            double z = c.getZ();
            if (!Double.isNaN(z)) {
                return new GeneralDirectPosition(c.x, c.y, z);
            }
        } else if (ReferencingUtilities.getDimension(crs) != 2) {
            GeneralDirectPosition point = new GeneralDirectPosition(crs);
            point.setOrdinate(0, c.x);
            point.setOrdinate(1, c.y);
            point.setOrdinate(2, c.getZ());
            return point;
        }
        return new DirectPosition2D(crs, c.x, c.y);
    }

    @Override
    public double[] getPointCoordinates() {
        double[] coord;
        if (!(this.geometry instanceof Point)) {
            return null;
        }
        Coordinate pt = ((Point)this.geometry).getCoordinate();
        double z = pt.getZ();
        if (Double.isNaN(z)) {
            coord = new double[2];
        } else {
            coord = new double[3];
            coord[2] = z;
        }
        coord[1] = pt.y;
        coord[0] = pt.x;
        return coord;
    }

    @Override
    public double[] getAllCoordinates() {
        Coordinate[] points = this.geometry.getCoordinates();
        double[] coordinates = new double[points.length * 2];
        int i = 0;
        for (Coordinate p : points) {
            coordinates[i++] = p.x;
            coordinates[i++] = p.y;
        }
        return coordinates;
    }

    public Geometry mergePolylines(Iterator<?> polylines) {
        ArrayList<Coordinate> coordinates = new ArrayList<Coordinate>();
        ArrayList<Geometry> lines = new ArrayList<Geometry>();
        boolean isFloat = true;
        Geometry next = this.geometry;
        block0: while (true) {
            if (next instanceof Point) {
                Coordinate pt = ((Point)next).getCoordinate();
                if (!Double.isNaN(pt.x) && !Double.isNaN(pt.y)) {
                    isFloat = Factory.isFloat(isFloat, (Point)next);
                    coordinates.add(pt);
                } else {
                    Factory.INSTANCE.toLineString(coordinates, lines, false, isFloat);
                    coordinates.clear();
                    isFloat = true;
                }
            } else {
                int n = next.getNumGeometries();
                for (int i = 0; i < n; ++i) {
                    LineString ls = (LineString)next.getGeometryN(i);
                    if (coordinates.isEmpty()) {
                        lines.add((Geometry)ls);
                        continue;
                    }
                    if (isFloat) {
                        isFloat = Factory.isFloat(ls.getCoordinateSequence());
                    }
                    coordinates.addAll(Arrays.asList(ls.getCoordinates()));
                    Factory.INSTANCE.toLineString(coordinates, lines, false, isFloat);
                    coordinates.clear();
                    isFloat = true;
                }
            }
            while (polylines.hasNext()) {
                next = (Geometry)polylines.next();
                if (next == null) continue;
                continue block0;
            }
            break;
        }
        Factory.INSTANCE.toLineString(coordinates, lines, false, isFloat);
        return Factory.INSTANCE.toGeometry(lines, false, isFloat);
    }

    @Override
    protected boolean predicateSameCRS(SpatialOperatorName type, GeometryWrapper other) {
        BiPredicate<Geometry, Geometry> op;
        int ordinal = type.ordinal();
        if (ordinal >= 0 && ordinal < PREDICATES.length && (op = PREDICATES[ordinal]) != null) {
            return op.test(this.geometry, ((Wrapper)other).geometry);
        }
        return super.predicateSameCRS(type, other);
    }

    @Override
    protected boolean predicateSameCRS(DistanceOperatorName type, GeometryWrapper other, double distance) {
        boolean reverse;
        boolean bl = reverse = type != DistanceOperatorName.WITHIN;
        if (reverse && type != DistanceOperatorName.BEYOND) {
            return super.predicateSameCRS(type, other, distance);
        }
        return this.geometry.isWithinDistance(((Wrapper)other).geometry, distance) ^ reverse;
    }

    @Override
    protected Object operationSameCRS(SQLMM operation, GeometryWrapper other, Object argument) {
        Geometry result;
        switch (operation) {
            case ST_IsMeasured: {
                return Boolean.FALSE;
            }
            case ST_Dimension: {
                return this.geometry.getDimension();
            }
            case ST_SRID: {
                return this.geometry.getSRID();
            }
            case ST_IsEmpty: {
                return this.geometry.isEmpty();
            }
            case ST_IsSimple: {
                return this.geometry.isSimple();
            }
            case ST_IsValid: {
                return this.geometry.isValid();
            }
            case ST_Envelope: {
                return this.getEnvelope();
            }
            case ST_Boundary: {
                result = this.geometry.getBoundary();
                break;
            }
            case ST_ConvexHull: {
                result = this.geometry.convexHull();
                break;
            }
            case ST_Buffer: {
                result = this.geometry.buffer(((Number)argument).doubleValue());
                break;
            }
            case ST_Intersection: {
                result = this.geometry.intersection(((Wrapper)other).geometry);
                break;
            }
            case ST_Union: {
                result = this.geometry.union(((Wrapper)other).geometry);
                break;
            }
            case ST_Difference: {
                result = this.geometry.difference(((Wrapper)other).geometry);
                break;
            }
            case ST_SymDifference: {
                result = this.geometry.symDifference(((Wrapper)other).geometry);
                break;
            }
            case ST_Distance: {
                return this.geometry.distance(((Wrapper)other).geometry);
            }
            case ST_Equals: {
                return this.geometry.equalsTopo(((Wrapper)other).geometry);
            }
            case ST_Relate: {
                return this.geometry.relate(((Wrapper)other).geometry, argument.toString());
            }
            case ST_Disjoint: {
                return this.geometry.disjoint(((Wrapper)other).geometry);
            }
            case ST_Intersects: {
                return this.geometry.intersects(((Wrapper)other).geometry);
            }
            case ST_Touches: {
                return this.geometry.touches(((Wrapper)other).geometry);
            }
            case ST_Crosses: {
                return this.geometry.crosses(((Wrapper)other).geometry);
            }
            case ST_Within: {
                return this.geometry.within(((Wrapper)other).geometry);
            }
            case ST_Contains: {
                return this.geometry.contains(((Wrapper)other).geometry);
            }
            case ST_Overlaps: {
                return this.geometry.overlaps(((Wrapper)other).geometry);
            }
            case ST_AsText: {
                return new WKTWriter().write(this.geometry);
            }
            case ST_AsBinary: {
                return FilteringContext.writeWKB(this.geometry);
            }
            case ST_X: {
                return ((Point)this.geometry).getX();
            }
            case ST_Y: {
                return ((Point)this.geometry).getY();
            }
            case ST_Z: {
                return ((Point)this.geometry).getCoordinate().getZ();
            }
            case ST_ToLineString: {
                return this.geometry;
            }
            case ST_NumGeometries: {
                return this.geometry.getNumGeometries();
            }
            case ST_NumPoints: {
                return this.geometry.getNumPoints();
            }
            case ST_PointN: {
                result = ((LineString)this.geometry).getPointN(Wrapper.toIndex(argument));
                break;
            }
            case ST_StartPoint: {
                result = ((LineString)this.geometry).getStartPoint();
                break;
            }
            case ST_EndPoint: {
                result = ((LineString)this.geometry).getEndPoint();
                break;
            }
            case ST_IsClosed: {
                return ((LineString)this.geometry).isClosed();
            }
            case ST_IsRing: {
                return ((LineString)this.geometry).isRing();
            }
            case ST_Perimeter: 
            case ST_Length: {
                return this.geometry.getLength();
            }
            case ST_Area: {
                return this.geometry.getArea();
            }
            case ST_Centroid: {
                result = this.geometry.getCentroid();
                break;
            }
            case ST_PointOnSurface: {
                result = this.geometry.getInteriorPoint();
                break;
            }
            case ST_ExteriorRing: {
                result = ((Polygon)this.geometry).getExteriorRing();
                break;
            }
            case ST_InteriorRingN: {
                result = ((Polygon)this.geometry).getInteriorRingN(Wrapper.toIndex(argument));
                break;
            }
            case ST_NumInteriorRings: {
                return ((Polygon)this.geometry).getNumInteriorRing();
            }
            case ST_GeometryN: {
                result = this.geometry.getGeometryN(Wrapper.toIndex(argument));
                break;
            }
            case ST_ToPoint: 
            case ST_ToPolygon: 
            case ST_ToMultiPoint: 
            case ST_ToMultiLine: 
            case ST_ToMultiPolygon: 
            case ST_ToGeomColl: {
                GeometryType target = operation.getGeometryType().get();
                Class<?> type = Wrapper.getGeometryClass(target);
                if (type.isInstance(this.geometry)) {
                    return this.geometry;
                }
                result = this.convert(target);
                break;
            }
            case ST_Is3D: {
                Coordinate c = this.geometry.getCoordinate();
                return c != null ? Boolean.valueOf(!Double.isNaN(c.z)) : null;
            }
            case ST_CoordDim: {
                Coordinate c = this.geometry.getCoordinate();
                return c != null ? Integer.valueOf(Double.isNaN(c.z) ? 2 : 3) : null;
            }
            case ST_GeometryType: {
                for (int i = 0; i < TYPES.length; ++i) {
                    if (!TYPES[i].isInstance(this.geometry)) continue;
                    return SQLMM_NAMES[i];
                }
                return null;
            }
            case ST_ExplicitPoint: {
                double[] dArray;
                Coordinate c = ((Point)this.geometry).getCoordinate();
                if (c == null) {
                    return ArraysExt.EMPTY_DOUBLE;
                }
                double x = c.getX();
                double y = c.getY();
                double z = c.getZ();
                if (Double.isNaN(z)) {
                    double[] dArray2 = new double[2];
                    dArray2[0] = x;
                    dArray = dArray2;
                    dArray2[1] = y;
                } else {
                    double[] dArray3 = new double[3];
                    dArray3[0] = x;
                    dArray3[1] = y;
                    dArray = dArray3;
                    dArray3[2] = z;
                }
                return dArray;
            }
            case ST_Simplify: {
                double distance = ((Number)argument).doubleValue();
                result = DouglasPeuckerSimplifier.simplify((Geometry)this.geometry, (double)distance);
                break;
            }
            case ST_SimplifyPreserveTopology: {
                double distance = ((Number)argument).doubleValue();
                result = TopologyPreservingSimplifier.simplify((Geometry)this.geometry, (double)distance);
                break;
            }
            default: {
                return super.operationSameCRS(operation, other, argument);
            }
        }
        JTS.copyMetadata(this.geometry, result);
        return result;
    }

    private static int toIndex(Object argument) {
        int i = argument instanceof CharSequence ? Integer.parseInt(argument.toString()) : ((Number)argument).intValue();
        ArgumentChecks.ensureStrictlyPositive("index", i);
        return i - 1;
    }

    @Override
    public GeometryWrapper toGeometryType(GeometryType target) {
        Geometry result;
        if (!Wrapper.getGeometryClass(target).isInstance(this.geometry) && (result = this.convert(target)) != this.geometry) {
            JTS.copyMetadata(this.geometry, result);
            return new Wrapper(result);
        }
        return this;
    }

    static Class<?> getGeometryClass(GeometryType type) {
        switch (type) {
            default: {
                return Geometry.class;
            }
            case POINT: {
                return Point.class;
            }
            case LINESTRING: {
                return LineString.class;
            }
            case POLYGON: {
                return Polygon.class;
            }
            case MULTIPOINT: {
                return MultiPoint.class;
            }
            case MULTILINESTRING: {
                return MultiLineString.class;
            }
            case MULTIPOLYGON: 
        }
        return MultiPolygon.class;
    }

    private Geometry convert(GeometryType target) {
        GeometryFactory factory = this.geometry.getFactory();
        switch (target) {
            case POINT: {
                return this.geometry.getCentroid();
            }
            case LINESTRING: {
                if (Wrapper.isCollection(this.geometry)) break;
                return factory.createLineString(this.geometry.getCoordinates());
            }
            case POLYGON: {
                if (!this.geometry.isEmpty() && this.geometry instanceof MultiLineString) {
                    MultiLineString lines = (MultiLineString)this.geometry;
                    LinearRing exterior = factory.createLinearRing(lines.getGeometryN(0).getCoordinates());
                    LinearRing[] interiors = new LinearRing[lines.getNumGeometries() - 1];
                    int i = 0;
                    while (i < interiors.length) {
                        interiors[i++] = factory.createLinearRing(lines.getGeometryN(i).getCoordinates());
                    }
                    return factory.createPolygon(exterior, interiors);
                }
                if (Wrapper.isCollection(this.geometry)) break;
                return factory.createPolygon(this.geometry.getCoordinates());
            }
            case MULTIPOINT: {
                return this.geometry instanceof Point ? factory.createMultiPoint(new Point[]{(Point)this.geometry}) : factory.createMultiPointFromCoords(this.geometry.getCoordinates());
            }
            case MULTILINESTRING: {
                return this.toCollection(factory, LineString.class, LineString[]::new, GeometryFactory::createLineString, GeometryFactory::createMultiLineString);
            }
            case MULTIPOLYGON: {
                return this.toCollection(factory, Polygon.class, Polygon[]::new, GeometryFactory::createPolygon, GeometryFactory::createMultiPolygon);
            }
            case GEOMETRYCOLLECTION: {
                if (this.geometry instanceof Point) {
                    return factory.createMultiPoint(new Point[]{(Point)this.geometry});
                }
                if (this.geometry instanceof LineString) {
                    return factory.createMultiLineString(new LineString[]{(LineString)this.geometry});
                }
                if (!(this.geometry instanceof Polygon)) break;
                return factory.createMultiPolygon(new Polygon[]{(Polygon)this.geometry});
            }
        }
        throw new UnconvertibleObjectException(Errors.format((short)7, this.geometry.getClass(), Wrapper.getGeometryClass(target)));
    }

    private <T extends Geometry> GeometryCollection toCollection(GeometryFactory factory, Class<T> type, IntFunction<T[]> newArray, BiFunction<GeometryFactory, Coordinate[], T> newComponent, BiFunction<GeometryFactory, T[], GeometryCollection> newCollection) {
        Geometry[] components = (Geometry[])newArray.apply(this.geometry.getNumGeometries());
        for (int i = 0; i < components.length; ++i) {
            Geometry c = this.geometry.getGeometryN(i);
            if (type.isInstance(c)) {
                components[i] = (Geometry)type.cast(c);
                continue;
            }
            if (Wrapper.isCollection(c)) {
                throw new IllegalArgumentException(Errors.format((short)94, GeometryCollection.class));
            }
            components[i] = (Geometry)newComponent.apply(factory, c.getCoordinates());
        }
        return newCollection.apply(factory, components);
    }

    private static boolean isCollection(Geometry geometry) {
        return geometry.getNumGeometries() >= 2 && !(geometry instanceof MultiPoint);
    }

    @Override
    public GeometryWrapper transform(CoordinateOperation operation, boolean validate) throws FactoryException, TransformException {
        return this.rewrap(JTS.transform(this.geometry, operation, validate));
    }

    @Override
    public GeometryWrapper transform(CoordinateReferenceSystem targetCRS) throws TransformException {
        try {
            return this.rewrap(JTS.transform(this.geometry, targetCRS));
        }
        catch (FactoryException e) {
            throw new TransformException(e.getMessage(), e);
        }
    }

    @Override
    public boolean isSameCRS(GeometryWrapper other) {
        return JTS.isSameCRS(this.geometry, ((Wrapper)other).geometry);
    }

    @Override
    public String formatWKT(double flatness) {
        return this.geometry.toText();
    }

    static {
        Wrapper.PREDICATES[SpatialOperatorName.BBOX.ordinal()] = (a, b) -> !a.disjoint(b);
        Wrapper.PREDICATES[SpatialOperatorName.EQUALS.ordinal()] = Geometry::equalsTopo;
        Wrapper.PREDICATES[SpatialOperatorName.DISJOINT.ordinal()] = Geometry::disjoint;
        Wrapper.PREDICATES[SpatialOperatorName.INTERSECTS.ordinal()] = Geometry::intersects;
        Wrapper.PREDICATES[SpatialOperatorName.TOUCHES.ordinal()] = Geometry::touches;
        Wrapper.PREDICATES[SpatialOperatorName.CROSSES.ordinal()] = Geometry::crosses;
        Wrapper.PREDICATES[SpatialOperatorName.WITHIN.ordinal()] = Geometry::within;
        Wrapper.PREDICATES[SpatialOperatorName.CONTAINS.ordinal()] = Geometry::contains;
        Wrapper.PREDICATES[SpatialOperatorName.OVERLAPS.ordinal()] = Geometry::overlaps;
        TYPES = new Class[]{Point.class, LineString.class, Polygon.class, MultiPoint.class, MultiLineString.class, MultiPolygon.class, GeometryCollection.class, Geometry.class};
        SQLMM_NAMES = new String[]{"ST_Point", "ST_LineString", "ST_Polygon", "ST_MultiPoint", "ST_MultiLineString", "ST_MultiPolygon", "ST_GeomCollection", "ST_Geometry"};
    }
}

