/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.filter.sqlmm;

import java.util.Arrays;
import java.util.Collection;
import org.apache.sis.filter.Expression;
import org.apache.sis.filter.internal.FunctionRegister;
import org.apache.sis.filter.sqlmm.GeometryConstructor;
import org.apache.sis.filter.sqlmm.OneGeometry;
import org.apache.sis.filter.sqlmm.SQLMM;
import org.apache.sis.filter.sqlmm.ST_FromBinary;
import org.apache.sis.filter.sqlmm.ST_FromText;
import org.apache.sis.filter.sqlmm.ST_Point;
import org.apache.sis.filter.sqlmm.ST_Transform;
import org.apache.sis.filter.sqlmm.TwoGeometries;
import org.apache.sis.geometry.wrapper.Geometries;
import org.apache.sis.pending.jdk.JDK17;

public final class Registry
implements FunctionRegister {
    private final Geometries<?> library;

    public Registry(Geometries<?> library) {
        this.library = library;
    }

    @Override
    public String getAuthority() {
        return "SQL/MM";
    }

    @Override
    public Collection<String> getNames() {
        return JDK17.toList(Arrays.stream(SQLMM.values()).map(Enum::name));
    }

    @Override
    public <R> Expression<R, ?> create(String name, Expression<R, ?>[] parameters) {
        SQLMM operation = SQLMM.valueOf(name);
        switch (operation) {
            case ST_PointFromWKB: 
            case ST_LineFromWKB: 
            case ST_PolyFromWKB: 
            case ST_BdPolyFromWKB: 
            case ST_GeomCollFromWKB: 
            case ST_MPointFromWKB: 
            case ST_MLineFromWKB: 
            case ST_MPolyFromWKB: 
            case ST_BdMPolyFromWKB: 
            case ST_GeomFromWKB: {
                return new ST_FromBinary(operation, parameters, this.library);
            }
            case ST_PointFromText: 
            case ST_LineFromText: 
            case ST_PolyFromText: 
            case ST_BdPolyFromText: 
            case ST_GeomCollFromText: 
            case ST_MPointFromText: 
            case ST_MLineFromText: 
            case ST_MPolyFromText: 
            case ST_BdMPolyFromText: 
            case ST_GeomFromText: {
                return new ST_FromText(operation, parameters, this.library);
            }
            case ST_Polygon: 
            case ST_LineString: 
            case ST_MultiPoint: 
            case ST_MultiLineString: 
            case ST_MultiPolygon: 
            case ST_GeomCollection: {
                return new GeometryConstructor(operation, parameters, this.library);
            }
            case ST_Point: {
                return new ST_Point<R>(parameters, this.library);
            }
            case ST_Transform: {
                return new ST_Transform<R>(parameters, this.library);
            }
        }
        switch (operation.geometryCount()) {
            case 1: {
                if (operation.maxParamCount == 1) {
                    return new OneGeometry<R>(operation, parameters, this.library);
                }
                return new OneGeometry.WithArgument<R>(operation, parameters, this.library);
            }
            case 2: {
                if (operation.maxParamCount == 2) {
                    return new TwoGeometries<R>(operation, parameters, this.library);
                }
                return new TwoGeometries.WithArgument<R>(operation, parameters, this.library);
            }
        }
        throw new AssertionError((Object)operation);
    }
}

