/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.io;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Iterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.sysds.conf.ConfigurationManager;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.data.DenseBlock;
import org.apache.sysds.runtime.io.IOUtilFunctions;
import org.apache.sysds.runtime.io.MatrixWriter;
import org.apache.sysds.runtime.matrix.data.IJV;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.util.HDFSTool;

public class WriterTextCell
extends MatrixWriter {
    @Override
    public final void writeMatrixToHDFS(MatrixBlock src, String fname, long rlen, long clen, int blen, long nnz, boolean diag) throws IOException, DMLRuntimeException {
        if ((long)src.getNumRows() != rlen || (long)src.getNumColumns() != clen) {
            throw new IOException("Matrix dimensions mismatch with metadata: " + src.getNumRows() + "x" + src.getNumColumns() + " vs " + rlen + "x" + clen + ".");
        }
        JobConf job = new JobConf((Configuration)ConfigurationManager.getCachedJobConf());
        Path path = new Path(fname);
        FileSystem fs = IOUtilFunctions.getFileSystem(path, (Configuration)job);
        HDFSTool.deleteFileIfExistOnHDFS(fname);
        this.writeTextCellMatrixToHDFS(path, job, fs, src, rlen, clen);
        IOUtilFunctions.deleteCrcFilesFromLocalFileSystem(fs, path);
    }

    @Override
    public final void writeEmptyMatrixToHDFS(String fname, long rlen, long clen, int blen) throws IOException, DMLRuntimeException {
        Path path = new Path(fname);
        FileSystem fs = IOUtilFunctions.getFileSystem(path);
        try (FSDataOutputStream writer = fs.create(path);){
            writer.writeBytes("0 0 0\n");
        }
        IOUtilFunctions.deleteCrcFilesFromLocalFileSystem(fs, path);
    }

    protected void writeTextCellMatrixToHDFS(Path path, JobConf job, FileSystem fs, MatrixBlock src, long rlen, long clen) throws IOException {
        WriterTextCell.writeTextCellMatrixToFile(path, job, fs, src, 0, (int)rlen);
    }

    protected static void writeTextCellMatrixToFile(Path path, JobConf job, FileSystem fs, MatrixBlock src, int rl, int ru) throws IOException {
        boolean sparse = src.isInSparseFormat();
        int clen = src.getNumColumns();
        try (BufferedWriter br = new BufferedWriter(new OutputStreamWriter((OutputStream)fs.create(path, true)));){
            StringBuilder sb = new StringBuilder();
            if (sparse) {
                Iterator<IJV> iter = src.getSparseBlockIterator(rl, ru);
                while (iter.hasNext()) {
                    IJV cell = iter.next();
                    sb.append(cell.getI() + 1);
                    sb.append(' ');
                    sb.append(cell.getJ() + 1);
                    sb.append(' ');
                    sb.append(cell.getV());
                    sb.append('\n');
                    br.write(sb.toString());
                    sb.setLength(0);
                }
            } else if (!src.isEmpty()) {
                DenseBlock d = src.getDenseBlock();
                for (int i = rl; i < ru; ++i) {
                    String rowIndex = Integer.toString(i + 1);
                    for (int j = 0; j < clen; ++j) {
                        double lvalue = d.get(i, j);
                        if (lvalue == 0.0) continue;
                        sb.append(rowIndex);
                        sb.append(' ');
                        sb.append(j + 1);
                        sb.append(' ');
                        sb.append(lvalue);
                        sb.append('\n');
                        br.write(sb.toString());
                        sb.setLength(0);
                    }
                }
            }
            if (src.isEmptyBlock(false) && rl == 0) {
                br.write("0 0 0\n");
            }
        }
    }
}

