/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.io.hdf5.message;

import java.nio.ByteBuffer;
import java.util.BitSet;
import org.apache.sysds.runtime.io.hdf5.H5BufferBuilder;
import org.apache.sysds.runtime.io.hdf5.H5RootObject;
import org.apache.sysds.runtime.io.hdf5.Utils;
import org.apache.sysds.runtime.io.hdf5.message.H5Message;

public class H5FillValueMessage
extends H5Message {
    private final int spaceAllocationTime;
    private final int fillValueWriteTime;
    private final boolean fillValueDefined;
    private final ByteBuffer fillValue;

    public H5FillValueMessage(H5RootObject rootObject, BitSet flags, int spaceAllocationTime, int fillValueWriteTime, boolean fillValueDefined) {
        super(rootObject, flags);
        this.spaceAllocationTime = spaceAllocationTime;
        this.fillValueWriteTime = fillValueWriteTime;
        this.fillValueDefined = fillValueDefined;
        this.fillValue = null;
    }

    public H5FillValueMessage(H5RootObject rootObject, BitSet flags, ByteBuffer bb) {
        super(rootObject, flags);
        boolean fillValueMaybeDefined;
        rootObject.setFillValueVersion(bb.get());
        this.spaceAllocationTime = bb.get();
        this.fillValueWriteTime = bb.get();
        boolean bl = fillValueMaybeDefined = bb.get() == 1;
        if (fillValueMaybeDefined) {
            int size = Utils.readBytesAsUnsignedInt(bb, 4);
            if (size > 0) {
                this.fillValue = Utils.createSubBuffer(bb, size);
                this.fillValueDefined = true;
            } else {
                this.fillValue = null;
                this.fillValueDefined = false;
            }
        } else {
            this.fillValue = null;
            this.fillValueDefined = false;
        }
    }

    @Override
    public void toBuffer(H5BufferBuilder bb) {
        super.toBuffer(bb, 5);
        bb.writeByte(this.rootObject.getFillValueVersion());
        bb.writeByte(this.spaceAllocationTime);
        bb.writeByte(this.fillValueWriteTime);
        if (this.fillValueDefined) {
            bb.writeByte(1);
        } else {
            bb.writeByte(0);
        }
        bb.writeInt(0);
    }

    public int getSpaceAllocationTime() {
        return this.spaceAllocationTime;
    }

    public int getFillValueWriteTime() {
        return this.fillValueWriteTime;
    }

    public boolean isFillValueDefined() {
        return this.fillValueDefined;
    }

    public ByteBuffer getFillValue() {
        return this.fillValue;
    }
}

