/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.commons.compiler.util;

import java.io.ByteArrayInputStream;
import java.io.InputStream;

public final class Disassembler {
    private Disassembler() {
    }

    public static void disassembleToStdout(byte[] contents) {
        try {
            Class<?> disassemblerClass = Class.forName("de.unkrig.jdisasm.Disassembler");
            Object disassemblerInstance = disassemblerClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            if (Boolean.getBoolean("disasm.verbose")) {
                disassemblerClass.getMethod("setVerbose", Boolean.TYPE).invoke(disassemblerInstance, true);
            }
            disassemblerClass.getMethod("disasm", InputStream.class).invoke(disassemblerInstance, new ByteArrayInputStream(contents));
        }
        catch (ClassNotFoundException cnfe) {
            System.err.println("Notice: Could not disassemble class file for logging because \"de.unkrig.jdisasm.Disassembler\" is not on the classpath. If you are interested in disassemblies of class files generated by JANINO, get de.unkrig.jdisasm and put it on the classpath.");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

