# -------------------------------------------------------------
#
# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.
#
# -------------------------------------------------------------

# Autogenerated By   : src/main/python/generator/generator.py
# Autogenerated From : scripts/builtin/decisionTree.dml

from typing import Dict, Iterable

from systemds.operator import OperationNode, Matrix, Frame, List, MultiReturn, Scalar
from systemds.script_building.dag import OutputType
from systemds.utils.consts import VALID_INPUT_TYPES


def decisionTree(X: Matrix,
                 Y: Matrix,
                 R: Matrix,
                 verbose: bool,
                 **kwargs: Dict[str, VALID_INPUT_TYPES]):
    """
    :param a: vector, other positive Integers indicate the number of categories
    :param If: not provided by default all variables are assumed to be scale
    :param bins: Number of equiheight bins per scale feature to choose thresholds
    :param depth: Maximum depth of the learned tree
    :param verbose: boolean specifying if the algorithm should print information while executing
    :return: 'OperationNode' containing looks at if j is an internal node, otherwise 0 & 6,7,... if j is categorical & a leaf node: number of misclassified samples reaching at node j & feature chosen for j is categorical rows 6,7,... depict the value subset chosen for j & a leaf node 1 if j is impure and the number of samples at j > threshold, otherwise 0 
    """
    params_dict = {'X': X, 'Y': Y, 'R': R, 'verbose': verbose}
    params_dict.update(kwargs)
    return Matrix(X.sds_context,
        'decisionTree',
        named_input_nodes=params_dict)
