/*
 * Decompiled with CFR 0.152.
 */
package jcuda.driver;

import java.util.Arrays;
import jcuda.driver.CUaddress_mode;
import jcuda.driver.CUfilter_mode;

public class CUDA_TEXTURE_DESC {
    public int[] addressMode = new int[3];
    public int filterMode;
    public int flags;
    public int maxAnisotropy;
    public int mipmapFilterMode;
    public float mipmapLevelBias;
    public float minMipmapLevelClamp;
    public float maxMipmapLevelClamp;
    public float[] borderColor = new float[4];

    public String toString() {
        return "CUDA_TEXTURE_DESC[" + this.createString(",") + "]";
    }

    public String toFormattedString() {
        return "CUDA texture descriptor:\n    " + this.createString("\n    ");
    }

    private String createString(String f) {
        StringBuilder sb = new StringBuilder();
        sb.append("addressMode=(" + CUaddress_mode.stringFor(this.addressMode[0]) + "," + CUaddress_mode.stringFor(this.addressMode[1]) + "," + CUaddress_mode.stringFor(this.addressMode[2]) + ")" + f);
        sb.append("filterMode=" + CUfilter_mode.stringFor(this.filterMode) + f);
        String flagsString = "";
        if ((this.flags & 1) != 0) {
            flagsString = flagsString + "CU_TRSF_READ_AS_INTEGER";
        }
        if ((this.flags & 2) != 0) {
            flagsString = flagsString + "CU_TRSF_NORMALIZED_COORDINATES";
        }
        sb.append("flags=" + this.flags + "(" + flagsString + ")");
        sb.append("maxAnisotropy=" + this.maxAnisotropy);
        sb.append("mipmapFilterMode=" + CUfilter_mode.stringFor(this.mipmapFilterMode) + f);
        sb.append("mipmapLevelBias=" + this.mipmapLevelBias + f);
        sb.append("minMipmapLevelClamp=" + this.minMipmapLevelClamp + f);
        sb.append("maxMipmapLevelClamp=" + this.maxMipmapLevelClamp + f);
        sb.append("borderColor=" + Arrays.toString(this.borderColor) + f);
        return sb.toString();
    }
}

