/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.estim;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.runtime.compress.CompressionSettings;
import org.apache.sysds.runtime.compress.estim.CompressedSizeEstimator;
import org.apache.sysds.runtime.compress.estim.CompressedSizeEstimatorExact;
import org.apache.sysds.runtime.compress.estim.CompressedSizeEstimatorSample;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;

public class CompressedSizeEstimatorFactory {
    protected static final Log LOG = LogFactory.getLog((String)CompressedSizeEstimatorFactory.class.getName());

    public static CompressedSizeEstimator getSizeEstimator(MatrixBlock data, CompressionSettings cs) {
        int nRows = cs.transposed ? data.getNumColumns() : data.getNumRows();
        int nCols = cs.transposed ? data.getNumRows() : data.getNumColumns();
        int nnzRows = (int)Math.ceil(data.getNonZeros() / (long)nCols);
        double sampleRatio = cs.samplingRatio;
        int sampleSize = CompressedSizeEstimatorFactory.getSampleSize(sampleRatio, nRows, cs.minimumSampleSize);
        CompressedSizeEstimatorExact est = CompressedSizeEstimatorFactory.shouldUseExactEstimator(cs, nRows, sampleSize, nnzRows) ? new CompressedSizeEstimatorExact(data, cs) : CompressedSizeEstimatorFactory.tryToMakeSampleEstimator(data, cs, sampleRatio, sampleSize, nRows, nnzRows);
        LOG.debug((Object)("Estimating using: " + est));
        return est;
    }

    private static CompressedSizeEstimator tryToMakeSampleEstimator(MatrixBlock data, CompressionSettings cs, double sampleRatio, int sampleSize, int nRows, int nnzRows) {
        CompressedSizeEstimatorSample estS = new CompressedSizeEstimatorSample(data, cs, sampleSize);
        while (estS.getSample() == null) {
            LOG.warn((Object)"Doubling sample size");
            if (CompressedSizeEstimatorFactory.shouldUseExactEstimator(cs, nRows, sampleSize *= 2, nnzRows)) {
                return new CompressedSizeEstimatorExact(data, cs);
            }
            estS.sampleData(sampleSize);
        }
        return estS;
    }

    private static boolean shouldUseExactEstimator(CompressionSettings cs, int nRows, int sampleSize, int nnzRows) {
        return cs.samplingRatio >= 1.0 || nRows < cs.minimumSampleSize || sampleSize > nnzRows;
    }

    private static int getSampleSize(double sampleRatio, int nRows, int minimumSampleSize) {
        return Math.max((int)Math.ceil((double)nRows * sampleRatio), minimumSampleSize);
    }
}

