/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.cocode;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.runtime.compress.CompressionSettings;
import org.apache.sysds.runtime.compress.cocode.AColumnCoCoder;
import org.apache.sysds.runtime.compress.cocode.CoCodeBinPacking;
import org.apache.sysds.runtime.compress.cocode.CoCodeCost;
import org.apache.sysds.runtime.compress.cocode.CoCodeCostMatrixMult;
import org.apache.sysds.runtime.compress.cocode.CoCodeCostTSMM;
import org.apache.sysds.runtime.compress.cocode.CoCodeStatic;
import org.apache.sysds.runtime.compress.estim.CompressedSizeEstimator;
import org.apache.sysds.runtime.compress.estim.CompressedSizeInfo;

public class PlanningCoCoder {
    protected static final Log LOG = LogFactory.getLog((String)PlanningCoCoder.class.getName());

    public static CompressedSizeInfo findCoCodesByPartitioning(CompressedSizeEstimator est, CompressedSizeInfo colInfos, int numRows, int k, CompressionSettings cs) {
        CompressedSizeInfo bins = PlanningCoCoder.createColumnGroupPartitioner(cs.columnPartitioner, est, cs, numRows).coCodeColumns(colInfos, k);
        return bins;
    }

    private static AColumnCoCoder createColumnGroupPartitioner(PartitionerType type, CompressedSizeEstimator est, CompressionSettings cs, int numRows) {
        switch (type) {
            case BIN_PACKING: {
                return new CoCodeBinPacking(est, cs);
            }
            case STATIC: {
                return new CoCodeStatic(est, cs);
            }
            case COST: {
                return new CoCodeCost(est, cs);
            }
            case COST_MATRIX_MULT: {
                return new CoCodeCostMatrixMult(est, cs);
            }
            case COST_TSMM: {
                return new CoCodeCostTSMM(est, cs);
            }
        }
        throw new RuntimeException("Unsupported column group partitioner: " + type.toString());
    }

    public static enum PartitionerType {
        BIN_PACKING,
        STATIC,
        COST,
        COST_MATRIX_MULT,
        COST_TSMM;


        public static boolean isCostBased(PartitionerType pt) {
            switch (pt) {
                case COST_MATRIX_MULT: 
                case COST_TSMM: {
                    return true;
                }
            }
            return false;
        }
    }
}

