/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.matrix;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.sysml.conf.ConfigurationManager;
import org.apache.sysml.conf.DMLConfig;
import org.apache.sysml.runtime.instructions.MRJobInstruction;
import org.apache.sysml.runtime.instructions.mr.CombineBinaryInstruction;
import org.apache.sysml.runtime.instructions.mr.CombineTernaryInstruction;
import org.apache.sysml.runtime.instructions.mr.MRInstruction;
import org.apache.sysml.runtime.matrix.JobReturn;
import org.apache.sysml.runtime.matrix.MatrixCharacteristics;
import org.apache.sysml.runtime.matrix.data.InputInfo;
import org.apache.sysml.runtime.matrix.data.MatrixIndexes;
import org.apache.sysml.runtime.matrix.data.MatrixValue;
import org.apache.sysml.runtime.matrix.data.OutputInfo;
import org.apache.sysml.runtime.matrix.data.Pair;
import org.apache.sysml.runtime.matrix.data.TaggedMatrixBlock;
import org.apache.sysml.runtime.matrix.data.TaggedMatrixCell;
import org.apache.sysml.runtime.matrix.data.TaggedMatrixValue;
import org.apache.sysml.runtime.matrix.data.WeightedPair;
import org.apache.sysml.runtime.matrix.mapred.GMRMapper;
import org.apache.sysml.runtime.matrix.mapred.IndexedMatrixValue;
import org.apache.sysml.runtime.matrix.mapred.MRJobConfiguration;
import org.apache.sysml.runtime.matrix.mapred.ReduceBase;
import org.apache.sysml.runtime.util.UtilFunctions;

public class CombineMR {
    private static final Log LOG = LogFactory.getLog(CombineMR.class.getName());

    private CombineMR() {
    }

    public static JobReturn runJob(MRJobInstruction inst, String[] inputs, InputInfo[] inputInfos, long[] rlens, long[] clens, int[] brlens, int[] bclens, String combineInstructions, int numReducers, int replication, byte[] resultIndexes, String[] outputs, OutputInfo[] outputInfos) throws Exception {
        JobConf job = new JobConf(CombineMR.class);
        job.setJobName("Standalone-MR");
        boolean inBlockRepresentation = MRJobConfiguration.deriveRepresentation(inputInfos);
        MRJobConfiguration.setMatrixValueClass(job, inBlockRepresentation);
        byte[] inputIndexes = new byte[inputs.length];
        for (int b = 0; b < inputs.length; b = (int)((byte)(b + 1))) {
            inputIndexes[b] = b;
        }
        MRJobConfiguration.setUpMultipleInputs(job, inputIndexes, inputs, inputInfos, brlens, bclens, true, inBlockRepresentation ? MRJobConfiguration.ConvertTarget.BLOCK : MRJobConfiguration.ConvertTarget.CELL);
        MRJobConfiguration.setMatricesDimensions(job, inputIndexes, rlens, clens);
        MRJobConfiguration.setBlocksSizes(job, inputIndexes, brlens, bclens);
        MRJobConfiguration.setInstructionsInMapper(job, "");
        MRJobConfiguration.setAggregateInstructions(job, "");
        MRJobConfiguration.setInstructionsInReducer(job, "");
        MRJobConfiguration.setCombineInstructions(job, combineInstructions);
        job.setInt("dfs.replication", replication);
        DMLConfig config = ConfigurationManager.getDMLConfig();
        MRJobConfiguration.setupCustomMRConfigurations(job, config);
        HashSet<Byte> mapoutputIndexes = MRJobConfiguration.setUpOutputIndexesForMapper(job, inputIndexes, null, null, combineInstructions, resultIndexes);
        MRJobConfiguration.setUpMultipleOutputs(job, resultIndexes, null, outputs, outputInfos, inBlockRepresentation);
        job.setMapperClass(GMRMapper.class);
        job.setMapOutputKeyClass(MatrixIndexes.class);
        if (inBlockRepresentation) {
            job.setMapOutputValueClass(TaggedMatrixBlock.class);
        } else {
            job.setMapOutputValueClass(TaggedMatrixCell.class);
        }
        job.setReducerClass(InnerReducer.class);
        MRJobConfiguration.MatrixChar_N_ReducerGroups ret = MRJobConfiguration.computeMatrixCharacteristics(job, inputIndexes, null, null, null, combineInstructions, resultIndexes, mapoutputIndexes, false);
        MatrixCharacteristics[] stats = ret.stats;
        MRJobConfiguration.setNumReducers(job, ret.numReducerGroups, numReducers);
        if (LOG.isTraceEnabled()) {
            inst.printCompleteMRJobInstruction(stats);
        }
        MatrixCharacteristics[] inputStats = new MatrixCharacteristics[inputs.length];
        for (int i = 0; i < inputs.length; ++i) {
            inputStats[i] = new MatrixCharacteristics(rlens[i], clens[i], brlens[i], bclens[i]);
        }
        MRJobConfiguration.setUniqueWorkingDir(job);
        RunningJob runjob = JobClient.runJob(job);
        return new JobReturn(stats, runjob.isSuccessful());
    }

    public static class InnerReducer
    extends ReduceBase
    implements Reducer<MatrixIndexes, TaggedMatrixValue, MatrixIndexes, WeightedPair> {
        protected MRInstruction[] comb_instructions = null;
        private MatrixIndexes keyBuff = new MatrixIndexes();
        private WeightedPair valueBuff = new WeightedPair();
        private HashMap<Byte, Pair<Integer, Integer>> outputBlockSizes = new HashMap();
        private HashMap<Byte, ArrayList<Integer>> outputIndexesMapping = new HashMap();

        public void reduce(MatrixIndexes indexes, Iterator<TaggedMatrixValue> values, OutputCollector<MatrixIndexes, WeightedPair> out, Reporter reporter) throws IOException {
            long start = System.currentTimeMillis();
            if (this.firsttime) {
                this.cachedReporter = reporter;
                this.firsttime = false;
            }
            this.cachedValues.reset();
            while (values.hasNext()) {
                TaggedMatrixValue taggedValue = values.next();
                this.cachedValues.set(taggedValue.getTag(), indexes, (MatrixValue)taggedValue.getBaseObject(), true);
            }
            this.processCombineInstructionsAndOutput(reporter);
            reporter.incrCounter(ReduceBase.Counters.COMBINE_OR_REDUCE_TIME, System.currentTimeMillis() - start);
        }

        @Override
        public void configure(JobConf job) {
            super.configure(job);
            try {
                this.comb_instructions = MRJobConfiguration.getCombineInstruction(job);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            for (int i = 0; i < this.resultIndexes.length; ++i) {
                MatrixCharacteristics stat = MRJobConfiguration.getMatrixCharacteristicsForOutput(job, this.resultIndexes[i]);
                this.outputBlockSizes.put(this.resultIndexes[i], new Pair<Integer, Integer>(stat.getRowsPerBlock(), stat.getColsPerBlock()));
            }
            for (MRInstruction ins : this.comb_instructions) {
                this.outputIndexesMapping.put(ins.output, this.getOutputIndexes(ins.output));
            }
        }

        void processCombineInstructionsAndOutput(Reporter reporter) throws IOException {
            for (MRInstruction ins : this.comb_instructions) {
                if (ins instanceof CombineBinaryInstruction) {
                    this.processBinaryCombineInstruction((CombineBinaryInstruction)ins, reporter);
                    continue;
                }
                if (ins instanceof CombineTernaryInstruction) {
                    this.processTernaryCombineInstruction((CombineTernaryInstruction)ins, reporter);
                    continue;
                }
                throw new IOException("unsupported instruction: " + ins);
            }
        }

        private void processTernaryCombineInstruction(CombineTernaryInstruction ins, Reporter reporter) throws IOException {
            IndexedMatrixValue in1 = this.cachedValues.getFirst(ins.input1);
            IndexedMatrixValue in2 = this.cachedValues.getFirst(ins.input2);
            IndexedMatrixValue in3 = this.cachedValues.getFirst(ins.input3);
            if (in1 == null && in2 == null && in3 == null) {
                return;
            }
            int nr = 0;
            int nc = 0;
            if (in1 != null) {
                nr = in1.getValue().getNumRows();
                nc = in1.getValue().getNumColumns();
            } else if (in2 != null) {
                nr = in2.getValue().getNumRows();
                nc = in2.getValue().getNumColumns();
            } else {
                nr = in3.getValue().getNumRows();
                nc = in3.getValue().getNumColumns();
            }
            if (in1 == null) {
                in1 = this.zeroInput;
                in1.getValue().reset(nr, nc);
            }
            if (in2 == null) {
                in2 = this.zeroInput;
                in2.getValue().reset(nr, nc);
            }
            if (in3 == null) {
                in3 = this.zeroInput;
                in3.getValue().reset(nr, nc);
            }
            try {
                ArrayList<Integer> outputIndexes = this.outputIndexesMapping.get(ins.output);
                for (int r = 0; r < nr; ++r) {
                    for (int c = 0; c < nc; ++c) {
                        Pair<Integer, Integer> blockSize = this.outputBlockSizes.get(ins.output);
                        this.keyBuff.setIndexes(UtilFunctions.computeCellIndex(in1.getIndexes().getRowIndex(), blockSize.getKey(), r), UtilFunctions.computeCellIndex(in1.getIndexes().getColumnIndex(), blockSize.getValue(), c));
                        this.valueBuff.setValue(in1.getValue().getValue(r, c));
                        this.valueBuff.setOtherValue(in2.getValue().getValue(r, c));
                        this.valueBuff.setWeight(in3.getValue().getValue(r, c));
                        for (int i : outputIndexes) {
                            this.collectFinalMultipleOutputs.collectOutput(this.keyBuff, this.valueBuff, i, reporter);
                        }
                    }
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        private void processBinaryCombineInstruction(CombineBinaryInstruction ins, Reporter reporter) throws IOException {
            IndexedMatrixValue in1 = this.cachedValues.getFirst(ins.input1);
            IndexedMatrixValue in2 = this.cachedValues.getFirst(ins.input2);
            if (in1 == null && in2 == null) {
                return;
            }
            MatrixIndexes indexes = in1 != null ? in1.getIndexes() : in2.getIndexes();
            if (in1 == null) {
                in1 = this.zeroInput;
                in1.getValue().reset(in2.getValue().getNumRows(), in2.getValue().getNumColumns());
            }
            if (in2 == null) {
                in2 = this.zeroInput;
                in2.getValue().reset(in1.getValue().getNumRows(), in1.getValue().getNumColumns());
            }
            try {
                ArrayList<Integer> outputIndexes = this.outputIndexesMapping.get(ins.output);
                for (int r = 0; r < in1.getValue().getNumRows(); ++r) {
                    for (int c = 0; c < in1.getValue().getNumColumns(); ++c) {
                        Pair<Integer, Integer> blockSize = this.outputBlockSizes.get(ins.output);
                        this.keyBuff.setIndexes(UtilFunctions.computeCellIndex(indexes.getRowIndex(), blockSize.getKey(), r), UtilFunctions.computeCellIndex(indexes.getColumnIndex(), blockSize.getValue(), c));
                        this.valueBuff.setValue(in1.getValue().getValue(r, c));
                        double temp = in2.getValue().getValue(r, c);
                        if (ins.isSecondInputWeight()) {
                            this.valueBuff.setWeight(temp);
                            this.valueBuff.setOtherValue(0.0);
                        } else {
                            this.valueBuff.setWeight(1.0);
                            this.valueBuff.setOtherValue(temp);
                        }
                        for (int i : outputIndexes) {
                            this.collectFinalMultipleOutputs.collectOutput(this.keyBuff, this.valueBuff, i, reporter);
                        }
                    }
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

