/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.controlprogram.parfor;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Iterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mapred.Reporter;
import org.apache.sysml.runtime.controlprogram.parfor.util.PairWritableBlock;
import org.apache.sysml.runtime.controlprogram.parfor.util.PairWritableCell;
import org.apache.sysml.runtime.io.IOUtilFunctions;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.data.MatrixCell;
import org.apache.sysml.runtime.matrix.data.MatrixIndexes;
import org.apache.sysml.runtime.matrix.data.OutputInfo;
import org.apache.sysml.runtime.matrix.mapred.MRJobConfiguration;

public class DataPartitionerRemoteReducer
implements Reducer<LongWritable, Writable, Writable, Writable> {
    private DataPartitionerReducer _reducer = null;

    public void reduce(LongWritable key, Iterator<Writable> valueList, OutputCollector<Writable, Writable> out, Reporter reporter) throws IOException {
        this._reducer.processKeyValueList(key, valueList, out, reporter);
    }

    public void configure(JobConf job) {
        String fnameNew = MRJobConfiguration.getPartitioningFilename(job);
        OutputInfo oi = MRJobConfiguration.getPartitioningOutputInfo(job);
        if (oi == OutputInfo.TextCellOutputInfo) {
            this._reducer = new DataPartitionerReducerTextcell(job, fnameNew);
        } else if (oi == OutputInfo.BinaryCellOutputInfo) {
            this._reducer = new DataPartitionerReducerBinarycell(job, fnameNew);
        } else if (oi == OutputInfo.BinaryBlockOutputInfo) {
            this._reducer = new DataPartitionerReducerBinaryblock(job, fnameNew);
        } else {
            throw new RuntimeException("Unable to configure reducer with unknown output info: " + oi.toString());
        }
    }

    public void close() throws IOException {
    }

    private class DataPartitionerReducerBinaryblock
    extends DataPartitionerReducer {
        protected DataPartitionerReducerBinaryblock(JobConf job, String fnameNew) {
            super(job, fnameNew);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void processKeyValueList(LongWritable key, Iterator<Writable> valueList, OutputCollector<Writable, Writable> out, Reporter reporter) throws IOException {
            try (SequenceFile.Writer writer = null;){
                Path path = new Path(this._fnameNew + "/" + key.get());
                writer = new SequenceFile.Writer(this._fs, (Configuration)this._job, path, MatrixIndexes.class, MatrixBlock.class);
                while (valueList.hasNext()) {
                    PairWritableBlock pairValue = (PairWritableBlock)valueList.next();
                    writer.append((Writable)pairValue.indexes, (Writable)pairValue.block);
                }
            }
        }
    }

    private class DataPartitionerReducerBinarycell
    extends DataPartitionerReducer {
        protected DataPartitionerReducerBinarycell(JobConf job, String fnameNew) {
            super(job, fnameNew);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void processKeyValueList(LongWritable key, Iterator<Writable> valueList, OutputCollector<Writable, Writable> out, Reporter reporter) throws IOException {
            try (SequenceFile.Writer writer = null;){
                Path path = new Path(this._fnameNew + "/" + key.get());
                writer = new SequenceFile.Writer(this._fs, (Configuration)this._job, path, MatrixIndexes.class, MatrixCell.class);
                while (valueList.hasNext()) {
                    PairWritableCell pairValue = (PairWritableCell)valueList.next();
                    writer.append((Writable)pairValue.indexes, (Writable)pairValue.cell);
                }
            }
        }
    }

    private class DataPartitionerReducerTextcell
    extends DataPartitionerReducer {
        private StringBuilder _sb;

        protected DataPartitionerReducerTextcell(JobConf job, String fnameNew) {
            super(job, fnameNew);
            this._sb = null;
            this._sb = new StringBuilder();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void processKeyValueList(LongWritable key, Iterator<Writable> valueList, OutputCollector<Writable, Writable> out, Reporter reporter) throws IOException {
            BufferedWriter writer = null;
            try {
                Path path = new Path(this._fnameNew + "/" + key.get());
                writer = new BufferedWriter(new OutputStreamWriter((OutputStream)this._fs.create(path, true)));
                while (valueList.hasNext()) {
                    PairWritableCell pairValue = (PairWritableCell)valueList.next();
                    this._sb.append(pairValue.indexes.getRowIndex());
                    this._sb.append(' ');
                    this._sb.append(pairValue.indexes.getColumnIndex());
                    this._sb.append(' ');
                    this._sb.append(pairValue.cell.getValue());
                    this._sb.append('\n');
                    writer.write(this._sb.toString());
                    this._sb.setLength(0);
                }
            }
            catch (Throwable throwable) {
                IOUtilFunctions.closeSilently(writer);
                throw throwable;
            }
            IOUtilFunctions.closeSilently(writer);
        }
    }

    private abstract class DataPartitionerReducer {
        protected JobConf _job = null;
        protected FileSystem _fs = null;
        protected String _fnameNew = null;

        protected DataPartitionerReducer(JobConf job, String fnameNew) {
            this._job = job;
            this._fnameNew = fnameNew;
            try {
                this._fs = IOUtilFunctions.getFileSystem(new Path(fnameNew), (Configuration)job);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        protected abstract void processKeyValueList(LongWritable var1, Iterator<Writable> var2, OutputCollector<Writable, Writable> var3, Reporter var4) throws IOException;
    }
}

