/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.scripts.nn.layers;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.sysml.api.mlcontext.MLResults;
import org.apache.sysml.api.mlcontext.Matrix;
import org.apache.sysml.api.mlcontext.Script;
import org.apache.sysml.scripts.nn.layers.batch_norm2d.Backward_output;
import org.apache.sysml.scripts.nn.layers.batch_norm2d.Forward_output;
import org.apache.sysml.scripts.nn.layers.batch_norm2d.Init_output;

public class Batch_norm2d
extends Script {
    public Batch_norm2d() {
        String string = "scripts/nn/layers/batch_norm2d.dml";
        InputStream inputStream = Script.class.getResourceAsStream(new StringBuffer().append("/").append(string).toString());
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        char[] cArray = new char[1024];
        StringBuilder stringBuilder = new StringBuilder();
        try {
            int n;
            while ((n = inputStreamReader.read(cArray)) > 0) {
                stringBuilder.append(cArray, 0, n);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.setScriptString(stringBuilder.toString());
    }

    public Init_output init(Object object) {
        String string = "source('scripts/nn/layers/batch_norm2d.dml') as mlcontextns;[gamma, beta, ema_mean, ema_var] = mlcontextns::init(C);";
        Script script = new Script(string);
        script.in("C", object).out("gamma").out("beta").out("ema_mean").out("ema_var");
        MLResults mLResults = script.execute();
        Matrix matrix = mLResults.getMatrix("gamma");
        Matrix matrix2 = mLResults.getMatrix("beta");
        Matrix matrix3 = mLResults.getMatrix("ema_mean");
        Matrix matrix4 = mLResults.getMatrix("ema_var");
        Init_output init_output = new Init_output(matrix, matrix2, matrix3, matrix4);
        return init_output;
    }

    public String init__docs() {
        String string = "init = function(int C)\n    return (matrix[double] gamma, matrix[double] beta,\n            matrix[double] ema_mean, matrix[double] ema_var) {\n  /*\n   * Initialize the parameters of this layer.\n   *\n   * Note: This is just a convenience function, and parameters\n   * may be initialized manually if needed.\n   *\n   * Inputs:\n   *  - C: Number of input channels (dimensionality of input depth).\n   *\n   * Outputs:\n   *  - gamma: Scale parameters, of shape (C, 1).\n   *  - beta: Shift parameters, of shape (C, 1).\n   *  - ema_mean: Exponential moving average of the mean, of\n   *      shape (C, 1).\n   *  - ema_var: Exponential moving average of the variance, of\n   *      shape (C, 1).\n   */\n";
        return string;
    }

    public String init__source() {
        String string = "init = function(int C)\n    return (matrix[double] gamma, matrix[double] beta,\n            matrix[double] ema_mean, matrix[double] ema_var) {\n  /*\n   * Initialize the parameters of this layer.\n   *\n   * Note: This is just a convenience function, and parameters\n   * may be initialized manually if needed.\n   *\n   * Inputs:\n   *  - C: Number of input channels (dimensionality of input depth).\n   *\n   * Outputs:\n   *  - gamma: Scale parameters, of shape (C, 1).\n   *  - beta: Shift parameters, of shape (C, 1).\n   *  - ema_mean: Exponential moving average of the mean, of\n   *      shape (C, 1).\n   *  - ema_var: Exponential moving average of the variance, of\n   *      shape (C, 1).\n   */\n   gamma = matrix(1, rows=C, cols=1)\n   beta = matrix(0, rows=C, cols=1)\n   ema_mean = matrix(0, rows=C, cols=1)\n   ema_var = matrix(1, rows=C, cols=1)\n}\n";
        return string;
    }

    public Forward_output forward(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8, Object object9, Object object10, Object object11) {
        String string = "source('scripts/nn/layers/batch_norm2d.dml') as mlcontextns;[out, ema_mean_upd, ema_var_upd, cache_mean, cache_inv_var] = mlcontextns::forward(X, gamma, beta, C, Hin, Win, mode, ema_mean, ema_var, mu, epsilon);";
        Script script = new Script(string);
        script.in("X", object).in("gamma", object2).in("beta", object3).in("C", object4).in("Hin", object5).in("Win", object6).in("mode", object7).in("ema_mean", object8).in("ema_var", object9).in("mu", object10).in("epsilon", object11).out("out").out("ema_mean_upd").out("ema_var_upd").out("cache_mean").out("cache_inv_var");
        MLResults mLResults = script.execute();
        Matrix matrix = mLResults.getMatrix("out");
        Matrix matrix2 = mLResults.getMatrix("ema_mean_upd");
        Matrix matrix3 = mLResults.getMatrix("ema_var_upd");
        Matrix matrix4 = mLResults.getMatrix("cache_mean");
        Matrix matrix5 = mLResults.getMatrix("cache_inv_var");
        Forward_output forward_output = new Forward_output(matrix, matrix2, matrix3, matrix4, matrix5);
        return forward_output;
    }

    public String forward__docs() {
        String string = "forward = function(matrix[double] X, matrix[double] gamma, matrix[double] beta,\n                   int C, int Hin, int Win, string mode,\n                   matrix[double] ema_mean, matrix[double] ema_var,\n                   double mu, double epsilon)\n    return (matrix[double] out, matrix[double] ema_mean_upd, matrix[double] ema_var_upd,\n            matrix[double] cache_mean, matrix[double] cache_inv_var) {\n  /*\n   * Computes the forward pass for a 2D (spatial) batch normalization\n   * layer.  The input data has N examples, each represented as a 3D\n   * volume unrolled into a single vector.\n   *\n   * A spatial batch normalization layer uses the per-channel sample\n   * mean and per-channel uncorrected sample variance during training\n   * to normalize each channel of the input data.  Additionally, it\n   * introduces learnable parameters (gamma, beta) to control the\n   * amount of normalization.\n   *\n   *   `y = ((x-mean) / sqrt(var+eps)) * gamma + beta`\n   *\n   * This implementation maintains exponential moving averages of the\n   * mean and variance during training for use during testing.\n   *\n   * Reference:\n   *  - Batch Normalization: Accelerating Deep Network Training by\n   *    Reducing Internal Covariate Shift, S. Ioffe & C. Szegedy, 2015\n   *    - https://arxiv.org/abs/1502.03167\n   *\n   * Inputs:\n   *  - X: Inputs, of shape (N, C*Hin*Win).\n   *  - gamma: Scale parameters, of shape (C, 1).\n   *  - beta: Shift parameters, of shape (C, 1).\n   *  - C: Number of input channels (dimensionality of input depth).\n   *  - Hin: Input height.\n   *  - Win: Input width.\n   *  - mode: 'train' or 'test' to indicate if the model is currently\n   *      being trained or tested.  During training, the current batch\n   *      mean and variance will be used to normalize the inputs, while\n   *      during testing, the exponential average of the mean and\n   *      variance over all previous batches will be used.\n   *  - ema_mean: Exponential moving average of the mean, of\n   *      shape (C, 1).\n   *  - ema_var: Exponential moving average of the variance, of\n   *      shape (C, 1).\n   *  - mu: Momentum value for moving averages.\n   *      Typical values are in the range of [0.9, 0.999].\n   *  - epsilon: Smoothing term to avoid divide by zero errors.\n   *      Typical values are in the range of [1e-5, 1e-3].\n   *\n   * Outputs:\n   *  - out: Outputs, of shape (N, C*Hin*Win).\n   *  - ema_mean_upd: Updated exponential moving average of the mean,\n   *      of shape (C, 1).\n   *  - ema_var_upd: Updated exponential moving average of the variance,\n   *      of shape (C, 1).\n   *  - cache_mean: Cache of the batch mean, of shape (C, 1).\n   *      Note: This is used for performance during training.\n   *  - cache_inv_var: Cache of the inverse variance, of shape (C, 1).\n   *      Note: This is used for performance during training.\n   */\n";
        return string;
    }

    public String forward__source() {
        String string = "forward = function(matrix[double] X, matrix[double] gamma, matrix[double] beta,\n                   int C, int Hin, int Win, string mode,\n                   matrix[double] ema_mean, matrix[double] ema_var,\n                   double mu, double epsilon)\n    return (matrix[double] out, matrix[double] ema_mean_upd, matrix[double] ema_var_upd,\n            matrix[double] cache_mean, matrix[double] cache_inv_var) {\n  /*\n   * Computes the forward pass for a 2D (spatial) batch normalization\n   * layer.  The input data has N examples, each represented as a 3D\n   * volume unrolled into a single vector.\n   *\n   * A spatial batch normalization layer uses the per-channel sample\n   * mean and per-channel uncorrected sample variance during training\n   * to normalize each channel of the input data.  Additionally, it\n   * introduces learnable parameters (gamma, beta) to control the\n   * amount of normalization.\n   *\n   *   `y = ((x-mean) / sqrt(var+eps)) * gamma + beta`\n   *\n   * This implementation maintains exponential moving averages of the\n   * mean and variance during training for use during testing.\n   *\n   * Reference:\n   *  - Batch Normalization: Accelerating Deep Network Training by\n   *    Reducing Internal Covariate Shift, S. Ioffe & C. Szegedy, 2015\n   *    - https://arxiv.org/abs/1502.03167\n   *\n   * Inputs:\n   *  - X: Inputs, of shape (N, C*Hin*Win).\n   *  - gamma: Scale parameters, of shape (C, 1).\n   *  - beta: Shift parameters, of shape (C, 1).\n   *  - C: Number of input channels (dimensionality of input depth).\n   *  - Hin: Input height.\n   *  - Win: Input width.\n   *  - mode: 'train' or 'test' to indicate if the model is currently\n   *      being trained or tested.  During training, the current batch\n   *      mean and variance will be used to normalize the inputs, while\n   *      during testing, the exponential average of the mean and\n   *      variance over all previous batches will be used.\n   *  - ema_mean: Exponential moving average of the mean, of\n   *      shape (C, 1).\n   *  - ema_var: Exponential moving average of the variance, of\n   *      shape (C, 1).\n   *  - mu: Momentum value for moving averages.\n   *      Typical values are in the range of [0.9, 0.999].\n   *  - epsilon: Smoothing term to avoid divide by zero errors.\n   *      Typical values are in the range of [1e-5, 1e-3].\n   *\n   * Outputs:\n   *  - out: Outputs, of shape (N, C*Hin*Win).\n   *  - ema_mean_upd: Updated exponential moving average of the mean,\n   *      of shape (C, 1).\n   *  - ema_var_upd: Updated exponential moving average of the variance,\n   *      of shape (C, 1).\n   *  - cache_mean: Cache of the batch mean, of shape (C, 1).\n   *      Note: This is used for performance during training.\n   *  - cache_inv_var: Cache of the inverse variance, of shape (C, 1).\n   *      Note: This is used for performance during training.\n   */\n  out = X; ema_mean_upd = ema_mean; ema_var_upd = ema_var;  cache_mean = ema_mean;  cache_inv_var = ema_var\n  [out, ema_mean_upd, ema_var_upd, cache_mean, cache_inv_var] = batch_norm2d(X, gamma, beta, ema_mean, ema_var, mode, epsilon, mu)\n}\n";
        return string;
    }

    public Backward_output backward(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8, Object object9) {
        String string = "source('scripts/nn/layers/batch_norm2d.dml') as mlcontextns;[dX, dgamma, dbeta] = mlcontextns::backward(dout, cache_mean, cache_inv_var, X, gamma, C, Hin, Win, epsilon);";
        Script script = new Script(string);
        script.in("dout", object).in("cache_mean", object2).in("cache_inv_var", object3).in("X", object4).in("gamma", object5).in("C", object6).in("Hin", object7).in("Win", object8).in("epsilon", object9).out("dX").out("dgamma").out("dbeta");
        MLResults mLResults = script.execute();
        Matrix matrix = mLResults.getMatrix("dX");
        Matrix matrix2 = mLResults.getMatrix("dgamma");
        Matrix matrix3 = mLResults.getMatrix("dbeta");
        Backward_output backward_output = new Backward_output(matrix, matrix2, matrix3);
        return backward_output;
    }

    public String backward__docs() {
        String string = "backward = function(matrix[double] dout, \n                    matrix[double] cache_mean, matrix[double] cache_inv_var,\n                    matrix[double] X, matrix[double] gamma, \n                    int C, int Hin, int Win, double epsilon)\n      return (matrix[double] dX, matrix[double] dgamma, matrix[double] dbeta) {\n  /*\n   * Computes the backward pass for a 2D (spatial) batch normalization\n   * layer.\n   *\n   * Inputs:\n   *  - dout: Gradient wrt `out` from upstream, of shape (N, C*Hin*Win).\n   *  - cache_mean: Cache of the batch mean from the forward pass, of\n   *      shape (C, 1).  Note: This is used for performance during\n   *      training.\n   *  - cache_inv_var: Cache of the inverse variance from the forward pass,\n   *      of shape (C, 1).  Note: This is used for performance during\n   *      training.\n   *  - X: Input data matrix to the forward pass, of\n   *      shape (N, C*Hin*Win).\n   *  - gamma: Scale parameters, of shape (C, 1).\n   *  - C: Number of input channels (dimensionality of input depth).\n   *  - Hin: Input height.\n   *  - Win: Input width.\n   *  - epsilon: Smoothing term to avoid divide by zero errors.\n   *      Typical values are in the range of [1e-5, 1e-3].\n   *\n   * Outputs:\n   *  - dX: Gradient wrt `X`, of shape (N, C*Hin*Win).\n   *  - dgamma: Gradient wrt `W`, of shape (C, 1).\n   *  - dbeta: Gradient wrt `b`, of shape (C, 1).\n   *\n   */\n";
        return string;
    }

    public String backward__source() {
        String string = "backward = function(matrix[double] dout, \n                    matrix[double] cache_mean, matrix[double] cache_inv_var,\n                    matrix[double] X, matrix[double] gamma, \n                    int C, int Hin, int Win, double epsilon)\n      return (matrix[double] dX, matrix[double] dgamma, matrix[double] dbeta) {\n  /*\n   * Computes the backward pass for a 2D (spatial) batch normalization\n   * layer.\n   *\n   * Inputs:\n   *  - dout: Gradient wrt `out` from upstream, of shape (N, C*Hin*Win).\n   *  - cache_mean: Cache of the batch mean from the forward pass, of\n   *      shape (C, 1).  Note: This is used for performance during\n   *      training.\n   *  - cache_inv_var: Cache of the inverse variance from the forward pass,\n   *      of shape (C, 1).  Note: This is used for performance during\n   *      training.\n   *  - X: Input data matrix to the forward pass, of\n   *      shape (N, C*Hin*Win).\n   *  - gamma: Scale parameters, of shape (C, 1).\n   *  - C: Number of input channels (dimensionality of input depth).\n   *  - Hin: Input height.\n   *  - Win: Input width.\n   *  - epsilon: Smoothing term to avoid divide by zero errors.\n   *      Typical values are in the range of [1e-5, 1e-3].\n   *\n   * Outputs:\n   *  - dX: Gradient wrt `X`, of shape (N, C*Hin*Win).\n   *  - dgamma: Gradient wrt `W`, of shape (C, 1).\n   *  - dbeta: Gradient wrt `b`, of shape (C, 1).\n   *\n   */\n  # Compute gradients during training\n  dX = X; dgamma = gamma; dbeta = gamma;\n  [dX, dgamma, dbeta] = batch_norm2d_backward(X, dout, gamma, epsilon, cache_mean, cache_inv_var)\n}\n";
        return string;
    }
}

