/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.message.processors;

import java.util.Map;
import org.apache.synapse.SynapseException;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.message.processors.AbstractMessageProcessor;
import org.quartz.CronScheduleBuilder;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.StdSchedulerFactory;

public abstract class ScheduledMessageProcessor
extends AbstractMessageProcessor {
    public static final String SCHEDULED_MESSAGE_PROCESSOR_GROUP = "synapse.message.processor.quartz";
    public static final String PROCESSOR_INSTANCE = "processor.instance";
    protected Scheduler scheduler = null;
    protected long interval = 1000L;
    protected String quartzConfig = null;
    protected String cronExpression = null;
    protected State state = State.DESTROY;

    @Override
    public void start() {
        TriggerBuilder triggerBuilder = TriggerBuilder.newTrigger().withIdentity(this.name + "-trigger-");
        Trigger trigger = this.cronExpression == null || "".equals(this.cronExpression) ? triggerBuilder.withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withIntervalInMilliseconds(this.interval).repeatForever()).build() : triggerBuilder.withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)this.cronExpression)).build();
        JobBuilder jobBuilder = this.getJobBuilder();
        JobDataMap jobDataMap = this.getJobDataMap();
        jobDataMap.put("message.store", (Object)this.configuration.getMessageStore(this.messageStore));
        jobDataMap.put("parameters", (Object)this.parameters);
        JobDetail jobDetail = jobBuilder.usingJobData(jobDataMap).build();
        try {
            this.scheduler.scheduleJob(jobDetail, trigger);
        }
        catch (SchedulerException e) {
            throw new SynapseException("Error scheduling job : " + jobDetail + " with trigger " + trigger, e);
        }
    }

    @Override
    public void stop() {
        if (this.state == State.START) {
            try {
                if (this.scheduler != null && this.scheduler.isStarted()) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("ShuttingDown Message Processor Scheduler : " + this.scheduler.getMetaData()));
                    }
                    this.scheduler.standby();
                }
                this.state = State.STOP;
            }
            catch (SchedulerException e) {
                throw new SynapseException("Error ShuttingDown Message processor scheduler ", e);
            }
        }
    }

    @Override
    public void setParameters(Map<String, Object> parameters) {
        super.setParameters(parameters);
        if (parameters != null && !parameters.isEmpty()) {
            Object o = parameters.get("cronExpression");
            if (o != null) {
                this.cronExpression = o.toString();
            }
            if ((o = parameters.get("interval")) != null) {
                this.interval = Integer.parseInt(o.toString());
            }
            if ((o = parameters.get("quartz.conf")) != null) {
                this.quartzConfig = o.toString();
            }
        }
    }

    @Override
    public void init(SynapseEnvironment se) {
        super.init(se);
        StdSchedulerFactory sf = new StdSchedulerFactory();
        try {
            if (this.quartzConfig != null && !"".equals(this.quartzConfig)) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Initiating a Scheduler with configuration : " + this.quartzConfig));
                }
                sf.initialize(this.quartzConfig);
            }
        }
        catch (SchedulerException e) {
            throw new SynapseException("Error initiating scheduler factory " + sf + "with configuration loaded from " + this.quartzConfig, e);
        }
        try {
            this.scheduler = sf.getScheduler();
        }
        catch (SchedulerException e) {
            throw new SynapseException("Error getting a  scheduler instance form scheduler factory " + sf, e);
        }
        try {
            this.scheduler.start();
            this.state = State.INITIALIZED;
            this.start();
        }
        catch (SchedulerException e) {
            throw new SynapseException("Error starting the scheduler", e);
        }
    }

    protected abstract JobBuilder getJobBuilder();

    protected JobDataMap getJobDataMap() {
        return new JobDataMap();
    }

    @Override
    public void destroy() {
        try {
            this.scheduler.deleteJob(new JobKey(this.name + "-trigger", SCHEDULED_MESSAGE_PROCESSOR_GROUP));
            this.scheduler.shutdown(true);
        }
        catch (SchedulerException e) {
            this.log.error((Object)("Error while destroying the task " + (Object)((Object)e)));
        }
        this.state = State.DESTROY;
    }

    protected static enum State {
        INITIALIZED,
        START,
        STOP,
        DESTROY;

    }
}

