/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators.transaction;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.UserTransaction;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseException;
import org.apache.synapse.SynapseLog;
import org.apache.synapse.mediators.AbstractMediator;

public class TransactionMediator
extends AbstractMediator {
    public static final String ACTION_COMMIT = "commit";
    public static final String ACTION_ROLLBACK = "rollback";
    public static final String ACTION_NEW = "new";
    public static final String ACTION_USE_EXISTING_OR_NEW = "use-existing-or-new";
    public static final String ACTION_FAULT_IF_NO_TX = "fault-if-no-tx";
    private static final String USER_TX_LOOKUP_STR = "java:comp/UserTransaction";
    private Context txContext;
    private String action = "";

    @Override
    public boolean mediate(MessageContext synCtx) {
        UserTransaction tx = null;
        SynapseLog synLog = this.getLog(synCtx);
        if (synLog.isTraceOrDebugEnabled()) {
            synLog.traceOrDebug("Start : Transaction mediator (" + this.action + ")");
            if (synLog.isTraceTraceEnabled()) {
                synLog.traceTrace("Message : " + synCtx.getEnvelope());
            }
        }
        this.initContext(synCtx);
        try {
            tx = (UserTransaction)this.txContext.lookup(USER_TX_LOOKUP_STR);
        }
        catch (NamingException e) {
            this.handleException("Cloud not get the context name java:comp/UserTransaction", e, synCtx);
        }
        if (this.action.equals(ACTION_COMMIT)) {
            try {
                tx.commit();
            }
            catch (Exception e) {
                this.handleException("Unable to commit transaction", e, synCtx);
            }
        } else if (this.action.equals(ACTION_ROLLBACK)) {
            try {
                tx.rollback();
            }
            catch (Exception e) {
                this.handleException("Unable to rollback transaction", e, synCtx);
            }
        } else if (this.action.equals(ACTION_NEW)) {
            int status = 5;
            try {
                status = tx.getStatus();
            }
            catch (Exception e) {
                this.handleException("Unable to query transaction status", e, synCtx);
            }
            if (status != 6) {
                throw new SynapseException("Require to begin a new transaction, but a transaction already exist");
            }
            try {
                tx.begin();
            }
            catch (Exception e) {
                this.handleException("Unable to begin a new transaction", e, synCtx);
            }
        } else if (this.action.equals(ACTION_USE_EXISTING_OR_NEW)) {
            int status = 5;
            try {
                status = tx.getStatus();
            }
            catch (Exception e) {
                this.handleException("Unable to query transaction status", e, synCtx);
            }
            try {
                if (status == 6) {
                    tx.begin();
                }
            }
            catch (Exception e) {
                this.handleException("Unable to begin a new transaction", e, synCtx);
            }
        } else if (this.action.equals(ACTION_FAULT_IF_NO_TX)) {
            int status = 5;
            try {
                status = tx.getStatus();
            }
            catch (Exception e) {
                this.handleException("Unable to query transaction status", e, synCtx);
            }
            if (status != 0) {
                throw new SynapseException("No active transaction. Require an active transaction");
            }
        } else {
            this.handleException("Invalid transaction mediator action : " + this.action, synCtx);
        }
        if (synLog.isTraceOrDebugEnabled()) {
            synLog.traceOrDebug("End : Transaction mediator");
        }
        return true;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getAction() {
        return this.action;
    }

    private void initContext(MessageContext synCtx) {
        try {
            this.txContext = new InitialContext();
        }
        catch (NamingException e) {
            this.handleException("Cloud not create initial context", e, synCtx);
        }
    }

    @Override
    public boolean isContentAware() {
        return false;
    }
}

