/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.libraries.eip;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseException;
import org.apache.synapse.config.xml.AnonymousListMediator;
import org.apache.synapse.config.xml.SwitchCase;
import org.apache.synapse.libraries.eip.EIPUtils;
import org.apache.synapse.mediators.AbstractMediator;
import org.apache.synapse.mediators.Value;
import org.apache.synapse.mediators.base.SequenceMediator;
import org.apache.synapse.mediators.filters.SwitchMediator;
import org.apache.synapse.util.xpath.SynapseXPath;

public class ContentBasedRouterMediator
extends AbstractMediator {
    private static final String DELIMITER_1 = ";";
    private static final String DELIMITER_2 = ",";
    private static final String DELIMITER_3 = ":";

    @Override
    public boolean mediate(MessageContext messageContext) {
        SwitchMediator switchMediator = new SwitchMediator();
        this.initParams(messageContext, switchMediator);
        switchMediator.mediate(messageContext);
        return true;
    }

    private void initParams(MessageContext synCtx, SwitchMediator switchMediator) {
        Object sourceXpath = EIPUtils.lookupFunctionParam(synCtx, "routing_exp");
        if (sourceXpath == null) {
            String msg = "A 'source' XPath attribute is required for a switch mediator";
            this.log.error((Object)msg);
            throw new SynapseException(msg);
        }
        try {
            switchMediator.setSource((SynapseXPath)((Object)sourceXpath));
        }
        catch (Exception e) {
            String msg = "Invalid XPath for attribute 'source'";
            this.log.error((Object)msg);
            throw new SynapseException(msg);
        }
        String matchContent = (String)EIPUtils.lookupFunctionParam(synCtx, "match_content");
        String[] contentSet = matchContent.split(DELIMITER_1);
        if (contentSet.length == 1) {
            String caseItr = contentSet[0].trim();
            this.createCases(switchMediator, caseItr);
        } else if (contentSet.length == 2) {
            String caseItr = contentSet[0].trim();
            this.createCases(switchMediator, caseItr);
            String caseDefault = contentSet[1].trim();
            if (caseDefault == null || "".equals(caseDefault)) {
                String msg = "Default Sequence Reference is not defined";
                this.log.error((Object)msg);
            }
            AnonymousListMediator mediator = new AnonymousListMediator();
            SequenceMediator sequenceMediator = new SequenceMediator();
            Value value = new Value(caseDefault);
            sequenceMediator.setKey(value);
            mediator.addChild(sequenceMediator);
            SwitchCase defaultCase = new SwitchCase();
            defaultCase.setCaseMediator(mediator);
            switchMediator.setDefaultCase(defaultCase);
        } else {
            String msg = "Invalid match content";
            this.log.error((Object)msg);
        }
    }

    private boolean createCases(SwitchMediator switchMediator, String caseItr) {
        String[] caseSet = caseItr.split(DELIMITER_2);
        if (caseSet.length == 0) {
            this.log.warn((Object)"No Definitions found for dynamic routing");
            return false;
        }
        for (String newCase : caseSet) {
            if (newCase != null && !"".equals(newCase.trim())) {
                SwitchCase aCase = this.createCase(newCase.trim());
                switchMediator.addCase(aCase);
                continue;
            }
            String msg = "Sequence Reference has not defined";
            this.log.error((Object)msg);
        }
        return true;
    }

    private SwitchCase createCase(String caseConfig) {
        String msg;
        SwitchCase aCase = new SwitchCase();
        String[] caseAttr = caseConfig.split(DELIMITER_3);
        String regEx = null;
        String seqRef = null;
        if (caseAttr.length == 2) {
            regEx = caseAttr[0].trim();
            seqRef = caseAttr[1].trim();
        } else if (caseAttr.length == 1) {
            regEx = caseAttr[0].trim();
            seqRef = "main";
        } else {
            msg = "Unsupported routing condition";
            this.log.error((Object)msg);
        }
        if (regEx == null || "".equals(regEx.trim())) {
            msg = "The 'regex' attribute is required for a switch case definition";
            this.log.error((Object)msg);
            throw new SynapseException(msg);
        }
        try {
            aCase.setRegex(Pattern.compile(regEx));
        }
        catch (PatternSyntaxException pse) {
            String msg2 = "Invalid Regular Expression for attribute 'regex' : " + regEx;
            this.log.error((Object)msg2);
            throw new SynapseException(msg2);
        }
        if (seqRef == null || "".equals(seqRef.trim())) {
            msg = "Sequence Reference has not defined";
            this.log.error((Object)msg);
        }
        AnonymousListMediator mediator = new AnonymousListMediator();
        SequenceMediator sequenceMediator = new SequenceMediator();
        Value value = new Value(seqRef);
        sequenceMediator.setKey(value);
        mediator.addChild(sequenceMediator);
        aCase.setCaseMediator(mediator);
        return aCase;
    }
}

