/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.views.jasperreports7;

import java.util.Iterator;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts2.util.MakeIterator;
import org.apache.struts2.util.ValueStack;

public class ValueStackDataSource
implements JRRewindableDataSource {
    private static final Logger LOG = LogManager.getLogger(ValueStackDataSource.class);
    private final ValueStack valueStack;
    private final String dataSource;
    private final boolean wrapField;
    private Iterator<?> iterator;
    private boolean firstTimeThrough = true;

    public ValueStackDataSource(ValueStack valueStack, String dataSourceParam, boolean wrapField) {
        this.valueStack = valueStack;
        this.dataSource = dataSourceParam;
        this.wrapField = wrapField;
        Object dataSourceValue = valueStack.findValue(this.dataSource);
        if (dataSourceValue != null) {
            if (MakeIterator.isIterable((Object)dataSourceValue)) {
                this.iterator = MakeIterator.convert((Object)dataSourceValue);
            } else {
                Object[] array = new Object[]{dataSourceValue};
                this.iterator = MakeIterator.convert((Object)array);
            }
        } else {
            LOG.warn("Data source value for data source: {} was null", (Object)this.dataSource);
        }
    }

    public Object getFieldValue(JRField field) {
        String expression = field.getName();
        Object value = this.valueStack.findValue(expression);
        LOG.debug("Field [{}] = [{}]", (Object)field.getName(), value);
        if (!this.wrapField && MakeIterator.isIterable((Object)value) && field.getValueClass().isInstance(value)) {
            return value;
        }
        if (MakeIterator.isIterable((Object)value)) {
            return new ValueStackDataSource(this.valueStack, expression, this.wrapField);
        }
        return value;
    }

    public void moveFirst() {
        Object dataSourceValue = this.valueStack.findValue(this.dataSource);
        if (dataSourceValue != null) {
            if (MakeIterator.isIterable((Object)dataSourceValue)) {
                this.iterator = MakeIterator.convert((Object)dataSourceValue);
            } else {
                Object[] array = new Object[]{dataSourceValue};
                this.iterator = MakeIterator.convert((Object)array);
            }
        } else {
            LOG.warn("Data source value for data source [{}] was null", (Object)this.dataSource);
        }
    }

    public boolean next() throws JRException {
        if (this.firstTimeThrough) {
            this.firstTimeThrough = false;
        } else {
            this.valueStack.pop();
        }
        if (this.iterator != null && this.iterator.hasNext()) {
            this.valueStack.push(this.iterator.next());
            if (LOG.isDebugEnabled()) {
                LOG.debug("Pushed next value: {}", this.valueStack.findValue("."));
            }
            return true;
        }
        LOG.debug("No more values");
        return false;
    }
}

