/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.compiler.parser;

import com.google.gxp.com.google.common.collect.Maps;
import com.google.gxp.compiler.alerts.AlertSink;
import com.google.gxp.compiler.alerts.SourcePosition;
import com.google.gxp.compiler.parser.CppNamespace;
import com.google.gxp.compiler.parser.ExprNamespace;
import com.google.gxp.compiler.parser.GxpNamespace;
import com.google.gxp.compiler.parser.JavaNamespace;
import com.google.gxp.compiler.parser.JavaScriptNamespace;
import com.google.gxp.compiler.parser.MsgNamespace;
import com.google.gxp.compiler.parser.Namespace;
import com.google.gxp.compiler.parser.NoMsgNamespace;
import com.google.gxp.compiler.parser.NoNamespaceError;
import com.google.gxp.compiler.parser.OutputNamespace;
import com.google.gxp.compiler.parser.QualifiedCallNamespace;
import com.google.gxp.compiler.parser.UnknownNamespaceError;
import com.google.gxp.compiler.parser.UnqualifiedCallNamespace;
import com.google.gxp.compiler.schema.Schema;
import com.google.gxp.compiler.schema.SchemaFactory;
import java.util.Map;

final class NamespaceSet {
    private Map<String, Namespace> exactMappings = Maps.newHashMap();
    private final SchemaFactory schemaFactory;

    public NamespaceSet(SchemaFactory schemaFactory) {
        for (Namespace ns : new Namespace[]{GxpNamespace.INSTANCE, UnqualifiedCallNamespace.INSTANCE, ExprNamespace.INSTANCE, CppNamespace.INSTANCE, JavaNamespace.INSTANCE, JavaScriptNamespace.INSTANCE, MsgNamespace.INSTANCE, NoMsgNamespace.INSTANCE}) {
            this.exactMappings.put(ns.getUri(), ns);
        }
        this.schemaFactory = schemaFactory;
    }

    public Namespace get(AlertSink alertSink, SourcePosition sourcePosition, String nsUri) {
        Schema schema;
        if (nsUri == null || nsUri.equals("")) {
            alertSink.add(new NoNamespaceError(sourcePosition));
            return null;
        }
        Namespace result = this.exactMappings.get(nsUri);
        if (result == null && nsUri.startsWith("http://google.com/2001/gxp/call/")) {
            result = new QualifiedCallNamespace(nsUri);
            this.exactMappings.put(result.getUri(), result);
        }
        if (result == null && (schema = this.schemaFactory.fromNamespaceUri(nsUri)) != null) {
            result = new OutputNamespace(schema);
            this.exactMappings.put(result.getUri(), result);
        }
        if (result == null) {
            alertSink.add(new UnknownNamespaceError(sourcePosition, nsUri));
        }
        return result;
    }
}

