/*
 * Decompiled with CFR 0.152.
 */
package net.sf.oval.constraint;

import java.text.DateFormat;
import java.text.ParseException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Date;
import net.sf.oval.ConstraintTarget;
import net.sf.oval.Validator;
import net.sf.oval.configuration.annotation.AbstractAnnotationCheck;
import net.sf.oval.constraint.Future;
import net.sf.oval.context.OValContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FutureCheck
extends AbstractAnnotationCheck<Future> {
    private static final long serialVersionUID = 1L;
    private static final boolean IS_JAVA_TIME_API_AVAILABLE;
    private long tolerance;

    static {
        boolean hasJavaTimeAPI = false;
        try {
            LocalDate.class.getName();
            hasJavaTimeAPI = true;
        }
        catch (LinkageError linkageError) {}
        IS_JAVA_TIME_API_AVAILABLE = hasJavaTimeAPI;
    }

    @Override
    public void configure(Future constraintAnnotation) {
        super.configure(constraintAnnotation);
        this.setTolerance(constraintAnnotation.tolerance());
    }

    @Override
    protected ConstraintTarget[] getAppliesToDefault() {
        return new ConstraintTarget[]{ConstraintTarget.VALUES};
    }

    public long getTolerance() {
        return this.tolerance;
    }

    private Boolean isJavaTimeSatisfied(long now, Object valueToValidate) {
        if (valueToValidate instanceof LocalDate) {
            if (((LocalDate)valueToValidate).atStartOfDay().atZone(ZoneId.systemDefault()).toInstant().toEpochMilli() > now) {
                return true;
            }
            return false;
        }
        if (valueToValidate instanceof LocalTime) {
            if (((LocalTime)valueToValidate).atDate(LocalDate.now()).atZone(ZoneId.systemDefault()).toInstant().toEpochMilli() > now) {
                return true;
            }
            return false;
        }
        if (valueToValidate instanceof LocalDateTime) {
            if (((LocalDateTime)valueToValidate).atZone(ZoneId.systemDefault()).toInstant().toEpochMilli() > now) {
                return true;
            }
            return false;
        }
        if (valueToValidate instanceof OffsetTime) {
            if (((OffsetTime)valueToValidate).atDate(LocalDate.now()).toInstant().toEpochMilli() > now) {
                return true;
            }
            return false;
        }
        if (valueToValidate instanceof OffsetDateTime) {
            if (((OffsetDateTime)valueToValidate).toInstant().toEpochMilli() > now) {
                return true;
            }
            return false;
        }
        if (valueToValidate instanceof ZonedDateTime) {
            if (((ZonedDateTime)valueToValidate).toInstant().toEpochMilli() > now) {
                return true;
            }
            return false;
        }
        return null;
    }

    @Override
    public boolean isSatisfied(Object validatedObject, Object valueToValidate, OValContext context, Validator validator) {
        Boolean result;
        if (valueToValidate == null) {
            return true;
        }
        long now = System.currentTimeMillis() - this.tolerance;
        if (valueToValidate instanceof Date) {
            return ((Date)valueToValidate).getTime() > now;
        }
        if (valueToValidate instanceof Calendar) {
            return ((Calendar)valueToValidate).getTime().getTime() > now;
        }
        if (IS_JAVA_TIME_API_AVAILABLE && (result = this.isJavaTimeSatisfied(now, valueToValidate)) != null) {
            return result;
        }
        String stringValue = valueToValidate.toString();
        try {
            return DateFormat.getDateTimeInstance().parse(stringValue).getTime() > now;
        }
        catch (ParseException parseException) {
            return false;
        }
    }

    public void setTolerance(long tolerance) {
        this.tolerance = tolerance;
    }
}

