/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.health;

import io.dropwizard.health.ShutdownNotifier;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.thread.ShutdownThread;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelayedShutdownHandler
extends AbstractLifeCycle {
    private static final Logger LOGGER = LoggerFactory.getLogger(DelayedShutdownHandler.class);
    private final ShutdownNotifier shutdownNotifier;

    public DelayedShutdownHandler(ShutdownNotifier shutdownNotifier) {
        this.shutdownNotifier = shutdownNotifier;
    }

    public void register() {
        try {
            this.start();
            ShutdownThread.register((int)0, (LifeCycle[])new LifeCycle[]{this});
        }
        catch (Exception e) {
            LOGGER.error("failed setting up delayed shutdown handler", (Throwable)e);
            throw new IllegalStateException("failed setting up delayed shutdown handler", e);
        }
    }

    protected void doStop() throws Exception {
        this.shutdownNotifier.notifyShutdownStarted();
    }
}

