/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.access.jetty;

import ch.qos.logback.access.common.spi.ServerAdapter;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;

public class JettyServerAdapter
implements ServerAdapter {
    Request request;
    Response response;

    public JettyServerAdapter(Request jettyRequest, Response jettyResponse) {
        this.request = jettyRequest;
        this.response = jettyResponse;
    }

    public long getContentLength() {
        return Response.getContentBytesWritten((Response)this.response);
    }

    public int getStatusCode() {
        return this.response.getStatus();
    }

    public long getRequestTimestamp() {
        return Request.getTimeStamp((Request)this.request);
    }

    public Map<String, String> buildResponseHeaderMap() {
        HashMap<String, String> responseHeaderMap = new HashMap<String, String>();
        HttpFields.Mutable httpFields = this.response.getHeaders();
        for (HttpField field : httpFields) {
            String key = field.getName();
            String value = field.getValue();
            responseHeaderMap.put(key, value);
        }
        return responseHeaderMap;
    }
}

