/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.scheduler.resource.strategies.priority;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.storm.scheduler.ISchedulingState;
import org.apache.storm.scheduler.TopologyDetails;
import org.apache.storm.scheduler.resource.User;
import org.apache.storm.scheduler.resource.strategies.priority.DefaultSchedulingPriorityStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericResourceAwareSchedulingPriorityStrategy
extends DefaultSchedulingPriorityStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(GenericResourceAwareSchedulingPriorityStrategy.class);

    @Override
    protected GrasSimulatedUser getSimulatedUserFor(User u, ISchedulingState cluster) {
        return new GrasSimulatedUser(u, cluster);
    }

    @Override
    public List<TopologyDetails> getOrderedTopologies(ISchedulingState cluster, Map<String, User> userMap) {
        double cpuAvail = cluster.getClusterTotalCpuResource();
        double memAvail = cluster.getClusterTotalMemoryResource();
        Map<String, Double> genericAvail = cluster.getClusterTotalGenericResources();
        ArrayList<TopologyDetails> allUserTopologies = new ArrayList<TopologyDetails>();
        ArrayList<GrasSimulatedUser> users = new ArrayList<GrasSimulatedUser>();
        for (User u : userMap.values()) {
            users.add(this.getSimulatedUserFor(u, cluster));
        }
        while (!users.isEmpty()) {
            Collections.sort(users, new GrasSimulatedUserComparator(cpuAvail, memAvail, genericAvail));
            GrasSimulatedUser u = (GrasSimulatedUser)users.get(0);
            TopologyDetails td = u.getNextHighest();
            if (td == null) {
                users.remove(0);
                continue;
            }
            double score = u.getScore(cpuAvail, memAvail, genericAvail);
            td = u.simScheduleNextHighest();
            LOG.info("GRAS SIM Scheduling {} with score of {}", (Object)td.getId(), (Object)score);
            cpuAvail -= td.getTotalRequestedCpu();
            memAvail -= td.getTotalRequestedMemOffHeap() + td.getTotalRequestedMemOnHeap();
            for (Map.Entry<String, Double> entry : td.getTotalRequestedGenericResources().entrySet()) {
                String resource = entry.getKey();
                Double requestedAmount = entry.getValue();
                if (!genericAvail.containsKey(resource)) {
                    LOG.warn("Resource: {} is not supported in this cluster. Ignoring this request.", (Object)resource);
                    continue;
                }
                genericAvail.put(resource, genericAvail.get(resource) - requestedAmount);
            }
            allUserTopologies.add(td);
        }
        return allUserTopologies;
    }

    protected static class GrasSimulatedUser
    extends DefaultSchedulingPriorityStrategy.SimulatedUser {
        public final Map<String, Double> guaranteedGenericResources;
        private Map<String, Double> assignedGenericResources = new HashMap<String, Double>();

        public GrasSimulatedUser(User other, ISchedulingState cluster) {
            super(other, cluster);
            HashMap<String, Double> guaranteedGenericResources = new HashMap<String, Double>();
            Set<String> availGenericResourceTypes = cluster.getClusterTotalGenericResources().keySet();
            for (String resourceType : availGenericResourceTypes) {
                Double guaranteedAmount = other.getGenericGuaranteed().getOrDefault(resourceType, 0.0);
                guaranteedGenericResources.put(resourceType, guaranteedAmount);
            }
            this.guaranteedGenericResources = guaranteedGenericResources;
        }

        @Override
        public TopologyDetails simScheduleNextHighest() {
            TopologyDetails td = super.simScheduleNextHighest();
            Map<String, Double> tdRequestedGenericResource = td.getTotalRequestedGenericResources();
            for (Map.Entry<String, Double> entry : tdRequestedGenericResource.entrySet()) {
                String resource = entry.getKey();
                Double requestedAmount = entry.getValue();
                this.assignedGenericResources.put(resource, this.assignedGenericResources.getOrDefault(resource, 0.0) + requestedAmount);
            }
            return td;
        }

        protected double getScore(double availableCpu, double availableMemory, Map<String, Double> availableGenericResources, TopologyDetails td) {
            double ret = super.getScore(availableCpu, availableMemory, td);
            if (ret == Double.MAX_VALUE) {
                return ret;
            }
            Map<String, Double> tdTotalRequestedGeneric = td.getTotalRequestedGenericResources();
            if (tdTotalRequestedGeneric == null) {
                tdTotalRequestedGeneric = Collections.emptyMap();
            }
            for (Map.Entry<String, Double> entry : availableGenericResources.entrySet()) {
                String resource = entry.getKey();
                Double available = entry.getValue();
                if (available <= 0.0) {
                    return Double.MAX_VALUE;
                }
                Double wouldBeResource = this.assignedGenericResources.getOrDefault(resource, 0.0) + tdTotalRequestedGeneric.getOrDefault(resource, 0.0);
                double thisScore = (wouldBeResource - this.guaranteedGenericResources.getOrDefault(resource, 0.0)) / available;
                ret = Math.max(ret, thisScore);
            }
            return ret;
        }

        protected double getScore(double availableCpu, double availableMemory, Map<String, Double> availableGenericResources) {
            return this.getScore(availableCpu, availableMemory, availableGenericResources, this.getNextHighest());
        }
    }

    private static class GrasSimulatedUserComparator
    implements Comparator<GrasSimulatedUser> {
        private final double cpuAvail;
        private final double memAvail;
        private final Map<String, Double> genericAvail;

        private GrasSimulatedUserComparator(double cpuAvail, double memAvail, Map<String, Double> genericAvail) {
            this.cpuAvail = cpuAvail;
            this.memAvail = memAvail;
            this.genericAvail = genericAvail;
        }

        @Override
        public int compare(GrasSimulatedUser o1, GrasSimulatedUser o2) {
            return Double.compare(o1.getScore(this.cpuAvail, this.memAvail, this.genericAvail), o2.getScore(this.cpuAvail, this.memAvail, this.genericAvail));
        }
    }
}

