/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.logical.LogicalFilter;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;

public final class FilterRemoveIsNotDistinctFromRule
extends RelOptRule {
    public static final FilterRemoveIsNotDistinctFromRule INSTANCE = new FilterRemoveIsNotDistinctFromRule();

    private FilterRemoveIsNotDistinctFromRule() {
        super(FilterRemoveIsNotDistinctFromRule.operand(LogicalFilter.class, FilterRemoveIsNotDistinctFromRule.any()));
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        LogicalFilter oldFilter = (LogicalFilter)call.rel(0);
        RexNode oldFilterCond = oldFilter.getCondition();
        if (RexUtil.findOperatorCall(SqlStdOperatorTable.IS_NOT_DISTINCT_FROM, oldFilterCond) == null) {
            return;
        }
        RemoveIsNotDistinctFromRexShuttle rewriteShuttle = new RemoveIsNotDistinctFromRexShuttle(oldFilter.getCluster().getRexBuilder());
        RelFactories.FilterFactory factory = RelFactories.DEFAULT_FILTER_FACTORY;
        RelNode newFilterRel = factory.createFilter(oldFilter.getInput(), oldFilterCond.accept(rewriteShuttle));
        call.transformTo(newFilterRel);
    }

    private class RemoveIsNotDistinctFromRexShuttle
    extends RexShuttle {
        RexBuilder rexBuilder;

        public RemoveIsNotDistinctFromRexShuttle(RexBuilder rexBuilder) {
            this.rexBuilder = rexBuilder;
        }

        @Override
        public RexNode visitCall(RexCall call) {
            RexNode newCall = super.visitCall(call);
            if (call.getOperator() == SqlStdOperatorTable.IS_NOT_DISTINCT_FROM) {
                RexCall tmpCall = (RexCall)newCall;
                newCall = RelOptUtil.isDistinctFrom(this.rexBuilder, (RexNode)tmpCall.operands.get(0), (RexNode)tmpCall.operands.get(1), true);
            }
            return newCall;
        }
    }
}

