/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.maven.slingstart;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.sling.maven.slingstart.AbstractSlingStartMojo;
import org.apache.sling.maven.slingstart.ModelUtils;
import org.apache.sling.maven.slingstart.PomArtifactVersionResolver;
import org.apache.sling.maven.slingstart.PomVariableResolver;
import org.apache.sling.maven.slingstart.ProjectHelper;
import org.apache.sling.provisioning.model.Artifact;
import org.apache.sling.provisioning.model.Model;
import org.apache.sling.provisioning.model.ModelUtility;
import org.apache.sling.provisioning.model.io.ModelArchiveWriter;

@Mojo(name="attach-modelarchive", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.TEST, threadSafe=true)
public class AttachModelArchive
extends AbstractSlingStartMojo {
    @Parameter(defaultValue="${project.build.finalName}")
    private String modelArchiveName;
    @Component
    private ArtifactHandlerManager artifactHandlerManager;
    @Component
    private ArtifactResolver resolver;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Model model = ProjectHelper.getRawModel(this.project);
        if (this.usePomVariables) {
            model = ModelUtility.applyVariables((Model)model, (ModelUtility.VariableResolver)new PomVariableResolver(this.project));
        }
        if (this.usePomDependencies) {
            model = ModelUtility.applyArtifactVersions((Model)model, (ModelUtility.ArtifactVersionResolver)new PomArtifactVersionResolver(this.project, this.allowUnresolvedPomDependencies));
        }
        File outputFile = new File(this.project.getBuild().getDirectory() + File.separatorChar + this.modelArchiveName + "." + "mar");
        outputFile.getParentFile().mkdirs();
        try (FileOutputStream fos = new FileOutputStream(outputFile);){
            JarOutputStream jos = ModelArchiveWriter.write((OutputStream)fos, (Model)model, null, (ModelArchiveWriter.ArtifactProvider)new ModelArchiveWriter.ArtifactProvider(){

                public InputStream getInputStream(Artifact artifact) throws IOException {
                    try {
                        org.apache.maven.artifact.Artifact a = ModelUtils.getArtifact(AttachModelArchive.this.project, AttachModelArchive.this.mavenSession, AttachModelArchive.this.artifactHandlerManager, AttachModelArchive.this.resolver, artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getType(), artifact.getClassifier());
                        return new FileInputStream(a.getFile());
                    }
                    catch (MojoExecutionException e) {
                        throw (IOException)new IOException("Unable to get artifact: " + artifact.toMvnUrl()).initCause(e);
                    }
                }
            });
            File classesDir = new File(this.project.getBuild().getOutputDirectory());
            if (classesDir.exists()) {
                File metaInfDir = new File(classesDir, "META-INF");
                for (String name : new String[]{"LICENSE", "NOTICE", "DEPENDENCIES"}) {
                    File f = new File(metaInfDir, name);
                    if (!f.exists()) continue;
                    JarEntry artifactEntry = new JarEntry("META-INF/" + name);
                    jos.putNextEntry(artifactEntry);
                    byte[] buffer = new byte[8192];
                    try (FileInputStream is = new FileInputStream(f);){
                        int l = 0;
                        while ((l = ((InputStream)is).read(buffer)) > 0) {
                            jos.write(buffer, 0, l);
                        }
                    }
                    jos.closeEntry();
                }
            }
            jos.finish();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to write model archive to " + outputFile + " : " + e.getMessage(), (Exception)e);
        }
        this.projectHelper.attachArtifact(this.project, "mar", "mar", outputFile);
    }
}

