/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.maven.kickstart.run;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.codehaus.plexus.util.FileUtils;

public class KickstartEnvironment {
    public static final String WORK_DIR_NAME = "sling";
    private final File kickstartJar;
    private final boolean cleanWorkingDirectory;
    private final boolean shutdownOnExit;
    private final int readyTimeOutSec;
    private final String debug;

    public KickstartEnvironment(File kickstartJar, boolean cleanWorkingDirectory, boolean shutdownOnExit, int readyTimeOutSec, String debug) {
        this.kickstartJar = kickstartJar;
        this.cleanWorkingDirectory = cleanWorkingDirectory;
        this.shutdownOnExit = shutdownOnExit;
        this.readyTimeOutSec = readyTimeOutSec;
        this.debug = debug;
    }

    public boolean isShutdownOnExit() {
        return this.shutdownOnExit;
    }

    public int getReadyTimeOutSec() {
        return this.readyTimeOutSec;
    }

    private void ensureFolderExists(File folder) {
        if (!folder.exists()) {
            folder.mkdirs();
        }
        if (this.cleanWorkingDirectory) {
            File work = new File(folder, WORK_DIR_NAME);
            org.apache.commons.io.FileUtils.deleteQuietly((File)work);
        }
    }

    private File installKickstart(File folder) throws IOException {
        if (this.kickstartJar.getParentFile().getAbsolutePath().equals(folder.getAbsolutePath())) {
            return this.kickstartJar;
        }
        try {
            FileUtils.copyFileToDirectory((File)this.kickstartJar, (File)folder);
            return new File(folder, this.kickstartJar.getName());
        }
        catch (IOException ioe) {
            throw new IOException("Unable to copy " + this.kickstartJar + " to " + folder, ioe);
        }
    }

    private void installLauncher(File folder) throws IOException {
        File binDir = new File(folder, "bin");
        this.copyResource("org/apache/sling/maven/kickstart/launcher/Main.class", binDir);
    }

    public File prepare(File folder) throws IOException {
        this.ensureFolderExists(folder);
        File kickstart = this.installKickstart(folder);
        this.installLauncher(folder);
        return kickstart;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyResource(String resource, File dir) throws IOException {
        File baseDir;
        int lastSlash = resource.lastIndexOf(47);
        if (lastSlash > 0) {
            String filePath = resource.substring(0, lastSlash).replace('/', File.separatorChar);
            baseDir = new File(dir, filePath);
        } else {
            baseDir = dir;
        }
        baseDir.mkdirs();
        File file = new File(baseDir, resource.substring(lastSlash + 1));
        InputStream is = KickstartEnvironment.class.getClassLoader().getResourceAsStream(resource);
        if (is == null) {
            throw new IOException("Resource not found: " + resource);
        }
        FileOutputStream fos = new FileOutputStream(file);
        byte[] buffer = new byte[2048];
        try {
            int l;
            while ((l = is.read(buffer)) > 0) {
                fos.write(buffer, 0, l);
            }
        }
        finally {
            if (fos != null) {
                fos.close();
            }
            if (is != null) {
                is.close();
            }
        }
    }

    public String getDebug() {
        return this.debug;
    }
}

