/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cpconverter.maven.mojos;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.DefaultArtifactHandler;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.RepositoryException;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResult;

public class ContentPackage {
    private String groupId = "";
    private String artifactId = "";
    private List<String> types = new ArrayList<String>(Arrays.asList("zip"));
    private String classifier = "";
    private boolean excludeTransitive;
    private boolean moduleIsContentPackage;

    public void setGroupId(String groupId) {
        this.groupId = groupId == null ? "" : groupId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId == null ? "" : artifactId;
    }

    public void setExcludeTransitive(boolean excludeTransitive) {
        this.excludeTransitive = excludeTransitive;
    }

    public boolean isExcludeTransitive() {
        return this.excludeTransitive;
    }

    public void setModuleIsContentPackage(boolean moduleIsContentPackage) {
        this.moduleIsContentPackage = moduleIsContentPackage;
        if (this.moduleIsContentPackage) {
            this.types.add("content-package");
        } else {
            this.types.remove("content-package");
        }
    }

    public boolean isModuleIsContentPackage() {
        return this.moduleIsContentPackage;
    }

    Collection<org.apache.maven.artifact.Artifact> getMatchingArtifacts(MavenProject project, RepositorySystem repoSystem, RepositorySystemSession repoSession, List<RemoteRepository> remoteRepos) {
        Set artifacts = this.excludeTransitive ? project.getDependencyArtifacts() : project.getArtifacts();
        HashSet<org.apache.maven.artifact.Artifact> fileArtifacts = new HashSet<org.apache.maven.artifact.Artifact>();
        for (org.apache.maven.artifact.Artifact a : artifacts) {
            if (a.getFile() != null) {
                fileArtifacts.add(a);
                continue;
            }
            if (repoSystem == null || repoSession == null) continue;
            org.apache.maven.artifact.Artifact fileArt = this.resolveArtifact(repoSystem, repoSession, remoteRepos, a);
            if (fileArt != null) {
                fileArtifacts.add(fileArt);
                continue;
            }
            throw new RuntimeException("Unable to resolve artifact: " + a);
        }
        if (this.moduleIsContentPackage) {
            org.apache.maven.artifact.Artifact projectArtifact = project.getArtifact();
            System.out.println("Project Artifact: " + projectArtifact);
            fileArtifacts.add(projectArtifact);
        }
        return this.getMatchingArtifacts(fileArtifacts);
    }

    private org.apache.maven.artifact.Artifact resolveArtifact(RepositorySystem repoSystem, RepositorySystemSession repoSession, List<RemoteRepository> remoteRepos, org.apache.maven.artifact.Artifact artifact) {
        try {
            DefaultArtifact a = new DefaultArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getClassifier(), artifact.getType(), artifact.getVersion());
            ArtifactRequest req = new ArtifactRequest((Artifact)a, remoteRepos, null);
            ArtifactResult res = repoSystem.resolveArtifact(repoSession, req);
            if (res.isResolved()) {
                Artifact aetherArt = res.getArtifact();
                org.apache.maven.artifact.DefaultArtifact mavenArt = new org.apache.maven.artifact.DefaultArtifact(aetherArt.getGroupId(), aetherArt.getArtifactId(), aetherArt.getVersion(), null, aetherArt.getExtension(), aetherArt.getClassifier(), (ArtifactHandler)new DefaultArtifactHandler());
                mavenArt.setFile(aetherArt.getFile());
                return mavenArt;
            }
            return null;
        }
        catch (RepositoryException e) {
            throw new RuntimeException(e);
        }
    }

    public Collection<org.apache.maven.artifact.Artifact> getMatchingArtifacts(Collection<org.apache.maven.artifact.Artifact> artifacts) {
        ArrayList<org.apache.maven.artifact.Artifact> matches = new ArrayList<org.apache.maven.artifact.Artifact>();
        for (org.apache.maven.artifact.Artifact artifact : artifacts) {
            System.out.println("Check Artifact: " + artifact);
            System.out.println("Check Artifact Group: " + artifact.getGroupId());
            System.out.println("Check Artifact Artifact: " + artifact.getArtifactId());
            System.out.println("Check Artifact Type: " + artifact.getType());
            System.out.println("Check Artifact Classifier: " + artifact.getClassifier());
            if (!this.groupId.equals(artifact.getGroupId()) || !this.artifactId.equals(artifact.getArtifactId()) || !this.types.contains(artifact.getType()) || !this.classifier.equals(artifact.getClassifier()) && (!this.classifier.equals("") || artifact.getClassifier() != null)) continue;
            matches.add(artifact);
        }
        return matches;
    }

    @Nonnull
    public StringBuilder toString(@Nullable StringBuilder builder) {
        if (builder == null) {
            builder = new StringBuilder();
        }
        builder.append("groupId=").append(this.groupId).append(",");
        builder.append("artifactId=").append(this.artifactId).append(",");
        if (this.types != null) {
            builder.append("type='").append(this.types).append("',");
        }
        if (this.classifier != null) {
            builder.append("classifier=").append(this.classifier).append(",");
        }
        builder.append(",excludeTransitive=").append(this.excludeTransitive);
        return builder;
    }

    public String toString() {
        return this.toString(null).toString();
    }
}

