/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils.locale;

import java.lang.reflect.Array;
import java.util.Locale;
import org.apache.commons.beanutils.locale.LocaleBeanUtilsBean;
import org.apache.commons.beanutils.locale.LocaleConverter;
import org.apache.commons.beanutils.locale.converters.BigDecimalLocaleConverter;
import org.apache.commons.beanutils.locale.converters.BigIntegerLocaleConverter;
import org.apache.commons.beanutils.locale.converters.ByteLocaleConverter;
import org.apache.commons.beanutils.locale.converters.DoubleLocaleConverter;
import org.apache.commons.beanutils.locale.converters.FloatLocaleConverter;
import org.apache.commons.beanutils.locale.converters.IntegerLocaleConverter;
import org.apache.commons.beanutils.locale.converters.LongLocaleConverter;
import org.apache.commons.beanutils.locale.converters.ShortLocaleConverter;
import org.apache.commons.beanutils.locale.converters.SqlDateLocaleConverter;
import org.apache.commons.beanutils.locale.converters.SqlTimeLocaleConverter;
import org.apache.commons.beanutils.locale.converters.SqlTimestampLocaleConverter;
import org.apache.commons.beanutils.locale.converters.StringLocaleConverter;
import org.apache.commons.collections.FastHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LocaleConvertUtilsBean {
    private Locale defaultLocale = Locale.getDefault();
    private boolean applyLocalized = false;
    private Log log = LogFactory.getLog((Class)(class$org$apache$commons$beanutils$locale$LocaleConvertUtils == null ? (class$org$apache$commons$beanutils$locale$LocaleConvertUtils = LocaleConvertUtilsBean.class$("org.apache.commons.beanutils.locale.LocaleConvertUtils")) : class$org$apache$commons$beanutils$locale$LocaleConvertUtils));
    private FastHashMap mapConverters = new FastHashMap();
    static /* synthetic */ Class class$org$apache$commons$beanutils$locale$LocaleConvertUtils;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$math$BigInteger;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$sql$Date;
    static /* synthetic */ Class class$java$sql$Time;
    static /* synthetic */ Class class$java$sql$Timestamp;

    public static LocaleConvertUtilsBean getInstance() {
        return LocaleBeanUtilsBean.getLocaleBeanUtilsInstance().getLocaleConvertUtils();
    }

    public LocaleConvertUtilsBean() {
        this.deregister();
    }

    public Locale getDefaultLocale() {
        return this.defaultLocale;
    }

    public void setDefaultLocale(Locale locale) {
        this.defaultLocale = locale == null ? Locale.getDefault() : locale;
    }

    public boolean getApplyLocalized() {
        return this.applyLocalized;
    }

    public void setApplyLocalized(boolean newApplyLocalized) {
        this.applyLocalized = newApplyLocalized;
    }

    public String convert(Object value) {
        return this.convert(value, this.defaultLocale, null);
    }

    public String convert(Object value, String pattern) {
        return this.convert(value, this.defaultLocale, pattern);
    }

    public String convert(Object value, Locale locale, String pattern) {
        LocaleConverter converter = this.lookup(class$java$lang$String == null ? (class$java$lang$String = LocaleConvertUtilsBean.class$("java.lang.String")) : class$java$lang$String, locale);
        return (String)converter.convert(class$java$lang$String == null ? (class$java$lang$String = LocaleConvertUtilsBean.class$("java.lang.String")) : class$java$lang$String, value, pattern);
    }

    public Object convert(String value, Class clazz) {
        return this.convert(value, clazz, this.defaultLocale, null);
    }

    public Object convert(String value, Class clazz, String pattern) {
        return this.convert(value, clazz, this.defaultLocale, pattern);
    }

    public Object convert(String value, Class clazz, Locale locale, String pattern) {
        LocaleConverter converter;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Convert string " + value + " to class " + clazz.getName() + " using " + locale.toString() + " locale and " + pattern + " pattern"));
        }
        if ((converter = this.lookup(clazz, locale)) == null) {
            converter = this.lookup(class$java$lang$String == null ? (class$java$lang$String = LocaleConvertUtilsBean.class$("java.lang.String")) : class$java$lang$String, locale);
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("  Using converter " + converter));
        }
        return converter.convert(clazz, value, pattern);
    }

    public Object convert(String[] values, Class clazz, String pattern) {
        return this.convert(values, clazz, this.getDefaultLocale(), pattern);
    }

    public Object convert(String[] values, Class clazz) {
        return this.convert(values, clazz, this.getDefaultLocale(), null);
    }

    public Object convert(String[] values, Class clazz, Locale locale, String pattern) {
        Class<?> type = clazz;
        if (clazz.isArray()) {
            type = clazz.getComponentType();
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Convert String[" + values.length + "] to class " + type.getName() + "[] using " + locale.toString() + " locale and " + pattern + " pattern"));
        }
        Object array = Array.newInstance(type, values.length);
        int i = 0;
        while (i < values.length) {
            Array.set(array, i, this.convert(values[i], type, locale, pattern));
            ++i;
        }
        return array;
    }

    public void register(LocaleConverter converter, Class clazz, Locale locale) {
        this.lookup(locale).put((Object)clazz, (Object)converter);
    }

    public void deregister() {
        FastHashMap defaultConverter = this.lookup(this.defaultLocale);
        this.mapConverters.setFast(false);
        this.mapConverters.clear();
        this.mapConverters.put((Object)this.defaultLocale, (Object)defaultConverter);
        this.mapConverters.setFast(true);
    }

    public void deregister(Locale locale) {
        this.mapConverters.remove((Object)locale);
    }

    public void deregister(Class clazz, Locale locale) {
        this.lookup(locale).remove((Object)clazz);
    }

    public LocaleConverter lookup(Class clazz, Locale locale) {
        LocaleConverter converter = (LocaleConverter)this.lookup(locale).get((Object)clazz);
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("LocaleConverter:" + converter));
        }
        return converter;
    }

    protected FastHashMap lookup(Locale locale) {
        FastHashMap localeConverters;
        if (locale == null) {
            localeConverters = (FastHashMap)this.mapConverters.get((Object)this.defaultLocale);
        } else {
            localeConverters = (FastHashMap)this.mapConverters.get((Object)locale);
            if (localeConverters == null) {
                localeConverters = this.create(locale);
                this.mapConverters.put((Object)locale, (Object)localeConverters);
            }
        }
        return localeConverters;
    }

    protected FastHashMap create(Locale locale) {
        FastHashMap converter = new FastHashMap();
        converter.setFast(false);
        converter.put((Object)(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = LocaleConvertUtilsBean.class$("java.math.BigDecimal")) : class$java$math$BigDecimal), (Object)new BigDecimalLocaleConverter(locale, this.applyLocalized));
        converter.put((Object)(class$java$math$BigInteger == null ? (class$java$math$BigInteger = LocaleConvertUtilsBean.class$("java.math.BigInteger")) : class$java$math$BigInteger), (Object)new BigIntegerLocaleConverter(locale, this.applyLocalized));
        converter.put((Object)(class$java$lang$Byte == null ? (class$java$lang$Byte = LocaleConvertUtilsBean.class$("java.lang.Byte")) : class$java$lang$Byte), (Object)new ByteLocaleConverter(locale, this.applyLocalized));
        converter.put(Byte.TYPE, (Object)new ByteLocaleConverter(locale, this.applyLocalized));
        converter.put((Object)(class$java$lang$Double == null ? (class$java$lang$Double = LocaleConvertUtilsBean.class$("java.lang.Double")) : class$java$lang$Double), (Object)new DoubleLocaleConverter(locale, this.applyLocalized));
        converter.put(Double.TYPE, (Object)new DoubleLocaleConverter(locale, this.applyLocalized));
        converter.put((Object)(class$java$lang$Float == null ? (class$java$lang$Float = LocaleConvertUtilsBean.class$("java.lang.Float")) : class$java$lang$Float), (Object)new FloatLocaleConverter(locale, this.applyLocalized));
        converter.put(Float.TYPE, (Object)new FloatLocaleConverter(locale, this.applyLocalized));
        converter.put((Object)(class$java$lang$Integer == null ? (class$java$lang$Integer = LocaleConvertUtilsBean.class$("java.lang.Integer")) : class$java$lang$Integer), (Object)new IntegerLocaleConverter(locale, this.applyLocalized));
        converter.put(Integer.TYPE, (Object)new IntegerLocaleConverter(locale, this.applyLocalized));
        converter.put((Object)(class$java$lang$Long == null ? (class$java$lang$Long = LocaleConvertUtilsBean.class$("java.lang.Long")) : class$java$lang$Long), (Object)new LongLocaleConverter(locale, this.applyLocalized));
        converter.put(Long.TYPE, (Object)new LongLocaleConverter(locale, this.applyLocalized));
        converter.put((Object)(class$java$lang$Short == null ? (class$java$lang$Short = LocaleConvertUtilsBean.class$("java.lang.Short")) : class$java$lang$Short), (Object)new ShortLocaleConverter(locale, this.applyLocalized));
        converter.put(Short.TYPE, (Object)new ShortLocaleConverter(locale, this.applyLocalized));
        converter.put((Object)(class$java$lang$String == null ? (class$java$lang$String = LocaleConvertUtilsBean.class$("java.lang.String")) : class$java$lang$String), (Object)new StringLocaleConverter(locale, this.applyLocalized));
        converter.put((Object)(class$java$sql$Date == null ? (class$java$sql$Date = LocaleConvertUtilsBean.class$("java.sql.Date")) : class$java$sql$Date), (Object)new SqlDateLocaleConverter(locale, "yyyy-MM-dd"));
        converter.put((Object)(class$java$sql$Time == null ? (class$java$sql$Time = LocaleConvertUtilsBean.class$("java.sql.Time")) : class$java$sql$Time), (Object)new SqlTimeLocaleConverter(locale, "HH:mm:ss"));
        converter.put((Object)(class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = LocaleConvertUtilsBean.class$("java.sql.Timestamp")) : class$java$sql$Timestamp), (Object)new SqlTimestampLocaleConverter(locale, "yyyy-MM-dd HH:mm:ss.S"));
        converter.setFast(true);
        return converter;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

