/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.xss.impl.style;

import java.io.IOException;
import java.io.StringReader;
import org.apache.batik.css.parser.Parser;
import org.apache.sling.xss.impl.style.ValidatingDocumentHandler;
import org.apache.sling.xss.impl.xml.AntiSamyPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.InputSource;

public class BatikCssCleaner {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final AntiSamyPolicy.CssPolicy cssPolicy;
    private static final String CDATA_PRE = "<![CDATA[";
    private static final String CDATA_POST = "]]>";

    public BatikCssCleaner(AntiSamyPolicy.CssPolicy cssPolicy) {
        this.cssPolicy = cssPolicy;
    }

    public String cleanStylesheet(String untrustedCss) {
        try {
            if (untrustedCss.startsWith(CDATA_PRE) && untrustedCss.endsWith(CDATA_POST)) {
                untrustedCss = untrustedCss.substring(CDATA_PRE.length(), untrustedCss.length() - CDATA_POST.length());
            }
            Parser parser = new Parser();
            ValidatingDocumentHandler handler = new ValidatingDocumentHandler(this.cssPolicy, false);
            parser.setDocumentHandler(handler);
            parser.parseStyleSheet(new InputSource(new StringReader(untrustedCss)));
            return handler.getValidCss();
        }
        catch (IOException | CSSException e) {
            this.logger.warn("Unexpected error while cleaning stylesheet", (Throwable)e);
            return "";
        }
    }

    public String cleanStyleDeclaration(String untrustedCss) {
        try {
            Parser parser = new Parser();
            ValidatingDocumentHandler handler = new ValidatingDocumentHandler(this.cssPolicy, true);
            parser.setDocumentHandler(handler);
            parser.parseStyleDeclaration(new InputSource(new StringReader(untrustedCss)));
            return handler.getValidCss();
        }
        catch (IOException | CSSException e) {
            this.logger.warn("Unexpected error while cleaning style declaration", (Throwable)e);
            return "";
        }
    }
}

